/*****************************************************************************
                               Public Domain
-----------------------------------------------------------------------------
   System   	  : IBM PC/AT and compatibles
   Programm-Modul : OS9 Format
 -----------------------------------------------------------------------------
   file-name	  : os9.h
   date     	  : 21.11.1993
   last change	  : 21.11.1993
   version   	  : 1.00
   authors  	  : Wilfried Weigelt
   last author	  : Wilfried Weigelt

   description	  : Definitions related to OS9

   inputs         : ----
   outputs        : ----
   return value   : ---- 

   history:		  : 
   Initial Version                                             21.11.93  WEW
*****************************************************************************/
#define OS9INC 1

#ifndef BOOLEAN
# define BOOLEAN int
# define TRUE 1
# define FALSE 0
#define OS9 TRUE
#define MSDOS FALSE
#define INIT (-1)
#endif

#define UNIVERSAL 1
#define X8W7 2
#define UNKNOWN 3
#define ALLOC_START 1       /* Start LSN of Allocation map */
#define ALLOC_SIZE  2       /* Size of Allocation Map in sectors */

/* OS9 Attribut Bit Positions */
#define OS9_R 0           /* User Readable */
#define OS9_W 1           /* User Writeable */
#define OS9_E 2           /* User Executeable */
#define OS9_PR 3          /* Public readable */
#define OS9_PW 4          /* Public writeable */
#define OS9_PE 5          /* Public executeable */
#define OS9_S  6          /* Shareable */
#define OS9_DI 7          /* Directory */

#define READ_ONLY 0
#define HIDDEN    1
#define SYSTEM    2
#define ID        3
#define ARCHIVE   4
#define U_READ    5
#define U_WRITE   6
#define U_EXE     7
#define P_READ    8
#define P_WRITE   9
#define P_EXE     10
#define SHARE     11
#define RE1_1     12
#define RE1_2     13
#define RE1_3     14
#define DIR       15



/*----------------------------------------------------------------------*/

typedef struct                      /* Os9 Directory Entry */
{
    char dir_name[28];              /* File name */
    unsigned char dir_addr[4];      /* LSN of File descriptor sector */
} dirent;
/*----------------------------------------------------------------------*/

typedef struct             /* OS-9 File allocation entry in Filedescriptor */
{
   unsigned char addr[3];    /* LSN of beginning of block */
   unsigned char size[2];    /* block size in sectors */
} fdseg;
/*----------------------------------------------------------------------*/
typedef struct           /* Structure of OS9 Filedescriptors */
{                        /* length = 256 bytes */
    unsigned char fd_att,  /* File Attributes: D S PE PW PR E W R */
	 fd_own[2],       /* Owners user id */
	 fd_date[5],      /* Date last modified Y M D H M */
	 fd_link,         /* Link Count */
	 fd_fsize[4],     /* File size ( number of bytes ) */
	 fd_dcr[3];       /* Date created Y M D (correct ?) */
    fdseg fd_seg[48];     /* Segment list */
} fildes;
/*-----------------------------------------------------------------------*/

typedef struct           /* Structure of OS9 Identification Sektor (LSN 0) */
{                        /* is everytime first Sector on Track 0 (x8W7) */
    unsigned char dd_tot[3];      /* Sectorcount */
    unsigned char dd_tks;         /* track count */
    unsigned char dd_map[2];      /* Size of alloction map in bytes */
    unsigned char dd_bit[2];      /* cluster size */
    unsigned char dd_dir[3];      /* LSN of root Directory file descriptor*/
    unsigned char dd_own[2];      /* Owner ID */
    unsigned char dd_att;         /* Attributes */
    unsigned char dd_dsk[2];      /* Disk Id */
    unsigned char dd_fmt;         /* Disk Format: density /sides         */
			   /*     Bit 0: 0 = single side */
			   /*            1 = double side */
			   /*     Bit 1: 0 = single density */
			   /*            1 = double density */
			   /*     Bit 2: 0 = single track (48 tpi ) */
			   /*            1 = double track (96 tpi ) */
    unsigned char dd_spt[2];      /* sectors per track */
    unsigned char dd_res[2];      /* reserved for future use */
    unsigned char dd_bt[3];       /* OS 9 system bootstrap LSN */
    unsigned char dd_bsz[2];      /* size of os9 system bootstrap */
    unsigned char dd_date[5];     /* Creation date */
    unsigned char dd_name[32];    /* Volume Name */
    unsigned char dd_opt[32];     /* Path descriptor Options */
    unsigned char dd_res1;        /* Reserve (vers 2.4) */
    unsigned char dd_sync[4];     /* Media Integrity code (vers 2.4)*/
    unsigned char dd_null[156];   /* unused */
} ddsect;

