/****************************************************************************
                               Public Domain
 ----------------------------------------------------------------------------
   System   	  : IBM PC/AT and compatibles
   Programm-Modul : os9 Format
 ----------------------------------------------------------------------------
   file-name	  : mark_bit.c
   date     	  : 29.02.1992
   last change	  : 22.11.1993
   version   	  : 1.00
   authors  	  : Wilfried Weigelt
   last author	  : Wilfried Weigelt

   description	  : This function marks one or more clusters in the
   allocation map as 'in use'.

   inputs         : ----
   outputs        : ----
   return value   : ---- 

   history:		  : 
   Initial Version                                             29.02.92 WEW
   Adapted from check os9 disk to format os9 disk              22.11.93 WEW
****************************************************************************/
#include "prototyp.h"

void mark_bit(lsn,anz_sek,alloc,clu_size)
unsigned long lsn;
unsigned long anz_sek;
unsigned char *alloc;
unsigned long clu_size;
{

    unsigned long alloc_bit;
    unsigned long n;
    unsigned long alloc_byte;

    for (n=lsn; n<(lsn+anz_sek);n++)
    {
        alloc_byte = n / (clu_size * 8);
        alloc_bit  = n % (clu_size * 8);
        alloc_bit /= clu_size;
        alloc[(int)alloc_byte] |= (unsigned char)(0x80 >> alloc_bit);
    }
}
