#include <math.h>
#include <graphics.h>
#include "ca.h"
#define NULL 0
void CLife::cycle()
{
	if(!dirty)		//If none of the neighbors changed
		return;	

	short live;
	live = neighbors.countLive();

	if(live==2 || live == 3)
		{
		if(!lifeState && live == 3)
			{
			newState = TRUE;	//A better implementation would have a newstate
			neighbors.dirty();	//that updates the dirty neighbors
			graphic->draw(TRUE);
			}
		}
	else
		{
		if(lifeState)
			{
			newState = FALSE;
			neighbors.dirty();
			graphic->draw(FALSE);
			}
		}
}

short CLifeList::countLive()
{
	CNode *counter;
	short liveCount =0;
	counter = top;


	while(counter)	//Loop until null pointer
		{
		if((counter->getLife())->isLive())
			liveCount ++;
		counter = counter->getNext();
		}

	return liveCount;
}

short CLifeList::addLife(CLife *toAdd)
{
	CNode *newNode = new CNode;
	if(!cells)	   					//check for initial cell
		{
		top = newNode;
		bottom = newNode;
		}
	else
		{
		newNode->setPrev(bottom);
		bottom->setNext(newNode);
		bottom = newNode;
		}
	newNode->setLife(toAdd);
	current = newNode;		//make the new one current (like we care!!!)
	cells++;				//Cells counter
	return 0;
}

void CLifeList::dirty()
{
	CNode *counter;
	counter = top;

	while(counter)	//Loop until null pointer
		{
		(counter->getLife())->setDirty();
		counter = counter->getNext();
		}
}

void CLifeList::associateCells()
{
	long counter;
	//We are going to make this into a circular list for the length of
	//this routine.
	//In the words of Dewhurst/Stark "The only positive point one can make
	//about the implementation is that it took only a few minutes to write"
	top->setPrev(bottom);
	bottom->setNext(top);

	CNode *back, *front, *temp;
	long  root;
	back=top;
	front=top;
	root = sqrt(cells);
	for(counter=0;counter<root;counter++)	//Get pointed to the neighbors
		{
		back=back->getPrev();
		front=front->getNext();
		}

	temp=top;
	for(counter=0;counter<cells;counter++)	//register the neighbors
		{
		(temp->getLife())->addNeighbor((back->getPrev())->getLife());
		(temp->getLife())->addNeighbor(back->getLife());
		(temp->getLife())->addNeighbor((back->getNext())->getLife());
		(temp->getLife())->addNeighbor((front->getPrev())->getLife());
		(temp->getLife())->addNeighbor(front->getLife());
		(temp->getLife())->addNeighbor((front->getNext())->getLife());
		(temp->getLife())->addNeighbor((temp->getPrev())->getLife());
		(temp->getLife())->addNeighbor((temp->getNext())->getLife());
		back = back->getNext();
		front = front->getNext();
		temp = temp->getNext();
		}

	//Make the list non-circular again
	top->setPrev(NULL);
	bottom->setNext(NULL);
}

void CLifeList::cycle()
{
	CNode *temp;

	temp = top;
	while(temp)
		{
		(temp->getLife())->cycle();
		temp = temp->getNext();
		}
}
void CLifeList::update()
{
	CNode *temp;

	temp = top;
	while(temp)
		{
		(temp->getLife())->update();
		temp = temp->getNext();
		}
}

void CGraphic::draw(BOOL on)
{
	if(on)
		setcolor(15);
	else
		setcolor(0);

	rectangle ( x * 5, y * 5, x * 5 + 4, y * 5 + 4 );
	return;
}


