#include "ca.h"
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <time.h>
#include <iostream.h>
#include <graphics.h>
#include <alloc.h>
//defines the number of cells on a side.  main will create a square
//NOTE that DOS's goofy memory barrier prevents us from going
//with very large life simulations.  The development machine
//has 620K of free base and cannot support a larger array
//than 45.

#define CELLS 45

int    GraphDriver;		/* The Graphics device driver		*/
int    GraphMode;		   /* The Graphics mode value		*/
double AspectRatio;		/* Aspect ratio of a pixel on the screen*/
int    MaxX, MaxY;		/* The maximum resolution of the screen */
int    MaxColors;		   /* The maximum # of colors available	*/
int    ErrorCode;		   /* Reports any graphics errors		*/
struct palettetype palette;		/* Used to read palette info	*/

void GraphInit();

main()
{
	CLife *life;
	CLifeList lifeList;
	long counter, totalCells = CELLS * CELLS;

	srand( (unsigned)time( NULL ) );
	for(counter = 0; counter < totalCells; counter++)	//create the cells
		{
		life = new CLife;
		if(rand()%100>50)			//Create a random startup
			life->setLife(TRUE);
		CGraphic *graphic = new CGraphic(counter / CELLS, counter % CELLS);
		life->setGraphic(graphic);
		lifeList.addLife(life);
		}

	//Now tell the cells who their neighbors are
	lifeList.associateCells();
	lifeList.update();
	lifeList.dirty();

	GraphInit();

	while(TRUE)
		{
		lifeList.cycle();
		lifeList.update();
		//sleep(1);
		if(kbhit())
			exit(0);
		}
}

void
GraphInit()
{
	GraphDriver = DETECT; 		      /* Request auto-detection	*/

	initgraph( &GraphDriver, &GraphMode, "" );
	printf(" Graphics System Error: %s\n", grapherrormsg( graphresult()) );

	setgraphmode( GraphMode );
	ErrorCode = graphresult();		   /* Read result of initialization*/

	if( ErrorCode != grOk )          /* Error occured during init	*/
		{
		printf(" Graphics System Error: %s\n", grapherrormsg( ErrorCode ) );
		exit( 1 );
		}

	getpalette( &palette );		      /* Read the palette from board	*/
	MaxColors = getmaxcolor() + 1;	/* Read maximum number of colors*/

	MaxX = getmaxx();
	MaxY = getmaxy();			         /* Read size of screen */
}

