typedef int BOOL;
#define TRUE 1
#define FALSE 0

class CLife;
class CNode
{
private:
	CNode *prev, *next;
	CLife *life;
protected:
public:
	CNode() {prev=0;next=0;life=0;}
	CNode* getPrev() {return prev;}
	CNode* getNext() {return next;}
	CLife* getLife() {return life;}
	void setPrev(CNode *set) {prev=set;}
	void setNext(CNode *set) {next=set;}
	void setLife(CLife *set) {life=set;}
};


class CLifeList		//Implements a double linked non-circular list
{
private:
	CNode *top;
	CNode *current;
	CNode *bottom;
	long  cells;
protected:
public:
	CLifeList() {cells=0;}
	CLife *getLife() {return current->getLife();}
	void skip() {current = current->getNext();}
	void goTop() {current=top;}
	short addLife(CLife *toAdd);
	short countLive();		//Used for cycling and status
	void dirty();			//Mark all the cells in the container as dirty
	void associateCells(); //Update the cells neighbors
	void cycle();			//cycle all the cells in the list
	void update();			//update all the cells in the list

};

class CGraphic
{
// This class implements the graphics that will be displayed
private:
	short x, y;	//A better implementation would have a location class
protected:
public:
	void draw(BOOL on);	//draw a graphic of the life.
	CGraphic(short inx, short iny) { x=inx; y=iny; }
};

class CLife
{
private:
	BOOL lifeState;
	BOOL newState;
	BOOL newDirty;
	BOOL dirty;
	CLifeList neighbors;
	CGraphic  *graphic;
protected:
public:
	CLife() {graphic=0;}
	void setLife(BOOL alive) {newState = alive;}
	BOOL isLive() {return lifeState;}
	void cycle();	//Checks the status of neighbors to determine life prospects
	void update() {lifeState=newState; dirty=newDirty; newDirty=FALSE;}
	short addNeighbor(CLife *add) {return neighbors.addLife(add);}
	void setDirty() {newDirty = TRUE;}
	void setGraphic( CGraphic *newGraphic ) {graphic=newGraphic;}
};

