
/***************************************************************************
 *								           *
 *  PROGRAM	: Test.c                                                   *
 *									   *
 *  PURPOSE	: Illustrates the use of functions and messages for	   *
 *		  owner-draw, single select list box with strings.         *
 *                Selected list box item will draw with red text on blue;  *
 *                ordinary list boxes would require changing system colors *
 *                to change the selected item's colors.                    *
 *                                                                         *
 *                See the WM_DRAWITEM and WM_MEASUREITEM message handling  *
 *                code and comments in the ListBoxExample function.        *
 *									   *
 *  FUNCTIONS	: WinMain ()        -  Creates the app. window and         *
 *				       enters the message loop.            *
 *                                                                         *
 *		  OwnListInit ()    -  Registers the main window class     *
 *                                                                         *
 *                OwnListWndProc () -  Main window procedure for app.      *
 *                                                                         *
 *		  ListBoxExample () -  Dialog function for the text        *
 *				       list box dialog.		           *
 *									   *
 *		  HandleSelectionState () - Draw item for selected state.  *
 *									   *
 *		  HandleFocusState ()     - Draw item for focus state.     *
 *									   *
 ***************************************************************************/

#include "windows.h"
#include "test.h"

#define NUMSTRINGS 14            // number of items in list box

LPDRAWITEMSTRUCT    lpdis;       // pointer to list box item to draw
LPMEASUREITEMSTRUCT lpmis;       // pointer to list box item to define height
HANDLE              hInst;       // handle to instance of application
HWND                hWndList;    // handle to the list box window
char                szBuf[80];   // list box item string buffer

char *szTest[] = {               // list box strings
	"Omega",
	"Epsilon",
	"Gama",
	"Delta",
	"Lamba",
	"Alpha",
	"Omicron",
	"Pi",
	"Beta",
	"Sigma",
        "Phi",
        "Chi",
        "Xi",
        "Zeta"
     };


/****************************************************************************
 *								            *
 *  FUNCTION   : WinMain(HANDLE, HANDLE, LPSTR, int)                        *
 *					                                    *
 *  PURPOSE    : Creates the app. window and enters the message loop.	    *
 *									    *
 ****************************************************************************/
int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)

HANDLE hInstance, hPrevInstance;
LPSTR lpCmdLine;
int nCmdShow;
{
    HWND  hWnd;
    MSG   msg;

    if (!hPrevInstance)
	if (!OwnListInit (hInstance))
	    return (NULL);

    hInst = hInstance;

    /* Create the app. window */
    hWnd = CreateWindow ("test",
			 "Owner-draw List Box Example",
			 WS_OVERLAPPEDWINDOW,
			 CW_USEDEFAULT,
			 CW_USEDEFAULT,
			 CW_USEDEFAULT,
			 CW_USEDEFAULT,
			 (HWND) NULL,
			 NULL,
			 hInstance,
			 (LPSTR) NULL);

    if (!hWnd)
	return (NULL);

    ShowWindow (hWnd, nCmdShow);

    while (GetMessage (&msg, NULL, NULL, NULL)){
	TranslateMessage (&msg);
	DispatchMessage (&msg);
    }

    return(msg.wParam);
}


/****************************************************************************
 *									    *				     *
 *  FUNCTION   : OwnListInit (hInstance)                                    *
 *									    *				  *
 *  PURPOSE    : Registers the main window class.                           *
 *									    *				  *
 *  RETURNS    : TRUE  - if RegisterClass () succeeds.                      *
 *		 FALSE - if RegisterClass () fails.                         *
 *									    *				  *
 ****************************************************************************/
BOOL NEAR PASCAL OwnListInit (hInstance)
HANDLE hInstance;
{
    HANDLE     hMemory;
    PWNDCLASS  pWndClass;
    BOOL       bSuccess;

    /* Allocate for and fill class structure. */
    hMemory = LocalAlloc (LPTR, sizeof (WNDCLASS));
    pWndClass = (PWNDCLASS) LocalLock (hMemory);

    pWndClass->style        = NULL;
    pWndClass->lpfnWndProc  = OwnListWndProc;
    pWndClass->hInstance    = hInstance;
    pWndClass->hIcon        = LoadIcon (hInstance, NULL);
    pWndClass->hCursor      = LoadCursor (NULL, IDC_ARROW);
    pWndClass->hbrBackground= GetStockObject (WHITE_BRUSH);
    pWndClass->lpszMenuName = (LPSTR) "OwnListMenu",
    pWndClass->lpszClassName= (LPSTR) "test";

    bSuccess = RegisterClass (pWndClass);

    LocalUnlock (hMemory);
    LocalFree (hMemory);

    return (bSuccess);
}


/****************************************************************************
 *								            *
 *  FUNCTION   : OwnListWndProc(hWnd, message, wParam, lParam)              *
 *								            *
 *  PURPOSE    : Window function for the app. It handles menu selections    *
 *		 and processes window WM_ messages.			    *
 *									    *
 ****************************************************************************/
long FAR PASCAL OwnListWndProc (hWnd, message, wParam, lParam)
HWND	 hWnd;
unsigned message;
WORD	 wParam;
LONG	 lParam;
{
    FARPROC          lpProc;
    HMENU            hMenu;
    LPDRAWITEMSTRUCT dis;
    RECT             rc;
    int              i;

    switch (message)
        {
        case WM_COMMAND:
            switch (wParam) {
                case IDM_EXIT:
                    DestroyWindow (hWnd);
                    break;

                case IDM_LISTBOX:
                    /* Bring up the List box example */
                    lpProc = MakeProcInstance (ListBoxExample, hInst);
                    DialogBox (hInst, "LISTBOXDIALOG", hWnd, lpProc);
                    FreeProcInstance (lpProc);
                    break;
            }
            break;

        case WM_DESTROY:
            PostQuitMessage (0);
            break;

        default:
            return DefWindowProc (hWnd, message, wParam, lParam);
    }
    return(NULL);
}

/*==========================================================================*/
/*								            */
/*  FUNCTION   : ListBoxExample(hWnd, message, wParam, lParam) 	            */
/*								            */
/*  PURPOSE    : Dialog function for the text List dialog. The pushbuttons  */
/*		 send various messages to the List box and the edit control */
/*		 when selected. They allow the user to vary data sent with  */
/*		 each message.					            */
/*==========================================================================*/

BOOL FAR PASCAL ListBoxExample (hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
    HBRUSH      hBrush;
    HBRUSH      hOldBrush;
    HDC         hDC;            /* Display Context handle */
    TEXTMETRIC  tm;             /* text information structure */
    int	        i;


  switch (message) {

/*--------------------------------------------------------------------------*/
/*                      I N I T I A L I Z A T I O N                         */
/*--------------------------------------------------------------------------*/

    case WM_INITDIALOG:
        // Add strings to list box
        hWndList = GetDlgItem(hDlg, ID_LISTBOX);
        for (i = 0; i < NUMSTRINGS; ++i)
            SendMessage(hWndList, LB_ADDSTRING, 0, (LONG)(LPSTR)szTest[i]);

        SetFocus( GetDlgItem(hDlg, IDOK) );
        break;

/*--------------------------------------------------------------------------*/
/*                  C O M M A N D   M E S S A G E                           */
/*--------------------------------------------------------------------------*/
    case WM_COMMAND:
        // Terminate dialog box
        if ( wParam == IDOK ) {
            EndDialog (hDlg,NULL);
            return TRUE;
        }
        break;

/*--------------------------------------------------------------------------*/
/*               O W N W E R   D R A W   M E S S A G E S                    */
/*--------------------------------------------------------------------------*/

    // handle drawing any and every list box item
    case WM_DRAWITEM:
        // Copy pointer to the DRAWITEMSTRUCT from lParam to convient variable
        lpdis = (LPDRAWITEMSTRUCT)lParam;

        // if there are no items in the control yet indicate focus
        if (lpdis->itemID == -1) {
            HandleFocusState();
            return (TRUE);
        }

        // normal/any item draw action -- checks for selection and focus
        if (lpdis->itemAction & ODA_DRAWENTIRE) {
            // Use the itemID to get to the text string
            SendMessage( hWndList, LB_GETTEXT,
                (WORD)lpdis->itemID, (LONG)(LPSTR)szBuf );

            // Handle both selected and unselected states, so this
            //   itemAction's code could be combined with ODA_SELECT's.
            //   Typically, the selection state is an addition to drawing
            //   the normal state, but in this case the selection state
            //   is being draw differently, so don't draw normal state
            //   if selected.
            HandleSelectionState();

            // Handle focus state if necessary
            if (lpdis->itemState & ODS_FOCUS)
                HandleFocusState();

            return TRUE;
        }

        // selected/unselected item draw action -- red text on blue background
        if (lpdis->itemAction & ODA_SELECT) {
            // Use the itemID to get to the text string
            SendMessage( hWndList, LB_GETTEXT,
                (WORD)lpdis->itemID, (LONG)(LPSTR)szBuf );
            HandleSelectionState();

            // Handle focus state if necessary
            if (lpdis->itemState & ODS_FOCUS)
                HandleFocusState();

            return TRUE;
        }

        // focus/unfocus item draw action -- dashed rectangular border
        if (lpdis->itemAction & ODA_FOCUS) {
            HandleFocusState();
            return TRUE;
        }

        break;

    // provide height dimension for list box items
    case WM_MEASUREITEM:
        /* get and use height of system font for drawing */
        lpmis = (LPMEASUREITEMSTRUCT)lParam;
        hDC = GetDC (hDlg);                     /* get device context */
        GetTextMetrics (hDC, &tm);              /* get text information */
        lpmis->itemHeight = tm.tmHeight;
        ReleaseDC (hDlg, hDC);                  /* release device context */
        return (TRUE);

    default:
        return (FALSE);

  } // switch(message)

  return FALSE;

}

/*==========================================================================*/
/*									    */
/*  FUNCTION   : void HandleSelectionState(void)	                    */
/*									    */
/*  PURPOSE    : Handles indicating selection of item by drawing text red   */
/*               on blue background.                                        */
/*									    */
/*==========================================================================*/
void HandleSelectionState(void)
{
    HBRUSH hBrush;
    DWORD  dwOldTextColor, dwOldBkColor;

    // if selected, draw selected item's text red, highlight rectangle blue
    if (lpdis->itemState & ODS_SELECTED) {
        // draw blue background rectangle
        hBrush = CreateSolidBrush( RGB(0,0,255) ); // blue
        FillRect( lpdis->hDC, (LPRECT)&lpdis->rcItem, hBrush );
        DeleteObject( hBrush );

        // change text and back ground color of list box's selection
        dwOldTextColor =
            SetTextColor( lpdis->hDC, RGB(255,0,0) ); // red text characters
        dwOldBkColor =
            SetBkColor( lpdis->hDC, RGB(0,0,255) );   // text cell blue bkground
        TextOut (lpdis->hDC,
            (int)(lpdis->rcItem.left),
            (int)(lpdis->rcItem.top),
            (LPSTR)szBuf,
            lstrlen(szBuf) );
        // restore text and back ground color of list box's selection
        SetTextColor( lpdis->hDC, dwOldTextColor );
        SetBkColor( lpdis->hDC, dwOldBkColor );
    }
    // unselected; draw normally in black text on white background
    else {
        // draw white back ground rectangle
        hBrush = GetStockObject( WHITE_BRUSH );
        FillRect( lpdis->hDC, (LPRECT)&lpdis->rcItem, hBrush );
        // draw normal text
        TextOut (lpdis->hDC,
            (int)(lpdis->rcItem.left),
            (int)(lpdis->rcItem.top),
            (LPSTR)szBuf,
            lstrlen(szBuf) );
    }
    return;
}

/*==========================================================================*/
/*									    */
/*  FUNCTION   : void HandleFocusState(void)	                            */
/*									    */
/*  PURPOSE    : Handles indicating focus of control with black dashed      */
/*               rectangular border.                                        */
/*									    */
/*==========================================================================*/
void HandleFocusState(void)
{
    DrawFocusRect( lpdis->hDC, (LPRECT) &lpdis->rcItem );
    return;
}

/*--------------------------------------------------------------------------*/
