//----------------------------------------------------------------------
//			 File:	ilistbox.cpp
//
//	 	   Author:	Dave Parfrey
//
//			 Date:	March, 1992
//
//		C++ class methods for IndirectListBox, a TListBox that takes
//		a (far) pointer to a string instead of the string itself.  Uses
//		an owner-draw ListBox to accomplish this.
//----------------------------------------------------------------------
#include <owl.h>

#include "ilistbox.h"

//----------------------------------------------------------------------
//		Function:	IndirectListBox::IndirectListBox
//
//	  Parameters:	same as TButton
//
//		 returns:	N/A
//
//		Constructors for IndirectListBox (full and resource versions)
//----------------------------------------------------------------------
IndirectListBox::IndirectListBox(PTWindowsObject AParent, int AnId,
				int X, int Y, int W, int H, PTModule AModule) :
				TListBox(AParent, AnId, X, Y, W, H, AModule)
{
	Attr.Style &= ~LBS_SORT;
	Attr.Style &= ~LBS_HASSTRINGS;
	Attr.Style |= LBS_OWNERDRAWFIXED;

	textHeight = 0;
}
IndirectListBox::IndirectListBox(PTWindowsObject AParent, int ResourceId,
				PTModule AModule) :
				TListBox(AParent, ResourceId, AModule)
{
	Attr.Style &= ~LBS_SORT;
	Attr.Style &= ~LBS_HASSTRINGS;
	Attr.Style |= LBS_OWNERDRAWFIXED;

	textHeight = 0;
}
//----------------------------------------------------------------------
//		Function:	IndirectListBox::ODADrawEntire
//
//	  Parameters:	DRAWITEMSTRUCT
//
//		 returns:	N/A
//
//		Called when an item in the list box is to be redrawn
//----------------------------------------------------------------------
void IndirectListBox::ODADrawEntire(DRAWITEMSTRUCT far & DrawInfo)
{
	DrawThisItem (DrawInfo);
}
//----------------------------------------------------------------------
//		Function:	IndirectListBox::ODAFocus
//
//	  Parameters:	DRAWITEMSTRUCT
//
//		 returns:	N/A
//
//		Called when focus changes for a listbox item (draws the focus
//		Rect.)
//----------------------------------------------------------------------
void IndirectListBox::ODAFocus(DRAWITEMSTRUCT far & DrawInfo)
{
	RECT rect = DrawInfo.rcItem;

	if (textHeight <= 0)
		SetTextHeight(DrawInfo.hDC);

	rect.top = rect.bottom-textHeight;
	DrawFocusRect (DrawInfo.hDC, &rect);
}
//----------------------------------------------------------------------
//		Function:	IndirectListBox::ODASelect
//
//	  Parameters:	DRAWITEMSTRUCT
//
//		 returns:	N/A
//
//		Called when the selection state of an item in the listbox changes
//----------------------------------------------------------------------
void IndirectListBox::ODASelect(DRAWITEMSTRUCT far & DrawInfo)
{
	DrawThisItem (DrawInfo);
}
//----------------------------------------------------------------------
//		Function:	IndirectListBox::DrawThisItem
//
//	  Parameters:	DRAWITEMSTRUCT
//
//		 returns:	N/A
//
//		Redraws an item in the listbox
//----------------------------------------------------------------------
void IndirectListBox::DrawThisItem(DRAWITEMSTRUCT far & DrawInfo)
{
	HBRUSH hBrush, hBrushOriginal;

	if (textHeight <= 0)
		SetTextHeight(DrawInfo.hDC);

	RECT rect = DrawInfo.rcItem;
	rect.top = rect.bottom-textHeight;

	LPSTR lpText = GetTextString(DrawInfo.itemData);

	if (lpText == NULL)
		return;

	if (DrawInfo.itemState & ODS_SELECTED)
	{
		SetBkColor (DrawInfo.hDC, GetSysColor(COLOR_HIGHLIGHT));
		SetTextColor (DrawInfo.hDC, GetSysColor(COLOR_HIGHLIGHTTEXT));
		hBrush = CreateSolidBrush (GetSysColor(COLOR_HIGHLIGHT));
	}
	else
	{
		SetBkColor (DrawInfo.hDC, GetSysColor(COLOR_WINDOW));
		SetTextColor (DrawInfo.hDC, GetSysColor(COLOR_WINDOWTEXT));
		hBrush = CreateSolidBrush (GetSysColor(COLOR_WINDOW));
	}

	hBrushOriginal = SelectObject(DrawInfo.hDC, hBrush);
	FillRect (DrawInfo.hDC, &rect, hBrush);
	SelectObject (DrawInfo.hDC, hBrushOriginal);
	DeleteObject(hBrush);

	DrawText(DrawInfo.hDC, lpText, strlen(lpText), &rect, DT_LEFT | DT_SINGLELINE);

	if (DrawInfo.itemState & ODS_FOCUS)
		DrawFocusRect (DrawInfo.hDC, &rect);
}

//----------------------------------------------------------------------
//		Function:	IndirectListBox::SetTextHeight
//
//	  Parameters:	handle to Device Context
//
//		 returns:	N/A
//
//		Sets the text height for drawing from the text metrics
//----------------------------------------------------------------------
void IndirectListBox::SetTextHeight (HDC hDC)
{
	TEXTMETRIC tm;

	GetTextMetrics (hDC, &tm);

	textHeight = tm.tmHeight;
}

//----------------------------------------------------------------------
//		Function:	IndirectListBox::GetTextString
//
//	  Parameters:	Data to get string out of
//
//		 returns:	pointer to the string to use
//
//		This default method assumes that the data stored in the listbox
//		is REALLY a pointer to a string.  If you store other objects in
//		the listbox, you need to override this method.
//
//		Returns the text string to display in the listbox.
//----------------------------------------------------------------------
LPSTR IndirectListBox::GetTextString(DWORD data)
{
	LPSTR lpText = (LPSTR) data;
	return lpText;
}
