//----------------------------------------------------------------------
//			 File:	ilistbox.cpp
//
//	 	   Author:	Dave Parfrey
//
//			 Date:	March, 1992
//
//		C++ class definitions for IndirectListBox, a TListBox that takes
//		a (far) pointer to a string instead of the string itself.  Uses
//		an owner-draw ListBox to accomplish this.
//
//		Note that this type of listbox is NOT SORTED!  I didn't need it,
//		so I didn't do it.  However, it's pretty simple to add sorting.
//----------------------------------------------------------------------
#if !defined(ILISTBOX_INCLUDED)
#define ILISTBOX_INCLUDED
#include <listbox.h>

_CLASSDEF(IndirectListBox)

class IndirectListBox : public TListBox
{
public:
	IndirectListBox(PTWindowsObject AParent, int AnId, int X, int Y,
					int W, int H, PTModule AModule = NULL);
	IndirectListBox(PTWindowsObject AParent, int ResourceId,
					PTModule AModule = NULL);

	// Some "safe" equivalents of "string" methods for TListBox
	// (Note that methods that treat the item as a REAL string
	//	should NOT be used here!)

	int		AddData(DWORD data) { return AddString ((LPSTR) data); };

	// DeleteData DOES NOT DELETE the memory pointed to by the string.
	// To do this, the parent can handle WM_DELETEITEM or delete it
	// by another means.
	int		DeleteData(int index) { return DeleteString (index); };
	
	int		InsertData(DWORD data, int index)
					{ return InsertString((LPSTR) data, index); };
	int		GetData(LPDWORD *lpData, int index)
					{ return GetString((LPSTR) lpData, index); };

	// if you don't call SetMeasureTextHeight, the first drawing action
	// will read it from the text metrics.  The correct placement for this
	// call is in the WM_MEASUREITEM handler in the parent window.
	void SetMeasureTextHeight (WORD height) { textHeight = height; };
	virtual void SetTextHeight (HDC hDC);	// reads from metrics

protected:
	WORD textHeight;	// height of a line (for use in drawing

	virtual void ODADrawEntire(DRAWITEMSTRUCT far & DrawInfo);
	virtual void ODAFocus(DRAWITEMSTRUCT far & DrawInfo);
	virtual void ODASelect(DRAWITEMSTRUCT far & DrawInfo);

	virtual void DrawThisItem(DRAWITEMSTRUCT far & DrawInfo);

	// obtain text string from data.  Used as text to draw item.
	// Override this for structures.
	virtual LPSTR	GetTextString(DWORD data);
};

#endif // ILISTBOX_INCLUDED


