// ObjectWindows - (C) Copyright 1991 by Borland International

// This is an altered version of the Borland OWL LBOXTEST example
// app.  It uses an owner-draw listbox to break the 64K listbox
// limit.  A structure (FakeStruct) pointer is stored in the listbox
// instead of the full string.  When run, this app will place 8160
// entries in the listbox.

// I also wanted to test Borland's global heap memory allocation 
// scheme (as documented in win.qna/owlwin.qna).  Changing the value
// of amtData shows that there are apparently no immediate problems
// in allocation much more than 64K with "new".

// Feel free to use this code in any way you see fit.  IndirectListBox
// is not intended to be a comprehensive class and is NOT thorougly tested
// outside of this example program!  It's test code that I'm going to
// clean up for use in my app.  However, I AM interested in any
// improvements or fixes you make, as they will surely increase my 
// understanding of Windows.

// Dave Parfrey (Togis) - 71511,404
 
#include <owl.h>
#include <window.h>
#include "ilistbox.h"
#include <strstream.h>

const WORD ID_LISTBOX = 101;

typedef struct
{
	DWORD	unused;
	LPSTR 	text;
} FakeStruct;
typedef FakeStruct far *LPFakeStruct;

_CLASSDEF (FakeListBox)

class FakeListBox : public IndirectListBox
{
public:
	FakeListBox(PTWindowsObject AParent, int AnId, int X, int Y,
					int W, int H, PTModule AModule = NULL) :
		IndirectListBox(AParent, AnId, X, Y, W, H, AModule) {};
protected:
	LPSTR	GetTextString(DWORD data);

};

LPSTR FakeListBox::GetTextString(DWORD data)
{
	LPFakeStruct lpFake = (LPFakeStruct) data;
	return lpFake->text;
}

class TTestApp : public TApplication
{
public:
  TTestApp(LPSTR AName, HANDLE hInstance, HANDLE hPrevInstance,
	LPSTR lpCmdLine, int nCmdShow)
	: TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};
  virtual void InitMainWindow();
};

class TLBoxWindow : public TWindow
{
public:
  PFakeListBox ListBox;
  TLBoxWindow(PTWindowsObject AParent, LPSTR ATitle);
  virtual void SetupWindow();
  virtual BOOL CanClose();
  virtual void HandleListBoxMsg(RTMessage Msg)
	= [ID_FIRST + ID_LISTBOX];
  virtual void WMSetFocus(RTMessage Msg) =
	[WM_FIRST + WM_SETFOCUS];
	// WMMeasureItem(RTMessage Msg) =
	//	    [WM_FIRST + WM_MEASUREITEM];
};

TLBoxWindow::TLBoxWindow(PTWindowsObject AParent, LPSTR ATitle) :
  TWindow(AParent, ATitle)
{
  ListBox = new FakeListBox(this, ID_LISTBOX, 20, 20, 340, 100);
}

BOOL TLBoxWindow::CanClose()
{
	int i;
	LPFakeStruct junk;

	int num = ListBox->GetCount();

	for (i=0; i < num; i++)
	{
		ListBox->GetData((LPDWORD *) &junk, i);
		if (junk != NULL)
		{
			delete junk->text;
			delete junk;
		}
	}
	return TRUE;
}

void TLBoxWindow::SetupWindow()
{
	int i;
	char string[25];
	long nChars = 0;
	LPFakeStruct junk;
	const amtData = 100;

	TWindow::SetupWindow();
	for (i=1; i < 10000; i++)
	{
		junk = new FakeStruct;
		junk->text = new char [amtData];
		wsprintf(junk->text, "Item Number %d, a very great number", i);

		if (ListBox->AddData((DWORD) junk) < 0)
		{
			delete junk->text;
			delete junk;
			break;
		}
		nChars += amtData;
	}
	wsprintf(string, "Added %ld chars", nChars);
	MessageBox(HWindow, string, "Count", MB_OK);
}

void TLBoxWindow::HandleListBoxMsg(RTMessage Msg)
{
	int Idx, len;
	LPFakeStruct junk;

	if ( Msg.LP.Hi == LBN_DBLCLK )
	{
		Idx = ListBox->GetSelIndex();
		len = ListBox->GetStringLen(Idx);
		if ( len == sizeof(junk))
		{
			ListBox->GetData((LPDWORD *) &junk, Idx);
			MessageBox(HWindow, junk->text, "You selected:", MB_OK);
		}
	}
}

/* When the TLBoxWindow gets focus, pass it on to the list box.
   This could also be done by calling EnableKBHandler in the 
   TLBoxWindow constructor (see lbxttest.cpp). */
void TLBoxWindow::WMSetFocus(RTMessage)
{
  SetFocus(ListBox->HWindow);
}

#if (0)
void TLBoxWindow::WMMeasureItem(RTMessage Msg)
{
	LPMEASUREITEMSTRUCT lpItemStruct = (LPMEASUREITEMSTRUCT)(Msg.LParam);

	ListBox->SetMeasureTextHeight(lpItemStruct->itemHeight);
}
#endif

void TTestApp::InitMainWindow()
{
  MainWindow = new TLBoxWindow(NULL, Name);
}

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
  LPSTR lpCmdLine, int nCmdShow)          
{
  TTestApp TestApp("List Box Tester", hInstance, hPrevInstance,
    lpCmdLine, nCmdShow);
  TestApp.Run();
  return TestApp.Status;
}
