/*
 * dcstream.h
 *
 * classes for creating streamable windows Device Contexts
 */

#ifndef _DCSTREAM_H
#define _DCSTREAM_H

#include <owldefs.h>								// included for _EXPxxx macros to make DLL's
#include <stdarg.h>
#include <iostream.h>
#include <iomanip.h>
#include <windows.h>
#include <gdiobjec.h>
#include "iomanip2.h"

/*
	odcstream usage notes:

	1. odcstream is usually used within the OWL Paint() function.

	2. odcstream requires a dcstreambuf to operate.  I recommend that you include an instance
		of dcstreambuf as a member of the TWindow derived object.  Since dcstreambuf is not
		created and deleted every time a Paint update occurs, it speeds up window painting.

	3. odcstreambuf should be instantiated after Viewport and Window mapping modes are
		set up to insure proper operation.
 */

class _EXPCLASS odcstream;						// required or friend class tdcstream will define

class _EXPCLASS dcstreambuf: public streambuf
{
	public:

		dcstreambuf( unsigned int = 512 );	// create streambuf attached to a device context
		~dcstreambuf( void );					// deletes buffer buf

	protected:

		HDC
			hDC;

		char
			*buf;

		TEXTMETRIC
			tm;

		int											// use ints for window location like TextOut
			x0,
			x,											// horizontal position to place text
			y,											// vertical position to place text
			ydir,										// 1 = increasing y down, -1 = increasing y up
			*tabs;									// array of tab stops

		unsigned int
			bufsiz,									// size of the stream buffer
			tabType,									// determines tabbing method
			itab,										// current tab stop index
			ntabs;									// number of elements in tabs

		virtual int overflow( int );			// buffer is full, do sunc the load in arg to buffer
		virtual int sync( void );				// outputs contents of buffer to window hDC

		int gettab( int );						// for a tab index get tab location
		void settabs( unsigned int, int* );	// set up tab stops
		int hardtab( void );						// returns a tab stop for a tab index
		int ansitab( void );						// ansi.sys like handling of tabs

	friend class odcstream;

};

class _EXPCLASS odcstream: public TDC, public ostream
{
	public:

		odcstream( HDC, dcstreambuf* );		// odcstream constructor
		odcstream( HDC, dcstreambuf& );		// odcstream constructor
//		~odcstream( void );						// destructor, deletes wstreambuf and tabs

		int x( int );								// place TextOut calls to this horizontal point
		int y( int );								// place TextOut calls to this vertical point
		int x( void );								// get last x location
		int y( void );								// get last y location

		POINT xy( int, int );					// place TextOut calls to these coordinates
		POINT point( POINT );					// ditto. Uses Windows POINT struct

		void hardtab( void );					// set tab style to hard tabs
		void ansitab( void );					// set tab style to ansi style

		void tab( int );							// set tab stops to equal steps
		void tabs( unsigned int, int* );		// set tab stops to passed in array of ints
		void tabs( unsigned int, ... );		// set tabs stops to n ...

	private:
		void init( void );						// called by constructors

};

/*
 * inline odcstream constructors for speed
 */
inline odcstream::odcstream( HDC hdc, dcstreambuf *buf ):
	TDC( hdc ), ostream( buf ) { init(); };

inline odcstream::odcstream( HDC hdc, dcstreambuf &buf ):
	TDC( hdc ), ostream( &buf ) { init(); };

inline void odcstream::init( void )
{
	TSize
		wp,
		vp;

	dcstreambuf
		&sb = *(dcstreambuf*)rdbuf();

	sb.hDC = *this;
	wp = GetWindowExt();
	vp = GetViewportExt();
	sb.ydir = ( (long)wp.cy * (long)vp.cy > 0 )? 1: -1;
};

/*
 * odcstream manipulators
 *
 * the manipulators can be used as:
 *		odc << gotox( int )
 *		odc << gotoy( int )
 *		odc << gotoxy( int, int )
 *		odc << tab( 4 )
 *
 * these are inlined - for some reason they don't export
 * from a DLL correctly
 */
inline ostream& odc_x_( ostream& os, int x )
{
	((odcstream&)os).x( x );
	return os;
}

inline ostream& odc_y_( ostream& os, int y )
{
	((odcstream&)os).y( y );
	return os;
}

inline ostream& odc_xy_( ostream& os, int x, int y )
{
	((odcstream&)os).xy( x, y );
	return os;
}

inline ostream& odc_tab_( ostream& os, int t )
{
	((odcstream&)os).tab( t );
	return os;
}

inline omanip<int> gotox( int x )
{
	return omanip<int>( odc_x_, x );
}

inline omanip<int> gotoy( int y )
{
	return omanip<int>( odc_y_, y );
}

inline omanip2<int,int> gotoxy( int x, int y )
{
	return omanip2<int,int>( odc_xy_, x, y );
}

inline omanip<int> tab( int t )
{
	return omanip<int>( odc_tab_, t );
}

#endif


