/*  
	iomanip2.h -- streams I/O manipulator declarations
		for functions of 2 arguments

*/

/*	Copied From:
 *		C/C++ Run Time Library - Version 6.02
 *
 *		Copyright (c) 1990, 1993 by Borland International
 *		All Rights Reserved.
 *
 */

#ifndef __cplusplus
#error Must use C++ for the io stream manipulators.
#endif

#ifndef __IOMANIP2_H
#define __IOMANIP2_H

#include <_defs.h>
#include <iostream.h>


template<class typ, class typ2> 
class _EXPCLASS smanip2 
{
		ios& (*_fn)(ios&, typ, typ2);
		typ _ag;
		typ2 _ag2;

	public:
		smanip2( ios& (*_f)(ios&, typ), typ _a, typ2 _a2 ):
			_fn(_f), _ag(_a), _ag2(_a2) { }

	friend istream& operator >> ( istream& _s, smanip2<typ, typ2>& _f ) 
	{
		(*_f._fn)(_s, _f._ag, _f._ag2); 
		return _s; 
	}

	friend ostream& operator << ( ostream& _s, smanip2<typ, typ2>& _f )
	{
		(*_f._fn)(_s, _f._ag, _f._ag2); 
		return _s; 
	}
};

template<class typ, class typ2>
class _EXPCLASS sapp2 
{
		ios& (*_fn)(ios&, typ);

	public:
		sapp2( ios& (*_f)(ios&, typ, typ2) ): _fn(_f) { }

		smanip2<typ, typ2> operator()( typ _z, typ2 _z2 )
		{ return smanip2<typ, typ2>(_fn, _z, _z2); }
};

template<class typ, class typ2>
class _EXPCLASS imanip2 
{
		istream& (*_fn)(istream&, typ);
		typ _ag;
		typ2 _ag2;

	public:
		imanip2( istream& (*_f)(istream&, typ, typ2), typ _z, typ2 _z2 ):
			_fn(_f), _ag(_z), _ag2(_z2) { }

	friend istream& operator >> ( istream& _s, imanip2<typ, typ2>& _f )
	{ return(*_f._fn)(_s, _f._ag, _f._ag2); }

};

template<class typ, class typ2> 
class _EXPCLASS iapply2 
{
		istream& (*_fn)(istream&, typ, typ2);

	public:
		iapply2( istream& (*_f)(istream&, typ, typ2) ): _fn(_f) { }

		imanip2<typ, typ2> operator()( typ _z, typ2 _z2 )
		{ return imanip2<typ, typ2>(_fn, _z, _z2); }
};

template<class typ, class typ2> 
class _EXPCLASS omanip2 
{
		ostream& (*_fn)(ostream&, typ, typ2);
		typ _ag;
		typ2 _ag2;

	public:
		omanip2( ostream& (*_f)(ostream&, typ, typ2), typ _z, typ2 _z2 ):
			_fn(_f), _ag(_z), _ag2(_z2) { }

		friend ostream& operator << ( ostream& _s, omanip2<typ, typ2>& _f )
		{ return(*_f._fn)(_s, _f._ag, _f._ag2); }
};

template<class typ, class typ2> 
class _EXPCLASS oapp2 
{
		ostream& (*_fn)(ostream&, typ, typ2);
	
	public:
		oapp2( ostream& (*_f)(ostream&, typ, typ2) ):
					_fn(_f) { }
		omanip2<typ, typ2> operator()( typ _z, typ2 _z2 )
		{ return omanip2<typ, typ2>(_fn, _z, _z2); }
};

template<class typ, class typ2> 
class _EXPCLASS iomanip2
{
		iostream& (*_fn)(iostream&, typ, typ2);
		typ _ag;
		typ2 _ag2;
	
	public:
		iomanip2( iostream& (*_f)(iostream&, typ, typ2), typ _z, typ2 _z2 ):
			_fn(_f), _ag(_z), _ag2(_z2) { }

		friend istream& operator >> ( iostream& _s, iomanip2<typ, typ2>& _f )
		{ return(*_f._fn)(_s, _f._ag, _f._ag2); }

		friend ostream& operator << ( iostream& _s, iomanip2<typ, typ2>& _f )
		{ return(*_f._fn)(_s, _f._ag, _f._ag2); }
};

template<class typ, class typ2> 
class _EXPCLASS ioapp2 
{
		iostream& (*_fn)(iostream&, typ, typ2);

	public:
		ioapp2( iostream& (*_f)(iostream&, typ, typ2) ): 
			_fn(_f) { }

		iomanip2<typ, typ2> operator()( typ _z, typ2 _z2 )
		{ return iomanip2<typ, typ2>(_fn, _z, _z2); }
};

#endif	// __IOMANIP2_H
