/*
 * dcstream.cpp
 *
 * function definitions for Microsoft Windows based
 * Device Context streams
 */

#include "dcstream.h"

#define NEWLINE	'\n'
#define TAB			'\t'
#define CRETURN	'\r'

#define TAB_ANSI	1
#define TAB_HARD	2

/*
 * class dcstreambuf
 */
dcstreambuf::dcstreambuf( unsigned int size ): streambuf()
{
	bufsiz = size;
	buf = new char[bufsiz];						// create ostream buffer
	setbuf( buf, bufsiz );						// set buffer pointers base_ and ebuf_
	setp( buf, buf+bufsiz );					// set put pointers pbase_ and pptr_
	tabType = TAB_HARD;							// default tab mehtod
	x0 = x = y = itab = 0;						// init text location variables
	tabs = NULL;									// let tab fcns know that the tab array is unallocated
}

dcstreambuf::~dcstreambuf( void )
{
	delete buf;
	if( tabs )
		delete tabs;
}

int dcstreambuf::overflow( int c )			// used of the buffer space - dump what we have to the window hDC
{
	if( sync() )									// this will flush the buffer
		return sputc( c );						// put the requested char into the now empty buffer
	else												// failure in sync() TextOut call
   	return EOF;									// let caller know we can't go on like this
}

int dcstreambuf::sync()							// flushes out the buffer with calls to TextOut
{
	if( !out_waiting() )							// if nothing in the buffer, return 
		return TRUE;								// TRUE says everything is OK

	GetTextMetrics( hDC, &tm );				// update TextMetrics values before outputting

	char
		*b = pbase(),								// find start of put buffer pbase_
		*p = pptr();								// find last+1 location of put buffer pptr_

	unsigned int
		len;

	for( char *w = b; w != p; w++ )			// walk thru buffer from base to last put loc using w
	{
   	switch( *w )
		{
			case TAB:
	        	len = (unsigned int)( w - b );
				TextOut( hDC, x, y, b, len );							// put what we have to window hDC
				x += LOWORD( GetTextExtent( hDC, b, len ) );		// update x position after string
				x = x0 + ( (tabType == TAB_ANSI)? ansitab(): hardtab() );
				b = w + 1;													// put base after newline
				break;

			case NEWLINE:
				len = (unsigned int)( w - b );
				TextOut( hDC, x, y, b, len );				// put what we have to window hDC
				x = x0;											// reset x to origin
				y += ydir * tm.tmHeight;					// move down the screen independent of mapping mode
				itab = 0;										// reset tab index
				b = w + 1;										// put base after newline
				break;

			case CRETURN:
				len = (unsigned int)( w - b );
				TextOut( hDC, x, y, b, len );				// put what we have to window hDC
				x += LOWORD( GetTextExtent( hDC, b, len ) );	// update x position after string
				b = w + 1;										// put base after newline
				break;
		}
	}
	len = (unsigned int)( w - b );
	TextOut( hDC, x, y, b, len );							// output the text
	x += LOWORD( GetTextExtent( hDC, b, len ) );		// increment x by the length of the TextOut string
	setp( buf, buf+bufsiz );								// reset the put pointers
	return TRUE;												// always successful
}

int dcstreambuf::gettab( int n )							// compute # of chars to tab over
{
	if( !n || !ntabs )										// either no tabs spec'd or 0'th tab
		return 0;
	else if( ntabs == 1 )									// array of one element
		return n*tabs[0];										// multiply index by tab cahr value
	else if( n > ntabs )										// overflowed the tab stop list, find diff of last 2 entries & use difference
		return (n-ntabs)*(tabs[ntabs-1] - tabs[ntabs-2]) + tabs[ntabs-1];
	else															// use element in list
		return tabs[n-1];  
}

void dcstreambuf::settabs( unsigned int n, int *t )
{
	ntabs = n;

	if( tabs )
   	delete tabs;
	tabs = new int[ntabs];

   memcpy( tabs, t, n*sizeof( *tabs ) ); 
}

int dcstreambuf::hardtab( void )							// place the start of text at hard
{																	// tab stops even if overwritten
	return tm.tmAveCharWidth * gettab( ++itab );
}

int dcstreambuf::ansitab( void )							// ansi.sys style tab usage
{
	int
   	&w = tm.tmAveCharWidth;								// char width value
	for( itab++; x > w*gettab( itab ); itab++ );		// find next tab stop greater than present horz position
	return w*gettab( itab );								// return the x location
}

/*
 * class odcstream
 */
int odcstream::x( int xnew )                        // set nex x position
{
	dcstreambuf
		&sb = *(dcstreambuf*)rdbuf();

	int
		xold = sb.x;

	flush();														// empty contents of dcstreambuf to hDC
	sb.itab = 0;												// reset tab index
	sb.x0 = sb.x = xnew;										// set new x position info
	return xold;
}

int odcstream::y( int ynew )								// set new y position
{
	dcstreambuf
		&sb = *(dcstreambuf*)rdbuf();

	int
		yold = sb.y;

	flush();
	sb.itab = 0;
	sb.y = ynew;
	return yold;
}

int odcstream::x( void )
{
	return ((dcstreambuf*)rdbuf())->x;
}

int odcstream::y( void )
{
	return ((dcstreambuf*)rdbuf())->y;
}

POINT odcstream::xy( int xnew, int ynew )
{
	dcstreambuf
		&sb = *(dcstreambuf*)rdbuf();
	POINT
		p = { sb.x, sb.y };
	flush();
	sb.itab = 0;
	sb.x0 = sb.x = xnew;
	sb.y = ynew;
	return p;
}

void odcstream::hardtab( void )
{
	((dcstreambuf*)rdbuf())->tabType = TAB_HARD;
}

void odcstream::ansitab( void )
{
	((dcstreambuf*)rdbuf())->tabType = TAB_ANSI;
}

void odcstream::tab( int i )								// set new tab stops with single entry
{
	((dcstreambuf*)rdbuf())->settabs( 1, &i );
}

void odcstream::tabs( unsigned int n, int *i )		// use new tab list
{
	((dcstreambuf*)rdbuf())->settabs( n, i );
}

void odcstream::tabs( unsigned int n, ... )			// create new tab list, leading int is number of tabs
{
	va_list
		ap;

	va_start( ap, n );

	int
		*t = new int[n];

	for( int i = 0; i < n; i++ )
		t[i] = va_arg( ap, int );

	va_end( ap );
	((dcstreambuf*)rdbuf())->settabs( n, t );
   delete t;
}


