#include "d:\gui\gui.h"
#include "workshop.h"
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <io.h>

//*********************************************************************
//		FUNCTION PROTOTYPES
//*********************************************************************

int save_all_info();
int read_new_info();
void clear_all_info(int);

extern void showmem();
extern redraw_screen();

//*********************************************************************
//		GLOBAL VARIABLES
//*********************************************************************

extern panelrec *panelroot;
extern panelrec *currentpanel;
extern int numpanels;

extern bevelrec *bevelroot;
extern bevelrec *currentbevel;
extern int numbevels;

extern checkboxrec *checkboxroot;
extern checkboxrec *currentcheckbox;
extern int numcheckboxes;

extern radiorec *radioroot;
extern radiorec *currentradio;
extern int numradios;

extern iconrec *iconroot;
extern iconrec *currenticon;
extern int numicons;

extern stringrec *stringroot;
extern stringrec *currentstring;
extern int numstrings;

extern buttonrec *buttonroot;
extern buttonrec *currentbutton;
extern int numbuttons;

extern Line line_info[100];
extern int numlines;

extern textrec *textroot;
extern textrec *currenttext;
extern int numtexts;

extern Mcursor the_mouse;

//*********************************************************************
//		SAVE_ALL_INFO
//*********************************************************************


//**************************************************************************
//		FIRST PORTION OF THIS CODE SAVES THE .COD FILE INFORMATION
//**************************************************************************

int save_all_info()
{
	FILE *fp;
	char buffer[20];
	int i;
	char ULX[4],ULY[4],W[4],H[4],L[4],LRX[4],LRY[4],COL[4],THICKNESS[4];
	char codename[MAXPATH],scrname[MAXPATH],filename[MAXPATH];
	dirbox far *db;

	db=new dirbox;
	db->set_mask("*.scr");
	strcpy(filename,db->trackdir());
	delete db;

	for(i=0;i<strlen(filename);i++)
		if(filename[i]=='.') {
			filename[i]=0;
			break;
			}
	strcpy(codename,filename);
	strcat(codename,".cod");
	strcpy(scrname,filename);
	strcat(scrname,".scr");

	if((access(scrname,0))==0) {
		printf("\a");
		if((Messagebox("File Exists!  Overwrite?",MB_YESNO))==ID_NO)
			return 0;
		}
	fp=fopen(codename,"wt");
	if(!fp)
		return 0;

//**************************************************************************
//BEVELS
savebevels:
	if(bevelroot==(bevelrec *)NULL)
		goto savepanels;
	currentbevel=bevelroot;

	while(currentbevel!=NULL) {

//WRITE DECLARATION
		strcpy(buffer,"Bevel");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer," ");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,currentbevel->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,";\n");
		fwrite(buffer,strlen(buffer),1,fp);

//WRITE DEFINITION
		strcpy(buffer,currentbevel->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,".init(");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(currentbevel->bevel->Getx(),ULX,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(currentbevel->bevel->Gety(),ULY,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(currentbevel->bevel->Getw(),W,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(currentbevel->bevel->Geth(),H,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		if(!currentbevel->bevel->Getthick())
			strcpy(buffer,"THICK");
		else
			strcpy(buffer,"THIN");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,");\n");
		fwrite(buffer,strlen(buffer),1,fp);

		currentbevel=currentbevel->next;
		}

//WRITE SHOW
	currentbevel=bevelroot;
	while(currentbevel->next!=NULL) {
		strcpy(buffer,currentbevel->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,".show();\n");
		fwrite(buffer,strlen(buffer),1,fp);
		currentbevel=currentbevel->next;
		}
	if(bevelroot!=(bevelrec *)NULL) {
		strcpy(buffer,"\n");
		fwrite(buffer,strlen(buffer),1,fp);
		}

//**************************************************************************
//PANELS
savepanels:
	if(panelroot==(panelrec *)NULL)
		goto savebuttons;
	currentpanel=panelroot;

	while(currentpanel!=NULL) {

//WRITE DECLARATION
		strcpy(buffer,"Panel");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer," ");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,currentpanel->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,";\n");
		fwrite(buffer,strlen(buffer),1,fp);

//WRITE DEFINITION
		strcpy(buffer,currentpanel->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,".init(");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(currentpanel->panel->Getx(),ULX,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(currentpanel->panel->Gety(),ULY,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(currentpanel->panel->Getw(),W,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(currentpanel->panel->Geth(),H,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		if(!currentpanel->panel->Getin())
			strcpy(buffer,"IN");
		else
			strcpy(buffer,"OUT");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		if(!currentpanel->panel->Getthick())
			strcpy(buffer,"THICK");
		else
			strcpy(buffer,"THIN");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,");\n");
		fwrite(buffer,strlen(buffer),1,fp);

		currentpanel=currentpanel->next;
		}

//WRITE SHOW
	currentpanel=panelroot;
	while(currentpanel->next!=NULL) {
		strcpy(buffer,currentpanel->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,".show();\n");
		fwrite(buffer,strlen(buffer),1,fp);
		currentpanel=currentpanel->next;
		}
	if(panelroot!=(panelrec *)NULL) {
		strcpy(buffer,"\n");
		fwrite(buffer,strlen(buffer),1,fp);
		}

//**************************************************************************
//BUTTONS
savebuttons:
	if(buttonroot==NULL)
		goto savegstrings;
	currentbutton=buttonroot;
	while(currentbutton!=NULL) {

//WRITE DECLARATION
		strcpy(buffer,"Button");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer," ");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,currentbutton->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,";\n");
		fwrite(buffer,strlen(buffer),1,fp);

//WRITE DEFINITION
		strcpy(buffer,currentbutton->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,".init(");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(currentbutton->button->Getx(),ULX,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(currentbutton->button->Gety(),ULY,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,"\"");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,currentbutton->button->Getcontents());
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,"\"");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		if(currentbutton->button->Getformat())
			strcpy(buffer,"IMAGE");
		else
			strcpy(buffer,"TEXT");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,");\n");
		fwrite(buffer,strlen(buffer),1,fp);

		currentbutton=currentbutton->next;
		}

//WRITE SHOW
	currentbutton=buttonroot;
	while(currentbutton!=NULL) {
		strcpy(buffer,currentbutton->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,".show();\n");
		fwrite(buffer,strlen(buffer),1,fp);
		currentbutton=currentbutton->next;
		}
	if(buttonroot!=NULL) {
		strcpy(buffer,"\n");
		fwrite(buffer,strlen(buffer),1,fp);
		}

//**************************************************************************
//GSTRINGS
savegstrings:
	if(stringroot==NULL)
		goto savegradios;
	currentstring=stringroot;
	while(currentstring!=NULL) {

//WRITE DECLARATION
		strcpy(buffer,"Gstring");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer," ");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,currentstring->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,";\n");
		fwrite(buffer,strlen(buffer),1,fp);

//WRITE DEFINITION
		strcpy(buffer,currentstring->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,".init(");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(currentstring->string->Getx(),ULX,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(currentstring->string->Gety(),ULY,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);

		strcpy(buffer,itoa(currentstring->string->Getlength(),L,10));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		if(currentstring->string->is_ucase())
			strcpy(buffer,"1");
		else
			strcpy(buffer,"0");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,");\n");
		fwrite(buffer,strlen(buffer),1,fp);

		currentstring=currentstring->next;
		}

//WRITE SHOW
	currentstring=stringroot;
	while(currentstring!=NULL) {
		strcpy(buffer,currentstring->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,".show();\n");
		fwrite(buffer,strlen(buffer),1,fp);
		currentstring=currentstring->next;
		}
	if(stringroot!=NULL) {
		strcpy(buffer,"\n");
		fwrite(buffer,strlen(buffer),1,fp);
		}

//**************************************************************************
//GRADIOS
savegradios:
	if(radioroot==NULL)
		goto savegcheckboxes;
	currentradio=radioroot;
	while(currentradio!=NULL) {

//WRITE DECLARATION
		strcpy(buffer,"Gradio");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer," ");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,currentradio->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,";\n");
		fwrite(buffer,strlen(buffer),1,fp);

//WRITE DEFINITION
		strcpy(buffer,currentradio->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,".init(");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(currentradio->radio->Getx(),ULX,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(currentradio->radio->Gety(),ULY,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);

		strcpy(buffer,"\"");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,currentradio->radio->Gettext());
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,"\"");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,");\n");
		fwrite(buffer,strlen(buffer),1,fp);

		currentradio=currentradio->next;
		}

//WRITE SHOW
	currentradio=radioroot;
	while(currentradio!=NULL) {
		strcpy(buffer,currentradio->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,".show();\n");
		fwrite(buffer,strlen(buffer),1,fp);
		currentradio=currentradio->next;
		}
	if(radioroot!=NULL) {
		strcpy(buffer,"\n");
		fwrite(buffer,strlen(buffer),1,fp);
		}

//**************************************************************************
//GCHECKBOXES
savegcheckboxes:
	if(checkboxroot==NULL)
		goto saveicons;
	currentcheckbox=checkboxroot;
	while(currentcheckbox!=NULL) {

//WRITE DECLARATION
		strcpy(buffer,"Gcheckbox");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer," ");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,currentcheckbox->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,";\n");
		fwrite(buffer,strlen(buffer),1,fp);

//WRITE DEFINITION
		strcpy(buffer,currentcheckbox->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,".init(");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(currentcheckbox->checkbox->Getx(),ULX,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(currentcheckbox->checkbox->Gety(),ULY,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);

		strcpy(buffer,"\"");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,currentcheckbox->checkbox->Gettext());
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,"\"");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,");\n");
		fwrite(buffer,strlen(buffer),1,fp);

		currentcheckbox=currentcheckbox->next;
		}

//WRITE SHOW
	currentcheckbox=checkboxroot;
	while(currentcheckbox!=NULL) {
		strcpy(buffer,currentcheckbox->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,".show();\n");
		fwrite(buffer,strlen(buffer),1,fp);
		currentcheckbox=currentcheckbox->next;
		}
	if(checkboxroot!=NULL) {
		strcpy(buffer,"\n");
		fwrite(buffer,strlen(buffer),1,fp);
		}

//**************************************************************************
//ICONS
saveicons:
	if(iconroot==NULL)
		goto savegtexts;
	currenticon=iconroot;
	while(currenticon!=NULL) {

//WRITE DECLARATION
		strcpy(buffer,"Icon");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer," ");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,currenticon->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,";\n");
		fwrite(buffer,strlen(buffer),1,fp);

//WRITE DEFINITION
		strcpy(buffer,currenticon->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,".init(");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(currenticon->icon->Getx(),ULX,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(currenticon->icon->Gety(),ULY,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,"\"");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,currenticon->icon->Getfilename());
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,"\"");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,");\n");
		fwrite(buffer,strlen(buffer),1,fp);
		currenticon=currenticon->next;
		}

//WRITE SHOW
	currenticon=iconroot;
	while(currenticon!=NULL) {
		strcpy(buffer,currenticon->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,".show();\n");
		fwrite(buffer,strlen(buffer),1,fp);
		currenticon=currenticon->next;
		}
	if(iconroot!=NULL) {
		strcpy(buffer,"\n");
		fwrite(buffer,strlen(buffer),1,fp);
		}

//**************************************************************************
//GTEXTS
savegtexts:
	char FGD[4],BGD[4],SIZE[4];
	if(textroot==NULL)
		goto savelines;
	currenttext=textroot;
	while(currenttext!=NULL) {

//WRITE DECLARATION
		strcpy(buffer,"Gtext");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer," ");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,currenttext->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,";\n");
		fwrite(buffer,strlen(buffer),1,fp);

//WRITE DEFINITION
		strcpy(buffer,currenttext->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,".init(");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(currenttext->text->Getx(),ULX,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(currenttext->text->Gety(),ULY,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,"\"");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,currenttext->text->Gettext());
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,"\"");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);

		strcpy(buffer,itoa(currenttext->text->Getfgd(),FGD,10));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,itoa(currenttext->text->Getbgd(),BGD,10));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,itoa(currenttext->text->Getsize(),SIZE,10));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,");\n");
		fwrite(buffer,strlen(buffer),1,fp);

		currenttext=currenttext->next;
		}

//WRITE SHOW
	currenttext=textroot;
	while(currenttext!=NULL) {
		strcpy(buffer,currenttext->name);
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,".show();\n");
		fwrite(buffer,strlen(buffer),1,fp);
		currenttext=currenttext->next;
		}
	if(textroot!=NULL) {
		strcpy(buffer,"\n");
		fwrite(buffer,strlen(buffer),1,fp);
		}

//**************************************************************************
//LINES
savelines:
	char NL[4];
	char I[4];

	if(numlines>0) {

//WRITE DECLARATION
		strcpy(buffer,"Line");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer," ");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,"lines[");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,itoa(numlines,NL,10));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,"];\n");
		fwrite(buffer,strlen(buffer),1,fp);

//WRITE DEFINITION
	for(i=0;i<numlines;i++) {
		strcpy(buffer,"lines[");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,itoa(i,I,10));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,"].init(");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(line_info[i].Getx(),ULX,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(line_info[i].Gety(),ULY,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(line_info[i].Getx2(),LRX,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(line_info[i].Gety2(),LRY,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(line_info[i].Getcolor(),COL,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,",");
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,(itoa(line_info[i].Getstyle(),THICKNESS,10)));
		fwrite(buffer,strlen(buffer),1,fp);
		strcpy(buffer,");\n");
		fwrite(buffer,strlen(buffer),1,fp);
		}

//WRITE SHOW
	strcpy(buffer,"for(int numlines=0;numlines<");
	fwrite(buffer,strlen(buffer),1,fp);
	strcpy(buffer,itoa(numlines,NL,10));
	fwrite(buffer,strlen(buffer),1,fp);
	strcpy(buffer,";numlines++)\n\tlines[numlines].show();");
	fwrite(buffer,strlen(buffer),1,fp);
	}

	fclose(fp);

//**************************************************************************
//		SECOND PORTION OF THIS FILE SAVES THE CFG FILE FOR RETRIEVING
//**************************************************************************
	int *counts;
	counts=new int;
	fp=fopen(scrname,"wb");
	if(!fp)
		return 0;

bevelstruct bs;
//write the number of bevels to the file
	*counts=numbevels;
	fwrite(counts,sizeof(int),1,fp);

//write all the bevel info to the file
	if(bevelroot==(bevelrec *)NULL)
		goto writepanels;
	currentbevel=bevelroot;
	while(currentbevel!=(bevelrec *)NULL) {
		strcpy(bs.name,currentbevel->name);
		bs.ulx=currentbevel->bevel->Getx();
		bs.uly=currentbevel->bevel->Gety();
		bs.w=currentbevel->bevel->Getw();
		bs.h=currentbevel->bevel->Geth();
		bs.thick=currentbevel->bevel->Getthick();

		fwrite(&bs,sizeof(bevelstruct),1,fp);
		currentbevel=currentbevel->next;
		}

writepanels:
panelstruct ps;
//write the number of panels to the file
	*counts=numpanels;
	fwrite(counts,sizeof(int),1,fp);

//write all the panel info to the file
	if(panelroot==(panelrec *)NULL)
		goto writebuttons;
	currentpanel=panelroot;
	while(currentpanel!=(panelrec *)NULL) {
		strcpy(ps.name,currentpanel->name);
		ps.ulx=currentpanel->panel->Getx();
		ps.uly=currentpanel->panel->Gety();
		ps.w=currentpanel->panel->Getw();
		ps.h=currentpanel->panel->Geth();
		ps.in=currentpanel->panel->Getin();
		ps.thick=currentpanel->panel->Getthick();

		fwrite(&ps,sizeof(panelstruct),1,fp);
		currentpanel=currentpanel->next;
		}

writebuttons:
buttonstruct btns;
//write the number of buttons to the file
	*counts=numbuttons;
	fwrite(counts,sizeof(int),1,fp);

//write all the button info to the file
	if(buttonroot==NULL)
		goto writeicons;
	currentbutton=buttonroot;
	while(currentbutton!=NULL) {
		strcpy(btns.name,currentbutton->name);
		btns.ulx=currentbutton->button->Getx();
		btns.uly=currentbutton->button->Gety();
		strcpy(btns.cont,currentbutton->button->Getcontents());
		btns.img=currentbutton->button->Getformat();

		fwrite(&btns,sizeof(buttonstruct),1,fp);
		currentbutton=currentbutton->next;
		}

writeicons:
iconstruct is;
//write the number of icons to the file
	*counts=numicons;
	fwrite(counts,sizeof(int),1,fp);

//write all the icon info to the file
	if(iconroot==NULL)
		goto writegstrings;
	currenticon=iconroot;
	while(currenticon!=NULL) {
		strcpy(is.name,currenticon->name);
		is.ulx=currenticon->icon->Getx();
		is.uly=currenticon->icon->Gety();
		strcpy(is.cont,currenticon->icon->Getfilename());

		fwrite(&is,sizeof(iconstruct),1,fp);
		currenticon=currenticon->next;
		}

writegstrings:
gstringstruct gs;
//write the number of gstrings to the file
	*counts=numstrings;
	fwrite(counts,sizeof(int),1,fp);

//write all the gstring info to the file
	if(stringroot==NULL)
		goto writeradios;
	currentstring=stringroot;
	while(currentstring!=NULL) {
		strcpy(gs.name,currentstring->name);
		gs.ulx=currentstring->string->Getx();
		gs.uly=currentstring->string->Gety();
		gs.length=currentstring->string->Getlength();
		gs.uc=currentstring->string->is_ucase();

		fwrite(&gs,sizeof(gstringstruct),1,fp);
		currentstring=currentstring->next;
		}

writeradios:
radiostruct rs;
//write the number of radios to the file
	*counts=numradios;
	fwrite(counts,sizeof(int),1,fp);

//write all the radio info to the file
	if(radioroot==NULL)
		goto writecheckboxes;
	currentradio=radioroot;
	while(currentradio!=NULL) {
		strcpy(rs.name,currentradio->name);
		rs.ulx=currentradio->radio->Getx();
		rs.uly=currentradio->radio->Gety();
		strcpy(rs.cont,currentradio->radio->Gettext());

		fwrite(&rs,sizeof(radiostruct),1,fp);
		currentradio=currentradio->next;
		}

writecheckboxes:
checkboxstruct cs;
//write the number of checkboxes to the file
	*counts=numcheckboxes;
	fwrite(counts,sizeof(int),1,fp);

//write all the checkbox info to the file
	if(checkboxroot==NULL)
		goto writelines;
	currentcheckbox=checkboxroot;
	while(currentcheckbox!=NULL) {
		strcpy(cs.name,currentcheckbox->name);
		cs.ulx=currentcheckbox->checkbox->Getx();
		cs.uly=currentcheckbox->checkbox->Gety();
		strcpy(cs.cont,currentcheckbox->checkbox->Gettext());

		fwrite(&cs,sizeof(checkboxstruct),1,fp);
		currentcheckbox=currentcheckbox->next;
		}

writelines:
linestruct ls;
//write the number of lines to the file
	*counts=numlines;
	fwrite(counts,sizeof(int),1,fp);

//write all the line onfo to the file
	for(i=0;i<numlines;i++) {
		ls.x=line_info[i].Getx();
		ls.y=line_info[i].Gety();
		ls.x1=line_info[i].Getx2();
		ls.y1=line_info[i].Gety2();
		ls.color=line_info[i].Getcolor();
		ls.thickness=line_info[i].Getstyle();

		fwrite(&ls,sizeof(linestruct),1,fp);
		}

writegtexts:
textstruct ts;
//write the number of texts to the file
	*counts=numtexts;
	fwrite(counts,sizeof(int),1,fp);

//write all the text info to the file
	if(textroot==NULL)
		goto cleanup;
	currenttext=textroot;
	while(currenttext!=NULL) {
		strcpy(ts.name,currenttext->name);
		ts.ulx=currenttext->text->Getx();
		ts.uly=currenttext->text->Gety();
		strcpy(ts.cont,currenttext->text->Gettext());
		ts.fgd=currenttext->text->Getfgd();
		ts.bgd=currenttext->text->Getbgd();
		ts.size=currenttext->text->Getsize();

		fwrite(&ts,sizeof(textstruct),1,fp);
		currenttext=currenttext->next;
		}

cleanup:
	fclose(fp);
	delete counts;
	redraw_screen();
	return 1;
}

//**************************************************************************
//		READ_NEW_INFO
//**************************************************************************

int read_new_info()
{
	int i,num_objects;
	FILE *fp;
	char scrname[MAXPATH];
	char filename[MAXPATH];
	dirbox far *db;

	db=new dirbox;
	db->set_mask("*.scr");
	strcpy(filename,db->trackdir());
	delete db;

	for(i=0;i<strlen(filename);i++)
		if(filename[i]=='.') {
			filename[i]=0;
			break;
			}
	strcpy(scrname,filename);
	strcat(scrname,".scr");
	if(!(access(scrname,0))==0) {
		printf("\a");
		if((Messagebox("No Such File!",MB_CANCEL))==ID_CANCEL)
			return 0;
		}
	fp=fopen(scrname,"rb");
	if(!fp)
		return 0;

	clear_all_info(FALSE);

//read numbevels and all bevel info
	fread(&numbevels,sizeof(int),1,fp);

	bevelstruct bs;
	for(i=0;i<numbevels;i++) {
		if(bevelroot==(bevelrec *)NULL) {
			bevelroot=new bevelrec;
			bevelroot->previous=bevelroot->next=(bevelrec *)NULL;
			bevelroot->bevel=new Bevel;
			currentbevel=bevelroot;
			}
		else {
			currentbevel=bevelroot;
			while(currentbevel->next!=(bevelrec *)NULL)
				currentbevel=currentbevel->next;
			currentbevel->next=new bevelrec;
			currentbevel->next->bevel=new Bevel;
			currentbevel->next->next=(bevelrec *)NULL;
			currentbevel->next->previous=currentbevel;
			currentbevel=currentbevel->next;
			}
		fread(&bs,sizeof(bevelstruct),1,fp);
		strcpy(currentbevel->name,bs.name);
		currentbevel->bevel->init(bs.ulx,bs.uly,bs.w,bs.h,bs.thick,SAVEBGD);
		}

	fread(&numpanels,sizeof(int),1,fp);

	panelstruct ps;
	for(i=0;i<numpanels;i++) {
		if(panelroot==(panelrec *)NULL) {
			panelroot=new panelrec;
			panelroot->previous=panelroot->next=(panelrec *)NULL;
			panelroot->panel=new Panel;
			currentpanel=panelroot;
			}
		else {
			currentpanel=panelroot;
			while(currentpanel->next!=(panelrec *)NULL)
				currentpanel=currentpanel->next;
			currentpanel->next=new panelrec;
			currentpanel->next->panel=new Panel;
			currentpanel->next->next=(panelrec *)NULL;
			currentpanel->next->previous=currentpanel;
			currentpanel=currentpanel->next;
			}
		fread(&ps,sizeof(panelstruct),1,fp);
		strcpy(currentpanel->name,ps.name);
		currentpanel->panel->init(ps.ulx,ps.uly,ps.w,ps.h,ps.in,ps.thick,SAVEBGD);
		}

	fread(&numbuttons,sizeof(int),1,fp);

	buttonstruct btns;
	for(i=0;i<numbuttons;i++) {
		if(buttonroot==(buttonrec *)NULL) {
			buttonroot=new buttonrec;
			buttonroot->previous=buttonroot->next=(buttonrec *)NULL;
			buttonroot->button=new Button;
			currentbutton=buttonroot;
			}
		else {
			currentbutton=buttonroot;
			while(currentbutton->next!=(buttonrec *)NULL)
				currentbutton=currentbutton->next;
			currentbutton->next=new buttonrec;
			currentbutton->next->button=new Button;
			currentbutton->next->next=(buttonrec *)NULL;
			currentbutton->next->previous=currentbutton;
			currentbutton=currentbutton->next;
			}

		fread(&btns,sizeof(buttonstruct),1,fp);
		strcpy(currentbutton->name,btns.name);
		currentbutton->button->init(btns.ulx,btns.uly,btns.cont,btns.img,SAVEBGD);
		}

	fread(&numicons,sizeof(int),1,fp);

	iconstruct is;
	for(i=0;i<numicons;i++) {
		if(iconroot==(iconrec *)NULL) {
			iconroot=new iconrec;
			iconroot->previous=iconroot->next=(iconrec *)NULL;
			iconroot->icon=new Icon;
			currenticon=iconroot;
			}
		else {
			currenticon=iconroot;
			while(currenticon->next!=(iconrec *)NULL)
				currenticon=currenticon->next;
			currenticon->next=new iconrec;
			currenticon->next->icon=new Icon;
			currenticon->next->next=(iconrec *)NULL;
			currenticon->next->previous=currenticon;
			currenticon=currenticon->next;
			}
		fread(&is,sizeof(iconstruct),1,fp);
		strcpy(currenticon->name,is.name);
		currenticon->icon->init(is.ulx,is.uly,is.cont,SAVEBGD);
		}

	fread(&numstrings,sizeof(int),1,fp);

	gstringstruct gs;
	for(i=0;i<numstrings;i++) {
		if(stringroot==(stringrec *)NULL) {
			stringroot=new stringrec;
			stringroot->previous=stringroot->next=(stringrec *)NULL;
			stringroot->string=new Gstring;
			currentstring=stringroot;
			}
		else {
			currentstring=stringroot;
			while(currentstring->next!=(stringrec *)NULL)
				currentstring=currentstring->next;
			currentstring->next=new stringrec;
			currentstring->next->string=new Gstring;
			currentstring->next->next=(stringrec *)NULL;
			currentstring->next->previous=currentstring;
			currentstring=currentstring->next;
			}

		fread(&gs,sizeof(gstringstruct),1,fp);
		strcpy(currentstring->name,gs.name);
		currentstring->string->init(gs.ulx,gs.uly,gs.length,gs.uc,SAVEBGD);
		}

	fread(&numradios,sizeof(int),1,fp);

	radiostruct rs;
	for(i=0;i<numradios;i++) {
		if(radioroot==(radiorec *)NULL) {
			radioroot=new radiorec;
			radioroot->previous=radioroot->next=(radiorec *)NULL;
			radioroot->radio=new Gradio;
			currentradio=radioroot;
			}
		else {
			currentradio=radioroot;
			while(currentradio->next!=(radiorec *)NULL)
				currentradio=currentradio->next;
			currentradio->next=new radiorec;
			currentradio->next->radio=new Gradio;
			currentradio->next->next=(radiorec *)NULL;
			currentradio->next->previous=currentradio;
			currentradio=currentradio->next;
			}

		fread(&rs,sizeof(radiostruct),1,fp);
		strcpy(currentradio->name,rs.name);
		currentradio->radio->init(rs.ulx,rs.uly,rs.cont,SAVEBGD);
		}

	fread(&numcheckboxes,sizeof(int),1,fp);

	checkboxstruct cs;
	for(i=0;i<numcheckboxes;i++) {
		if(checkboxroot==(checkboxrec *)NULL) {
			checkboxroot=new checkboxrec;
			checkboxroot->previous=checkboxroot->next=(checkboxrec *)NULL;
			checkboxroot->checkbox=new Gcheckbox;
			currentcheckbox=checkboxroot;
			}
		else {
			currentcheckbox=checkboxroot;
			while(currentcheckbox->next!=(checkboxrec *)NULL)
				currentcheckbox=currentcheckbox->next;
			currentcheckbox->next=new checkboxrec;
			currentcheckbox->next->checkbox=new Gcheckbox;
			currentcheckbox->next->next=(checkboxrec *)NULL;
			currentcheckbox->next->previous=currentcheckbox;
			currentcheckbox=currentcheckbox->next;
			}
		fread(&cs,sizeof(checkboxstruct),1,fp);
		strcpy(currentcheckbox->name,cs.name);
		currentcheckbox->checkbox->init(cs.ulx,cs.uly,cs.cont,SAVEBGD);
		}

	fread(&numlines,sizeof(int),1,fp);

	linestruct ls;
	for(i=0;i<numlines;i++) {
		fread(&ls,sizeof(linestruct),1,fp);
		line_info[i].init(ls.x,ls.y,ls.x1,ls.y1,ls.color,ls.thickness);
		}

	fread(&numtexts,sizeof(int),1,fp);

	textstruct ts;
	for(i=0;i<numtexts;i++) {
		if(textroot==(textrec *)NULL) {
			textroot=new textrec;
			textroot->previous=textroot->next=(textrec *)NULL;
			textroot->text=new Gtext;
			currenttext=textroot;
			}
		else {
			currenttext=textroot;
			while(currenttext->next!=(textrec *)NULL)
				currenttext=currenttext->next;
			currenttext->next=new textrec;
			currenttext->next->text=new Gtext;
			currenttext->next->next=(textrec *)NULL;
			currenttext->next->previous=currenttext;
			currenttext=currenttext->next;
			}

		fread(&ts,sizeof(textstruct),1,fp);
		strcpy(currenttext->name,ts.name);
		currenttext->text->init(ts.ulx,ts.uly,ts.cont,ts.fgd,ts.bgd,ts.size,SAVEBGD);
		}

	fclose(fp);
	redraw_screen();
	return 1;
}

//**************************************************************************
//		CLEAR_ALL_INFO
//**************************************************************************

void clear_all_info(int erase_bgd)
{
	int i;

//delete bevels
	if(bevelroot!=(bevelrec *)NULL) {
		currentbevel=bevelroot;
		//find the end of the list
		while(currentbevel->next!=(bevelrec *)NULL)
			currentbevel=currentbevel->next;
		//back up through list deleteing the next record
		while(currentbevel->previous!=(bevelrec *)NULL) {
			currentbevel=currentbevel->previous;
			//delete the end
			currentbevel->next->bevel->elim();
			delete(currentbevel->next->bevel);
			delete(currentbevel->next);
			currentbevel->next=(bevelrec *)NULL;
			}
		//delete the root
		bevelroot->bevel->elim();
		delete(bevelroot->bevel);
		delete(bevelroot);
		bevelroot=(bevelrec *)NULL;
		}

//delete panels
	if(panelroot!=(panelrec *)NULL) {
		currentpanel=panelroot;
		//find the end of the list
		while(currentpanel->next!=(panelrec *)NULL)
			currentpanel=currentpanel->next;
		//back up through list deleteing the next record
		while(currentpanel->previous!=(panelrec *)NULL) {
			currentpanel=currentpanel->previous;
			//delete the end
			currentpanel->next->panel->elim();
			delete(currentpanel->next->panel);
			delete(currentpanel->next);
			currentpanel->next=(panelrec *)NULL;
			}
		//delete the root
		panelroot->panel->elim();
		delete(panelroot->panel);
		delete(panelroot);
		panelroot=(panelrec *)NULL;
		}

//delete buttons
	if(buttonroot!=(buttonrec *)NULL) {
		currentbutton=buttonroot;
		//find the end of the list
		while(currentbutton->next!=(buttonrec *)NULL)
			currentbutton=currentbutton->next;
		//back up through list deleteing the next record
		while(currentbutton->previous!=(buttonrec *)NULL) {
			currentbutton=currentbutton->previous;
			//delete the end
			currentbutton->next->button->elim();
			delete(currentbutton->next->button);
			delete(currentbutton->next);
			currentbutton->next=(buttonrec *)NULL;
			}
		//delete the root
		buttonroot->button->elim();
		delete(buttonroot->button);
		delete(buttonroot);
		buttonroot=(buttonrec *)NULL;
		}

//delete icons
	if(iconroot!=(iconrec *)NULL) {
		currenticon=iconroot;
		//find the end of the list
		while(currenticon->next!=(iconrec *)NULL)
			currenticon=currenticon->next;
		//back up through list deleteing the next record
		while(currenticon->previous!=(iconrec *)NULL) {
			currenticon=currenticon->previous;
			//delete the end
			currenticon->next->icon->elim();
			delete(currenticon->next->icon);
			delete(currenticon->next);
			currenticon->next=(iconrec *)NULL;
			}
		//delete the root
		iconroot->icon->elim();
		delete(iconroot->icon);
		delete(iconroot);
		iconroot=(iconrec *)NULL;
		}

//delete radios
	if(radioroot!=(radiorec *)NULL) {
		currentradio=radioroot;
		//find the end of the list
		while(currentradio->next!=(radiorec *)NULL)
			currentradio=currentradio->next;
		//back up through list deleteing the next record
		while(currentradio->previous!=(radiorec *)NULL) {
			currentradio=currentradio->previous;
			//delete the end
			currentradio->next->radio->elim();
			delete(currentradio->next->radio);
			delete(currentradio->next);
			currentradio->next=(radiorec *)NULL;
			}
		//delete the root
		radioroot->radio->elim();
		delete(radioroot->radio);
		delete(radioroot);
		radioroot=(radiorec *)NULL;
		}

//delete checkboxes
	if(checkboxroot!=(checkboxrec *)NULL) {
		currentcheckbox=checkboxroot;
		//find the end of the list
		while(currentcheckbox->next!=(checkboxrec *)NULL)
			currentcheckbox=currentcheckbox->next;
		//back up through list deleteing the next record
		while(currentcheckbox->previous!=(checkboxrec *)NULL) {
			currentcheckbox=currentcheckbox->previous;
			//delete the end
			currentcheckbox->next->checkbox->elim();
			delete(currentcheckbox->next->checkbox);
			delete(currentcheckbox->next);
			currentcheckbox->next=(checkboxrec *)NULL;
			}
		//delete the root
		checkboxroot->checkbox->elim();
		delete(checkboxroot->checkbox);
		delete(checkboxroot);
		checkboxroot=(checkboxrec *)NULL;
		}

//delete gtexts
	if(textroot!=(textrec *)NULL) {
		currenttext=textroot;
		//find the end of the list
		while(currenttext->next!=(textrec *)NULL)
			currenttext=currenttext->next;
		//back up through list deleteing the next record
		while(currenttext->previous!=(textrec *)NULL) {
			currenttext=currenttext->previous;
			//delete the end
			currenttext->next->text->elim();
			delete(currenttext->next->text);
			delete(currenttext->next);
			currenttext->next=(textrec *)NULL;
			}
		//delete the root
		textroot->text->elim();
		delete(textroot->text);
		delete(textroot);
		textroot=(textrec *)NULL;
		}

//delete gstrings
	if(stringroot!=(stringrec *)NULL) {
		currentstring=stringroot;
		//find the end of the list
		while(currentstring->next!=(stringrec *)NULL)
			currentstring=currentstring->next;
		//back up through list deleteing the next record
		while(currentstring->previous!=(stringrec *)NULL) {
			currentstring=currentstring->previous;
			//delete the end
			currentstring->next->string->elim();
			delete(currentstring->next->string);
			delete(currentstring->next);
			currentstring->next=(stringrec *)NULL;
			}
		//delete the root
		stringroot->string->elim();
		delete(stringroot->string);
		delete(stringroot);
		stringroot=(stringrec *)NULL;
		}

	numbevels=0;
	numpanels=0;
	numbuttons=0;
	numicons=0;
	numradios=0;
	numcheckboxes=0;
	numtexts=0;
	numstrings=0;
	numlines=0;

	if(erase_bgd)
		redraw_screen();
}