//**************************************************************************
//      This is a demo program to show how to use some of the features of
//      the TUI libraries of the ObjectEase package. To compile and run this
//      program create a project file including the files TUI30.LIB
//      (use TUI40.LIB if you are using Borland C++ version 4.0) and
//      TUIDEMO.CPP. Make sure that the files in the project are located where
//      the project says they are. You may also need to modify the path to
//      TUI.H in the #includes portion of this file.
//
//      BE SURE YOU ARE COMPILING FOR THE LARGE MEMORY MODEL!!!
//**************************************************************************

#include "d:\tui\tui.h"
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include <alloc.h>

//*************************  FUNCTION PROTOTYPES  **************************

void initialize();
void introscreen();
void explainscreen();
void windowdemo();
void menudemo();
void pulldowndemo();
void stringdemo();
void buttondemo();
void checkboxdemo();
void listboxdemo();
void dirboxdemo();
void textmousedemo();
void wrapup();

//***************************  GLOBAL VARIABLES  ***************************

extern Mcursor the_mouse;

//**************************************************************************
//              MAIN
//**************************************************************************

void main()
{
	initialize();
	introscreen();
	explainscreen();
	windowdemo();
	menudemo();
	pulldowndemo();
	listboxdemo();
	dirboxdemo();
	stringdemo();
	buttondemo();
	checkboxdemo();
	textmousedemo();
	wrapup();

	settext(7,0);
	cursoron();
	clrscr();
	puts("Thank you for previewing the ObjectEase library from");
	puts("David S. Reinhart Associates");
	exit(0);
}

//**************************************************************************
//              INITIALIZE
//**************************************************************************

void initialize()
{
	char ch;

/*        if(farcoreleft()<=350000) {
		puts("This demo requires a minimum of 350K free memory");
		exit(0);
		}
*/

	clrscr();
	flushkeys();
	if(!the_mouse.init()) {
		puts("Mouse driver not found. If you have a mouse, press <ESC> now");
		puts("to exit and load your mouse driver. Press any other key to continue.");
		ch=getch();
		if(ch==27)
			exit(1);
		}
	cursoroff();
}

//**************************************************************************
//              INTROSCREEN
//**************************************************************************

void introscreen()
{
	int done=0;
	char ch;

	clear(32,1,1);
	dlay(8);
	smoved(37,1,7,14,1,"Welcome");
	dlay(3);
	smover(9,1,35,14,1,"To The World");
	dlay(3);
	smovel(11,79,40,14,1,"Of");
	dlay(3);
	smoveu(31,25,14,15,1,">>>  ObjectEase  <<<");

	Twindow creditwindow;
	creditwindow.init(5,18,76,24,0,3,0,0);
	creditwindow.setborder(DOUBLE);
	creditwindow.zoom();
	creditwindow.title(" DEMO ");
	creditwindow.border();

	creditwindow.wprintc(2,15,3,"The ObjectEase 3.0 TUI Library Demo");
	creditwindow.wprintc(3,15,3,"(c) Copyright 1992-1994 - David S. Reinhart Asociates");
	creditwindow.wprintc(5,14,3,"Press <ENTER> to continue...");

	while(!done) {
		smover(16,25,53,11,1,"***");
		if(kbhit()) {
			ch=getch();
			if(ch==13) {
				ungetch(ch);
				done=1;
				continue;
				}
			}
		smoveu(53,16,5,11,1,"***");
		if(kbhit()) {
			ch=getch();
			if(ch==13) {
				ungetch(ch);
				done=1;
				continue;
				}
			}
		smovel(5,53,25,11,1,"***");
		if(kbhit()) {
			ch=getch();
			if(ch==13) {
				ungetch(ch);
				done=1;
				continue;
				}
			}
		smoved(25,5,16,11,1,"***");
		if(kbhit()) {
			ch=getch();
			if(ch==13) {
				ungetch(ch);
				done=1;
				continue;
				}
			if(ch==27) {
				clrscr();
				exit(0);
				}
			}
		}
	clear(32,1,1);
}

//*************************************************************************
//              EXPLAINSCREEN
//*************************************************************************

void explainscreen()
{
	char ch;

	Twindow mainwindow;
	mainwindow.init(1,1,80,25,15,1,0,0);
	mainwindow.title(" ObjectEase ");
	mainwindow.show();
	mainwindow.divider(HOR,DOUBLE,2);
	printc(2,14,1,"Text Mode Features");

	dlay(18);
//WINDOW
	Twindow demowindow;
	demowindow.init(10,5,20,10,0,3,1,9);
	demowindow.zoom();
	printat(11,12,14,1,"Windows");
	dlay(18*2);
//MENU
	Tmenu demomenu;
	itemarray items;

	_fstrcpy(items[1],"Item 1");
	_fstrcpy(items[2],"Item 2");
	_fstrcpy(items[3],"Item 3");

	demomenu.init(3,items,35,5,15,15,4,14,0,1,9);
	demomenu.setborder(DOUBLE);
	demomenu.show();
	printat(39,12,14,1,"Menus");
	dlay(18*2);
//BUTTON
	Tbutton button1;
	button1.init(64,6," Start ",2);
	Tbutton button2;
	button2.init(64,8," Stop  ",3);

	button1.show(1);
	button2.show(1);
	printat(65,12,14,1,"Buttons");
	dlay(18*2);
//STRING
	Tstring the_string;
	Tdate the_date;

	the_string.init(20,18,15,0);
	the_string.setincolors(14,0);
	the_string.show();

	the_date.init(20,20);
	the_date.setincolors(14,0);
	the_date.show();

	printat(10,18,11,1,"Name: ");
	printat(10,20,11,1,"Date: ");
	printat(10,22,14,1,"String Input");
	dlay(18*2);
//CHECKBOX
	Tcheckbox yesbox;
	yesbox.init(60,18,15,1);
	Tcheckbox nobox;
	nobox.init(60,20,15,1);

	yesbox.show();
	yesbox.check();

	nobox.show();

	printat(55,18,15,1,"Yes");
	printat(55,20,15,1,"No ");
	printat(55,22,14,1,"Check Boxes");
	dlay(18*2);

	printc(24,15+128,1,"Press <ENTER> to continue");
	flushkeys();
getkey:
	while(!kbhit());
	ch=getch();
	if(ch==27) {
		clrscr();
		exit(0);
		}
	if(ch!=13) {
		flushkeys();
		goto getkey;
		}
}

//*************************************************************************
//              WINDOWDEMO
//*************************************************************************

void windowdemo()
{
	char ch;

	clear(32,1,1);
	dlay(12);
	smover(12,1,37,14,1,"Windows");
	dlay(18*2);
	smover(12,37,74,14,1,"Windows");
	clear(176,15,1);
	dlay(18);

	printat(20,10,15,1,"With this simple piece of code...");
	printat(25,12,15,1,"Twindow the_window;");
	printat(25,13,15,1,"the_window.init(10,5,71,20,14,4,1,7);");
	dlay(18*3);
	printat(20,15,15,1,"You have created this window...");
	dlay(18*3);

	Twindow demowindow;
	demowindow.init(10,5,71,20,14,4,1,7);
	demowindow.show();
	dlay(18*3);

	printat(20,8,15,4,"Want to change the border?  Try this...");
	printat(25,10,15,4,"the_window.setborder(DOUBLE);");
	printat(25,11,15,4,"the_window.border();");
	dlay(18*3);

	demowindow.setborder(DOUBLE);
	demowindow.border();
	dlay(18*3);

	printat(20,14,15,4,"Now to clear the window...");
	printat(25,16,15,4,"the_window.fill();");
	dlay(18*3);

	demowindow.fill();
	dlay(18*3);

	printat(20,10,15,4,"Let's add a title. We'll call it Window 1.");
	printat(25,12,15,4,"the_window.title(\"Window 1\");");
	printat(25,13,15,4,"the_window.border();");
	dlay(18*3);

	demowindow.title("Window 1");
	demowindow.border();
	dlay(18*3);
	demowindow.fill();

	printat(20,10,15,4,"No, how about a heading instead of a title.");
	printat(25,12,15,4,"the_window.divider(HOR,DOUBLE,2);");
	printat(25,13,15,4,"the_window.wprintc(1,15,4,\"Window 1\");");
	dlay(18*3);

	demowindow.title("");
	demowindow.border();
	demowindow.divider(HOR,DOUBLE,2);
	demowindow.wprintc(1,15,4,"Window 1");
	dlay(18*3);

	demowindow.hide();
	clear(176,15,1);
	dlay(18);

	printc(10,15,1,"You can display a window like this...");
	printc(12,15,1,"the_window.show();");
	dlay(18*3);

	demowindow.show();
	dlay(18*2);
	demowindow.hide();
	clear(176,15,1);
	dlay(18);

	printc(10,15,1,"Or ZOOM it like this...");
	printc(12,15,1,"the_window.zoom();");
	dlay(18*3);

	demowindow.zoom();
	dlay(18*2);
	printc(10,15,4,"Hide a window with this call...");
	printc(12,15,4,"the_window.hide();");
	dlay(18*3);

	demowindow.hide();
	clear(176,15,1);
	dlay(18*3);

	/*Twindow warray[8];
	for(int i=0;i<8;i++) {
		warray[i].init(18+(i*3),4+(i*2),20+(18+(i*3)),4+(4+(i*2)),i+1,i,1,7);
		warray[i].setborder(DOUBLE);
		warray[i].show();
		}
	Twindow newwindow;
	newwindow.init(5,8,76,12,15,1,1,7);
	newwindow.setborder(DOUBLE);
	newwindow.zoom();
	newwindow.wprintc(2,15,1,"Windows can overlap, and any underlying image is saved.");
	dlay(18*4);

	newwindow.hide();
	dlay(18);

	for(i=7;i>-1;i--) {
		warray[i].hide();
		dlay(18);
		}
	*/
	Twindow newerwindow;
	newerwindow.init(4,3,77,18,0,3,1,7);
	newerwindow.setborder(DOUBLE);
	newerwindow.zoom();
	newerwindow.divider(HOR,DOUBLE,2);
	newerwindow.wprintc(1,14,3,"***  Features  ***");

	printc(7,0,3,"What you have just seen is just a small sampling of the power");
	printc(8,0,3,"that you control using the Twindow class of the ObjectEase");
	printc(9,0,3,"library. Here is a listing of some additional features:");
	printc(11,15,3,"Change foreground and background colors");
	printc(12,15,3,"Print to a specific window");
	printc(13,15,3,"Specify shadow or no shadow");
	printc(14,15,3,"Have the window tell you all of it's details");
	printc(15,15,3,"Never fear corrupted or lost memory, as a Twindow");
	printc(16,15,3,"frees all of its accociated memory when it leaves scope");
	dlay(18*4);

	printc(25,15+128,1,"Press <ENTER> to continue...");
getkey:
	while(!kbhit());
	ch=getch();
	if(ch==27) {
		clrscr();
		exit(0);
		}
	if(ch!=13) {
		flushkeys();
		goto getkey;
		}
}

//**************************************************************************
//              MENUDEMO
//**************************************************************************

void menudemo()
{
	char ch;

	clear(32,1,1);
	dlay(12);
	smover(12,1,38,14,1,"Menus");
	dlay(18*2);
	smover(12,38,76,14,1,"Menus");
	clear(176,15,1);
	dlay(18);
	clear(176,15,1);

	Twindow textwindow;
	textwindow.init(5,3,76,15,15,3,1,7);
	textwindow.setborder(DOUBLE);
	textwindow.zoom();
	textwindow.divider(HOR,DOUBLE,2);
	textwindow.wprintc(1,14,3,"Menus");

	printc(7,15,3,"The Tmenu class is descended from the Twindow class,");
	printc(8,15,3,"therefore inheriting all of the member functions of the");
	printc(9,15,3,"Twindow class. To use a Tmenu instance in its simplest form");
	printc(10,15,3,"simply pass it the structure containing your menu selections");
	printc(11,15,3,"and capture the returned value. We won't go into details");
	printc(12,15,3,"as with the Twindow class, but rest assured the Tmenu class");
	printc(13,15,3,"is just as powerful and as easy to implement!");
	dlay(18*5);
	printc(25,15+128,1,"Press <ENTER> to continue...");

getkey:
	while(!kbhit());
	ch=getch();
	if(ch==27) {
		clrscr();
		exit(0);
		}
	if(ch!=13) {
		flushkeys();
		goto getkey;
		}

	clear(176,15,1);
	Tmenu demomenu;
	itemarray items;

	_fstrcpy(items[1],"Item number 1");
	_fstrcpy(items[2],"Item number 2");
	_fstrcpy(items[3],"Item number 3");
	_fstrcpy(items[4],"Continue");

	demomenu.init(4,items,10,13,20,15,1,14,5,1,8);
	demomenu.title("Sample");
	Twindow the_window;
	the_window.init(15,4,66,8,15,1,1,7);
	the_window.zoom();
	printc(6,14,1,"Go ahead, experiment with this sample menu.");

	int done=0;
	while(!done) {
	int choice=demomenu.show();
		switch(choice) {
			case 1: demomenu.cfgd(7);
					printat(50,13,15,1,"You chose 1");
					printf("\a");
					dlay(18);
					demomenu.cfgd(15);
					continue;
			case 2: demomenu.cfgd(7);
					printat(50,13,15,1,"You chose 2");
					printf("\a");
					dlay(18);
					demomenu.cfgd(15);
					continue;
			case 3: demomenu.cfgd(7);
					printat(50,13,15,1,"You chose 3");
					printf("\a");
					dlay(18);
					demomenu.cfgd(15);
					continue;
			case 4: demomenu.cfgd(7);
					done=1;
					dlay(9);
					continue;
			}//switch
		}//done
	demomenu.hide();
	clear(176,15,1);
}

//**************************************************************************
//              MENUDEMO
//**************************************************************************

void pulldowndemo()
{
	char ch;

	clear(32,1,1);
	dlay(12);
	smover(12,1,33,14,1,"Pulldown Menus");
	dlay(18*2);
	smover(12,33,67,14,1,"Pulldown Menus");
	clear(176,15,1);
	dlay(18);
	clear(176,15,1);

	Twindow textwindow;
	textwindow.init(5,3,76,15,15,3,1,7);
	textwindow.setborder(DOUBLE);
	textwindow.zoom();
	textwindow.divider(HOR,DOUBLE,2);
	textwindow.wprintc(1,14,3,"Pulldown Menus");

	printc(7,15,3,"Pulldown Menus are now a BREEZE to add to your programs!");
	printc(8,15,3,"Just tell the menu object what you want it to display, and");
	printc(9,15,3,"hook it up to a menubar object. Menubars can be activated");
	printc(10,15,3,"from the keyboard or by a mouse action, and can also be");
	printc(11,15,3,"navigated by either, or both methods. You have complete");
	printc(12,15,3,"control over the values returned for the various menu");
	printc(13,15,3,"options. This is even easier than in version 2.0!!!");
	dlay(18*5);
	printc(25,15+128,1,"Press <ENTER> to continue...");

getkey:
	while(!kbhit());
	ch=getch();
	if(ch==27) {
		clrscr();
		exit(0);
		}
	if(ch!=13) {
		flushkeys();
		goto getkey;
		}

	clear(176,15,1);

	menubar mb;
	pulldown pd1,pd2,pd3;

	pd1.init(0,7,0,2,5,5);
	pd1.set_option(0,"&Open",1);
	pd1.set_option(1,"&Save",2);
	pd1.set_option(2,"Save &As",3);
	pd1.set_option(3,"-",0);
	pd1.set_option(4,"&Continue",4);

	pd2.init(0,7,0,2,5,5);
	pd2.set_option(0,"Cu&t",11);
	pd2.set_option(1,"&Copy",12);
	pd2.set_option(2,"-",0);
	pd2.set_option(3,"&Paste",13);

	pd3.init(0,7,0,2,5,5);
	pd3.set_option(0,"&Index",21);
	pd3.set_option(1,"-",0);
	pd3.set_option(2,"&About",22);

	mb.init(0,7,0,2);
	mb.set_title(0,"&File",&pd1);
	mb.set_title(1,"&Edit",&pd2);
	mb.set_title(2,"&Help",&pd3);

	int done=0;
	mb.display();
	the_mouse.arm();
	while(!done) {
		if(mb.triggered()) {
			if(mb.trackbar()==4) {
				done=1;
				continue;
				}
			}
		}
	the_mouse.unarm();
}

//**************************************************************************
//              STRINGDEMO
//**************************************************************************

void stringdemo()
{
	char ch;

	clear(32,1,1);
	dlay(12);
	smover(12,1,37,14,1,"Strings");
	dlay(18*2);
	smover(12,37,74,14,1,"Strings");
	clear(176,15,1);

	Twindow the_window;
	the_window.init(5,3,76,16,0,3,1,7);
	the_window.setborder(DOUBLE);
	the_window.zoom();
	the_window.divider(HOR,DOUBLE,2);
	printc(4,14,3,"String Input");

	printc(7,15,3,"The Tstring class is going to be your best friend. There is");
	printc(8,15,3,"NO easier way to get user input in such a variety of formats.");
	printc(9,15,3,"The Tstring class has two descendants, Tnumeral and Tdate");
	printc(10,15,3,"which allow you to capture and convert any data type.");
	printc(11,15,3,"Have you ever tried to design a form that would let the user");
	printc(12,15,3,"move to any desired input field, up or down, back and forth?");
	printc(13,15,3,"If you have, I'm sure you've met with the same frustration as");
	printc(14,15,3,"most other programmers. Your headaches are now over...");
	dlay(18*5);

	printc(25,15+128,1,"Press <ENTER> to continue");
getkey:
	while(!kbhit());
	ch=getch();
	if(ch==27) {
		clrscr();
		exit(0);
		}
	if(ch!=13) {
		flushkeys();
		goto getkey;
		}
	the_window.hide();
	clear(176,15,1);

	Twindow formwindow;
	formwindow.init(10,5,71,17,14,2,1,7);
	formwindow.title("Input");
	formwindow.show();

	Tstring lname;
	Tstring fname;
	Tstring address;
	Tstring csz;
	Tnumeral age;

	lname.init(40,7,15,0);
	lname.setincolors(15,0);
	fname.init(40,9,10,0);
	fname.setincolors(15,0);
	address.init(40,11,20,0);
	address.setincolors(15,0);
	csz.init(40,13,25,0);
	csz.setincolors(15,0);
	age.init(40,15,2,0);
	age.setincolors(15,0);

	printc(2,14,1,"Try this one on for size...");
	printc(3,14,1,"Notice that all of the standard editing keys are available.");

	printat(15,7,14,2,"Last name: ");
	lname.show();
	printat(15,9,14,2,"First name: ");
	fname.show();
	printat(15,11,14,2,"Address: ");
	address.show();
	printat(15,13,14,2,"City, State, Zip: ");
	csz.show();
	printat(15,15,14,2,"Age: ");
	age.show();

	cursoron();
getlname:
	lname.get_form_input();
	if(lname.uparrowhit())
		goto getage;
	if(lname.dnarrowhit())
		goto getfname;
getfname:
	fname.get_form_input();
	if(fname.dnarrowhit())
		goto getaddress;
	if(fname.uparrowhit())
		goto getlname;
getaddress:
	address.get_form_input();
	if(address.uparrowhit())
		goto getfname;
	if(address.dnarrowhit())
		goto getcsz;
getcsz:
	csz.get_form_input();
	if(csz.uparrowhit())
		goto getaddress;
	if(csz.dnarrowhit())
		goto getage;
getage:
	age.get_form_input();
	if(age.uparrowhit())
		goto getcsz;
	if(age.dnarrowhit())
		goto getlname;

	cursoroff();
	vprintat(35,20,15,1,"%s %s",fname.getstring(),lname.getstring());
	vprintat(35,21,15,1,"%s",address.getstring());
	vprintat(35,22,15,1,"%s",csz.getstring());
	vprintat(35,23,15,1,"%d",age.getint());
	dlay(18*2);

	formwindow.hide();
	clear(176,15,1);

	the_window.zoom();
	printc(5,14,3,"Additional features");
	printc(7,15,3,"Force strings to all capitals");
	printc(8,15,3,"Detect <ENTER>, <ESC>, <TAB>, <UP ARROW>, <DN ARROW>");
	printc(9,15,3,"<HOME>, <END>, <BACKSPACE>, <DEL>, as well as mouse keypresses");
	printc(10,15,3,"Return numerals as ints, floats, or longs");
	printc(11,15,3,"Change the colors of the input fields");
	printc(12,15,3,"Format and verify date fields");
	dlay(18*5);

	flushkeys();
	printc(25,15+128,1,"Press <ENTER> to continue...");
	getch();
}

//**************************************************************************
//              BUTTONDEMO
//**************************************************************************

void buttondemo()
{
	int done=0;
	char ch;

	clear(32,1,1);
	dlay(12);
	smover(12,1,37,14,1,"Buttons");
	dlay(18*2);
	smover(12,37,74,14,1,"Buttons");
	clear(176,15,1);
	dlay(9);

	Twindow demowindow;
	demowindow.init(5,3,76,18,15,3,1,7);
	demowindow.setborder(DOUBLE);
	demowindow.zoom();
	demowindow.divider(HOR,DOUBLE,2);

	printc(4,14,3,"Buttons");

	printc(7,15,3,"Pushbuttons provide yet another easy way to get input from");
	printc(8,15,3,"the users of your applications. There are times when a menu");
	printc(9,15,3,"is just too much, and that's when a pushbutton can serve the");
	printc(10,15,3,"purpose perfectly. Pushbuttons can be activated by any trigger");
	printc(11,15,3,"you choose, but the most common trigger is the ALT key combined");
	printc(12,15,3,"with the highlighted letter, or of course the mouse.");
	printc(13,15,3,"Give these buttons a try to get a feel for their use...");

	Tbutton button1;
	button1.init(20,15,"Button 1",1);
	Tbutton button2;
	button2.init(35,15,"Button 2",2);
	Tbutton button3;
	button3.init(50,15,"Continue",1);

	button1.show(3);
	button2.show(3);
	button3.show(3);

	while(!done) {
		if(kbhit()) {
			ch=getch();
			if(altkey()) {
				ch=getch();
				switch(ch) {
					case ALTB:      button1.press(3);
								while(altkey());
								button1.show(3);
								continue;
					case ALTU:      button2.press(3);
								while(altkey());
								button2.show(3);
								continue;
					case ALTC:      button3.press(3);
								while(altkey());
								button3.show(3);
								done=1;
								continue;
					}
				}//if altkey
			else
				flushkeys();
			}//if kbhit
		}//while
	clear(176,15,1);
}

//*************************************************************************
//              CHECKBOXDEMO
//*************************************************************************

void checkboxdemo()
{
	char ch;
	int done=0;

	clear(32,1,1);
	dlay(12);
	smover(12,1,35,14,1,"Checkboxes");
	dlay(18*2);
	smover(12,35,71,14,1,"Checkboxes");
	clear(176,15,1);
	dlay(9);

	Twindow the_window;
	the_window.init(5,3,76,19,15,3,1,7);
	the_window.setborder(DOUBLE);
	the_window.zoom();
	the_window.divider(HOR,DOUBLE,2);
	printc(4,14,3,"Checkboxes");


	printc(7,15,3,"One final way to capture user input is through the use of");
	printc(8,15,3,"checkboxes. Checkboxes can provide the user with a means of");
	printc(9,15,3,"making multiple selections. All your program needs to do");
	printc(10,15,3,"\"ask\" the checkbox if it has been checked or not. The");
	printc(11,15,3,"POWER of the object! The spacebar or the mouse is generally");
	printc(12,15,3,"the trigger to toggle a checkbox's state, however, you may");
	printc(13,15,3,"employ any trigger you choose. Try these samples using the");
	printc(14,15,3,"<TAB> key to move among the checkboxes. Check the CONTINUE");
	printc(15,15,3,"box and press <ENTER> when done.");

	Tcheckbox check1;
	check1.init(25,17,14,3);
	Tcheckbox check2;
	check2.init(40,17,14,3);
	Tcheckbox check3;
	check3.init(55,17,14,3);

	printat(15,17,15,3,"Check #1:");
	check1.show();
	printat(30,17,15,3,"Check #2:");
	check2.show();
	printat(45,17,15,3,"Continue:");
	check3.show();

	cursoron();
	check1.grabcursor();

	int active1=1,active2=0,active3=0;
	while(!done) {
		if(kbhit()) {
			ch=getch();
			if(ch!=32 && ch!=9 && ch!=13) {
				flushkeys();
				continue;
				}
			if(ch==32) {
				if(active1) {
					if(check1.ischecked())
						check1.uncheck();
					else
						check1.check();
					}
				if(active2) {
					if(check2.ischecked())
						check2.uncheck();
					else
						check2.check();
					}
				if(active3) {
					if(check3.ischecked())
						check3.uncheck();
					else
						check3.check();
					}
				}//ch==32
			if(ch==9) {
				if(active1) {
					check2.grabcursor();
					active1=0;
					active2=1;
					continue;
					}
				if(active2) {
					check3.grabcursor();
					active2=0;
					active3=1;
					continue;
					}
				if(active3) {
					check1.grabcursor();
					active3=0;
					active1=1;
					continue;
					}
				}//ch==9;
			if(ch==13) {
				if(check3.ischecked()) {
					done=1;
					continue;
					}
				}
			}//kbhit
		}//!done
	cursoroff();
	clear(176,15,1);
	dlay(18*1);
}

//*************************************************************************
//              LISTBOXDEMO
//*************************************************************************

void listboxdemo()
{
	clear(32,1,1);
	dlay(12);
	smover(12,1,35,14,1,"List Boxes");
	dlay(18*2);
	smover(12,35,71,14,1,"List Boxes");
	clear(176,15,1);
	dlay(9);

	Twindow far *the_window=new Twindow;
	the_window->init(5,3,76,15,15,3,1,7);
	the_window->setborder(DOUBLE);
	the_window->zoom();
	the_window->divider(HOR,DOUBLE,2);
	printc(4,14,3,"List Boxes");


	printc(7,15,3,"List Boxes are an excellent way to get user input when the");
	printc(8,15,3,"list of choices is longer than a menu can easily accomodate,");
	printc(9,15,3,"or when you need the options to stay visible on the screen");
	printc(10,15,3,"even after the user has made a selection. These list boxes");
	printc(11,15,3,"are limited to 64K of data, but that's probably a lot more");
	printc(12,15,3,"than you'll ever find yourself needing. They can be navigated");
	printc(13,15,3,"using either the keyboard or the mouse.");

	listbox mylist;
	mylist.init(35,18,5,15,1,0,3);
	mylist.append_item("1      ");
	mylist.append_item("2");
	mylist.append_item("3");
	mylist.append_item("4");
	mylist.append_item("5");
	mylist.append_item("6");
	mylist.append_item("7");
	mylist.append_item("8");
	mylist.append_item("9");
	mylist.append_item("10");
	mylist.append_item("11");
	mylist.append_item("12");
	mylist.append_item("13");
	mylist.append_item("14");
	mylist.append_item("15");
	mylist.append_item("16");
	mylist.append_item("17");
	mylist.append_item("18");
	mylist.append_item("19");
	mylist.append_item("Continue");

	mylist.reactivate();
	int done=0;
	flushkeys();
	the_mouse.arm();
	while(!done) {
		mylist.tracklist();
		if((_fstricmp(mylist.is_selected_string(),"Continue"))==0)
			done=1;
		}
	the_mouse.unarm();
	the_window->hide();
	delete the_window;
	clear(176,15,1);
}

//*************************************************************************
//              DIRBOXDEMO
//*************************************************************************

void dirboxdemo()
{
	clear(32,1,1);
	dlay(12);
	smover(12,1,32,14,1,"Directory Boxes");
	dlay(18*2);
	smover(12,32,68,14,1,"Directory Boxes");
	clear(176,15,1);
	dlay(9);

	Twindow far *the_window=new Twindow;
	the_window->init(5,3,76,17,15,3,1,7);
	the_window->setborder(DOUBLE);
	the_window->zoom();
	the_window->divider(HOR,DOUBLE,2);
	printc(4,14,3,"Directory Boxes");


	printc(7,15,3,"Directory boxes make it very easy for you, the programmer,");
	printc(8,15,3,"as well as the user of your programs, to select files and");
	printc(9,15,3,"file names for disk I/O. Directory boxes can be navigated");
	printc(10,15,3,"with either the keyboard or the mouse. To move between");
	printc(11,15,3,"the various components of a directory box via the keyboard,");
	printc(12,15,3,"use the TAB key. Press the OK button with the mouse, or");
	printc(13,15,3,"choose CTRL-ENTER from the keyboard to return the file name.");
	printc(14,15,3,"WARNING: THERE IS NO ERROR HANDLING IN THIS DEMO FOR DRIVES");
	printc(15,15,3,"THAT CONTAIN NO DISK. DO NOT SELECT A DRIVE THAT IS NOT READY!");

	dlay(18*5);
	printc(25,15+128,1,"Press <ENTER> to continue");
	flushkeys();

getkey:
	while(!kbhit());
	char ch=getch();
	if(ch==27) {
		clrscr();
		exit(0);
		}
	if(ch!=13) {
		flushkeys();
		goto getkey;
		}

	the_window->hide();
	delete the_window;
	clear(32,1,1);
	dirbox far *db=new dirbox;
	cursoron();
	the_mouse.arm();
	db->trackdir();
	delete db;
	the_mouse.unarm();
	cursoroff();
}


//**************************************************************************
//              TEXTMOUSEDEMO
//**************************************************************************

void textmousedemo()
{
	int done=0;
	char ch;

	Twindow top;
	top.init(1,1,80,4,15,1,0,0);
	top.zoom();
	printc(2,14,1,"OK, now let's put it all to use. If you have a mouse,");
	printc(3,14,1,"use it also to select any field or option you choose.");

	Twindow form;
	form.init(5,6,76,15,15,3,1,7);
	form.setborder(DOUBLE);
	form.show();

	Tstring lname;
	Tstring fname;

	Tbutton donebutton;
	donebutton.init(55,11," Complete ",2);
	Tcheckbox yesbox;
	yesbox.init(45,11,15,3);
	Tcheckbox nobox;
	nobox.init(45,13,15,3);

	printat(10,7,14,3,"First name: ");
	printat(10,9,14,3,"Last name:  ");
	fname.init(25,7,10,0);
	fname.setincolors(14,0);
	fname.show();
	lname.init(25,9,15,0);
	lname.setincolors(14,0);
	lname.show();

	printat(10,12,14,3,"Enjoying demo thus far?");
	printat(40,11,14,3,"Yes");
	printat(40,13,14,3,"No ");
	yesbox.show();
	nobox.show();
	yesbox.check();

	donebutton.show(3);
	the_mouse.arm();
	cursoron();

	while(!done) {
getfname:
		fname.get_form_mouse_input();
		if(the_mouse.LBP())
			goto checkmouse;
		if(fname.dnarrowhit() || fname.tabhit())
			goto getlname;
		if(fname.uparrowhit())
			goto getdone;
getlname:
		lname.get_form_mouse_input();
		if(the_mouse.LBP())
			goto checkmouse;
		if(lname.uparrowhit())
			goto getfname;
		if(lname.dnarrowhit() || lname.tabhit())
			goto getyes;
getyes:
		yesbox.grabcursor();
		while(!kbhit() && !the_mouse.LBP());
		if(the_mouse.LBP())
			goto checkmouse;
		ch=getch();
		if(ch==32) {
			if(yesbox.ischecked()) {
				yesbox.uncheck();
				nobox.check();
				}
			else {
				yesbox.check();
				nobox.uncheck();
				}
			}
		if(ch==9) {
			flushkeys();
			goto getno;
			}
		if(ch==0) {
			ch=getch();
			if(ch==80)
				goto getno;
			if(ch==72)
				goto getlname;
			flushkeys();
			}
		else {
			flushkeys();
			goto getyes;
			}
getno:
		nobox.grabcursor();
		while(!kbhit() && !the_mouse.LBP());
		if(the_mouse.LBP())
			goto checkmouse;
		ch=getch();
		if(ch==32) {
			if(nobox.ischecked()) {
				nobox.uncheck();
				yesbox.check();
				}
			else {
				nobox.check();
				yesbox.uncheck();
				}
			}
		if(ch==9) {
			flushkeys();
			goto getdone;
			}
		if(ch==0) {
			ch=getch();
			if(ch==80)
				goto getdone;
			if(ch==72)
				goto getyes;
			flushkeys();
			}
		else {
			flushkeys();
			goto getno;
			}

getdone:
		gotoxy(57,11);
		while(!kbhit() && ! the_mouse.LBP());
		if(the_mouse.LBP())
			goto checkmouse;

		ch=getch();
		if(altkey()) {
			ch=getch();
			if(ch==ALTC) {
				donebutton.press(3);
				while(altkey());
				donebutton.show(3);
				done=1;
				continue;
				}
			}
		if(ch==13) {
			donebutton.press(3);
			dlay(3);
			donebutton.show(3);
			done=1;
			continue;
			}
		if(ch==9)
			goto getfname;
		if(ch==0) {
			ch=getch();
			if(ch==72)
				goto getno;
			if(ch==80)
				goto getfname;
			flushkeys();
			}

checkmouse:
		if(the_mouse.LBP()) {
			if(fname.hit()) {
				while(the_mouse.LBP());
				goto getfname;
				}
			if(lname.hit()) {
				while(the_mouse.LBP());
				goto getlname;
				}
			if(yesbox.hit()) {
				if(yesbox.ischecked()) {
					yesbox.uncheck();
					nobox.check();
					while(the_mouse.LBP());
					}
				else {
					yesbox.check();
					nobox.uncheck();
					while(the_mouse.LBP());
					}
				goto getyes;
				}
			if(nobox.hit()) {
				if(nobox.ischecked()) {
					nobox.uncheck();
					yesbox.check();
					while(the_mouse.LBP());
					}
				else {
					nobox.check();
					yesbox.uncheck();
					while(the_mouse.LBP());
					}
				goto getno;
				}
			if(donebutton.buttonpressed()) {
				donebutton.press(3);
				while(the_mouse.LBP());
				donebutton.show(3);
				done=1;
				continue;
				}
			}
		}//while !done
	cursoroff();
	the_mouse.unarm();
}

//**************************************************************************
//              WRAPUP
//**************************************************************************

void wrapup()
{
	clear(32,1,1);
	dlay(12);
	smoved(36,1,12,14,1,"Summary");
	dlay(18*2);
	smoveu(36,12,1,14,1,"Summary");
	clear(176,15,1);
	dlay(9);

	Twindow summwindow;
	summwindow.init(4,3,77,19,14,2,1,7);
	summwindow.show();
	summwindow.divider(HOR,DOUBLE,2);
	summwindow.wprintc(1,15,2,"Text Mode Features");

	printc(7,14,2,"You have now seen the richness of the features available");
	printc(8,14,2,"in the text mode objects of the ObjectEase class library.");
	printc(9,14,2,"Understand that this demo does not allow for all of the member");
	printc(10,14,2,"functions to be demonstrated. You, the programmer, have total");
	printc(11,14,2,"control over every aspect of these objects. End the cycle of");
	printc(12,14,2,"re-inventing the wheel... use these objects to piece together");
	printc(13,14,2,"application after application maintaining consistency and ease");
	printc(14,14,2,"of use. Object oriented technology makes application development");
	printc(15,14,2,"so much easier for the programmer. You need to take advantage");
	printc(16,14,2,"of this power NOW, or be left behind in the 1990's!");
	dlay(18*8);

	printc(25,15+128,1,"Press <ENTER> to continue...");
	getch();
}
