//**************************************************************************
//      This is a demo program to show how to use some of the features of
//      the GUI libraries of the ObjectEase package. To compile and run this
//      demo create a project file including the files GUI30.LIB
//      (use GUI40.LIB if you are using Borland C++ 4.0) and GUIDEMO.CPP.
//      Make sure that the files are located where the project says they are.
//      You may also need to change to path to the GUI.H file in the #includes
//      portion of this file.
//
//      Also note that the following files MUST be in the same directory as
//      The executable for this program to operate properly:
//
//              B1.BTN
//              B2.BTN
//              I1.ICN
//              I2.ICN
//              I3.ICN
//
//      BE SURE YOU ARE COMPILING FOR THE LARGE MEMORY MODEL!!!
//**************************************************************************

#include "d:\gui\gui.h"
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <graphics.h>

#define BKG     3

//*************************  FUNCTION PROTOTYPES  **************************

void initgraphicdemo();
void gbuttondemo();
void graphbuttondemo();
void paneldemo();
void icondemo();
void acticondemo();
void gmenudemo();
void inputdemo();
void mcursordemo();
void check_radio_demo();
void bitmapdemo();
void pcxdemo();
void scrollbardemo();
void windowdemo();
void dirboxdemo();

void write3d(int,char *);
void early_exit();
void norm_exit();
void do_siren();
void do_tele();

//***************************  GLOBAL VARIABLES  ***************************

extern Mcursor the_mouse;
Screen screen;
int mouse_present=0;
char ch;

//**************************************************************************
//              MAIN
 //**************************************************************************

void main()
{
	if(farcoreleft()<=350000) {
		puts("This demo requires a minimum of 350K free memory");
		exit(0);
		}
	initgraphicdemo();
	closegraph();
	puts("Thank you for previewing the ObjectEase library from");
	puts("David S. Reinhart Associates");
	puts("\n");
	puts("Be sure to check out the code for WORKSHOP.EXE for further reference!");
	exit(0);
}

//**************************************************************************
//**************************************************************************
//**************************************************************************

void initgraphicdemo()
{
	screen.VGA_480_16();
	delay(1000);

	if(!the_mouse.init()) {
		puts("Unable to detect mouse driver. Graphic portion of this demo");
		puts("requires a mouse.");
		closegraph();
		exit(1);
		}

	setfillstyle(SOLID_FILL,BKG);
	bar(0,0,getmaxx(),getmaxy());

	Bevel mainpanel;

	mainpanel.init(50,75,540,125,THICK);
	mainpanel.show();

	settextjustify(CENTER_TEXT,TOP_TEXT);
	write3d(100,"ObjectEase graphics demonstration for Borland C++ and");
	write3d(115,"Turbo C++. This demo and the included graphics library file(s)");
	write3d(130,"(c) Copyright 1992-1994, David S. Reinhart Associates");

	write3d(160,"Press the <ENTER> key or the right mouse key to progress through");
	write3d(175,"the demo.");

	Panel copyrightpanel;
	copyrightpanel.init(3,455,634,21,OUT,THIN);
	copyrightpanel.show();
	setcolor(0);
	write3d(465,"(c) Copyright 1992-1994 - David S. Reinhart Associates");

	the_mouse.arm();

	int selected=0;
	while(!selected) {
		while(!kbhit() && !the_mouse.RBP());
		if(kbhit()) {
			if((ch=getch())==27)
				early_exit();
			while(kbhit())getch();
			selected=1;
			}
		if(the_mouse.RBP())
			selected=1;
		}

	  gbuttondemo();
	  graphbuttondemo();
	  icondemo();
	  acticondemo();
	  paneldemo();
	  gmenudemo();
	  inputdemo();
	  mcursordemo();
	  check_radio_demo();
	  bitmapdemo();
	  pcxdemo();
	  scrollbardemo();
	  windowdemo();
	  dirboxdemo();
}

//**************************************************************************

void mcursordemo()
{
	int cur=1;

	the_mouse.hide();
	setfillstyle(SOLID_FILL,3);
	bar(0,0,getmaxx(),getmaxy()-30);

	write3d(20,"Press the left mouse key to cycle through cursors.");
	write3d(35,"Press right mouse key to end.");

	the_mouse.show();
	while(!the_mouse.RBP()) {
		if(the_mouse.LBP()) {
			cur++;
			if(cur>16)cur=1;
			the_mouse.changeto(cur);
			while(the_mouse.LBP());
			}
		}
}

//**************************************************************************

void gbuttondemo()
{
	setfillstyle(SOLID_FILL,BKG);
	the_mouse.hide();
	bar(0,0,getmaxx(),getmaxy()-40);

	Bevel mainpanel;
	mainpanel.init(30,70,580,230,THICK);
	mainpanel.show();

	write3d(85,"Buttons are one of the most fundamental graphic objects.");
	write3d(100,"They are very popular within graphics environments");
	write3d(115,"for getting user input. You, the programmer, have complete");
	write3d(130,"control over how these button objects function. That is");
	write3d(145,"to say, whether the resulting action takes place when the");
	write3d(160,"button is pressed or released; how long the button remains");
	write3d(175,"depressed; etc...  Experiment with the buttons below.");

	Button lowbutton;
	Button medbutton;
	Button hibutton;
	Panel buttonpanel;

	lowbutton.init(150,230,"LOW",TEXT);
	medbutton.init(300,230,"MED",TEXT);
	hibutton.init(450,230,"HI",TEXT);
	lowbutton.resize(50,30);
	medbutton.resize(50,30);
	hibutton.resize(50,30);
	buttonpanel.init(130,220,390,50,IN,THICK);
	buttonpanel.setpanelcolor(3);
	buttonpanel.show();

	lowbutton.show();
	medbutton.show();
	hibutton.show();

	the_mouse.show();
	int selected=0;

	flushkeys();
	while(!selected) {
		if(the_mouse.LBP()) {
			if(lowbutton.hit()) {
				lowbutton.press();
				while(the_mouse.LBP() && lowbutton.hit());
				lowbutton.show();
				if(lowbutton.hit()) {
					sound(220);
					delay(500);
					nosound();
					continue;
					}
				}
			if(medbutton.hit()) {
				medbutton.press();
				while(the_mouse.LBP() && medbutton.hit());
				medbutton.show();
				if(medbutton.hit()) {
					sound(440);
					delay(500);
					nosound();
					continue;
					}
				}
			if(hibutton.hit()) {
				hibutton.press();
				while(the_mouse.LBP() && hibutton.hit());
				hibutton.show();
				if(hibutton.hit()) {
					sound(880);
					delay(500);
					nosound();
					continue;
					}
				}
			}// end if the_mouse.LBP
		if(the_mouse.RBP()) {
			selected=1;
			}
		if(kbhit()) {
			if((ch=getch())==27)
				early_exit();
			while(kbhit())getch();
			selected=1;
			}
		}// end while !selected
}

//**************************************************************************

void graphbuttondemo()
{
	the_mouse.hide();
	setfillstyle(SOLID_FILL,BKG);
	bar(0,0,getmaxx(),getmaxy()-40);

	Bevel mainpanel;
	mainpanel.init(50,50,getmaxx()-100,250,THICK);
	mainpanel.show();

	write3d(75,"Buttons can have not only text labels, but graphics as well!");
	write3d(90,"Graphics not only make the interface look nicer, but can");
	write3d(105,"also make the button's function more intuitive for the end user.");
	write3d(120,"Try to guess what the outcome will be before trying out each of");
	write3d(135,"the buttons below.");
	write3d(165,"By the way, these graphic buttons are easy to create using the");
	write3d(180,"ICONEDIT program supplied in this package.");

	Panel buttonpanel;
	Button sirenbutton;
	Button telebutton;

	buttonpanel.init(270,220,100,50,IN,THICK);
	buttonpanel.setpanelcolor(3);
	buttonpanel.show();
	sirenbutton.init(285,235,"b1",1);
	telebutton.init(330,235,"b2",1);
	sirenbutton.show();
	telebutton.show();
	the_mouse.show();

	flushkeys();
	int selected=0;
	while(!selected) {
		if(the_mouse.RBP())
			selected=1;
		if(kbhit()) {
			if((ch=getch())==27)
				early_exit();
			while(kbhit())getch();
			selected=1;
			}
		if(the_mouse.LBP()) {
			if(sirenbutton.hit()) {
				sirenbutton.press();
				while(the_mouse.LBP() && sirenbutton.hit());
				sirenbutton.show();
				if(sirenbutton.hit()) {
					do_siren();
					continue;
					}
				}
			if(telebutton.hit()) {
				telebutton.press();
				while(the_mouse.LBP() && telebutton.hit());
				telebutton.show();
				if(telebutton.hit()) {
					do_tele();
					continue;
					}
				}
			}
		}
}

//**************************************************************************

void paneldemo()
{
	the_mouse.hide();
	setfillstyle(SOLID_FILL,BKG);
	bar(0,0,getmaxx(),getmaxy()-40);

	Bevel mainpanel;
	mainpanel.init(10,10,getmaxx()-20,70,THICK);
	mainpanel.show();

	write3d(25,"Panels offer an attractive way to partition the graphics screen.");
	write3d(40,"Here are some of the different types of panels that can easily");
	write3d(55,"be implemented using the ObjectEase library.");

	Panel inthick;
	Panel inthin;
	Panel outthick;
	Panel outthin;
	Bevel thin;
	Bevel thick;

	delay(2000);
	write3d(90,"THICK STYLES                               THIN STYLES");
	inthick.init(50,105,200,100,IN,THICK);
	inthick.show();
	inthin.init(390,105,200,100,IN,THIN);
	inthin.show();
	delay(1000);
	outthick.init(50,220,200,100,OUT,THICK);
	outthick.show();
	outthin.init(390,220,200,100,OUT,THIN);
	outthin.show();
	delay(1000);
	thick.init(50,335,200,100,THICK);
	thick.show();
	thin.init(390,335,200,100,THIN);
	thin.show();

	the_mouse.show();
	flushkeys();
	while(!kbhit() && !the_mouse.RBP());
	if(kbhit()) {
		if((ch=getch())==27)
			early_exit();
		while(kbhit())getch();
		}
}

//**************************************************************************

void icondemo()
{
	the_mouse.hide();
	setfillstyle(SOLID_FILL,BKG);
	bar(0,0,getmaxx(),getmaxy()-40);

	Bevel mainpanel;
	mainpanel.init(50,50,getmaxx()-100,200,THICK);
	mainpanel.show();

	write3d(75,"What paint program would be complete without icons? Icons are");
	write3d(90,"as intuitive to use as buttons, and once again, using the");
	write3d(105,"ICONEDIT program, they are easy for you, the programmer, to");
	write3d(120,"create. Check out the action of the icons below...");

	Panel iconpanel;
	Icon drawicon;
	Icon painticon;

	iconpanel.init(250,160,getmaxx()-500,50,IN,THICK);
	iconpanel.setpanelcolor(3);
	iconpanel.show();
	drawicon.init(280,170,"i1");
	painticon.init(330,170,"i2");
	drawicon.show();
	painticon.show();
	the_mouse.show();

	flushkeys();
	int selected=0;
	while(!selected) {
		if(the_mouse.RBP())
			selected=1;
		if(kbhit()) {
			if((ch=getch())==27)
				early_exit();
			while(kbhit())getch();
			selected=1;
			}
		if(the_mouse.LBP()) {
			if(painticon.hit()) {
				if(!painticon.ispressed()) {
					painticon.choose();
					drawicon.show();
					while(the_mouse.LBP());
					continue;
					}
				}
			if(drawicon.hit()) {
				if(!drawicon.ispressed()) {
					drawicon.choose();
					painticon.show();
					while(the_mouse.LBP());
					continue;
					}
				}
			}
		}
}

//**************************************************************************

void acticondemo()
{
	the_mouse.hide();
	setfillstyle(SOLID_FILL,BKG);
	bar(0,0,getmaxx(),getmaxy()-40);

	Bevel mainpanel;
	mainpanel.init(50,50,getmaxx()-100,300,THICK);
	mainpanel.show();

	write3d(75,"Here's a neat graphic feature that you don't see everyday.");
	write3d(90,"Want to really jazz up your interface? Want to make it stand");
	write3d(105,"out in a crowd?! Instead of reversing the image of your icons");
	write3d(120,"when they are selected, make them come to life! Click the icon");
	write3d(135,"below to see what I mean.");
	write3d(165,"And guess what... Right! These icons are also easy to create");
	write3d(180,"using the ICONEDIT program");

	Panel iconpanel;
	iconpanel.init(270,230,getmaxx()-(270*2),70,IN,THICK);
	iconpanel.setpanelcolor(3);
	iconpanel.show();
	Acticon aicon;
	aicon.init(305,250,"i3");
	aicon.show(1);
	the_mouse.show();

	int selected=0;
	while(!selected) {
		if(the_mouse.RBP())
			selected=1;
		if(kbhit()) {
			if((ch=getch())==27)
				early_exit();
			while(kbhit())getch();
			selected=1;
			}
		if(the_mouse.LBP()) {
			if(aicon.hit()) {
				while(!the_mouse.RBP() && !kbhit())
					aicon.backforth(2);
				if(kbhit()) {
					flushkeys();
					selected=1;
					}
				if(the_mouse.RBP())
					selected=1;
				}
			}
		}
}

//**************************************************************************

void gmenudemo()
{
	the_mouse.hide();
	setfillstyle(SOLID_FILL,BKG);
	bar(0,0,getmaxx(),getmaxy()-40);

	Bevel mainpanel;
	mainpanel.init(30,250,getmaxx()-60,130,THICK);
	mainpanel.show();

	write3d(275,"Do you need to include point and shoot type menu bars in your");
	write3d(290,"applications? No problem! Using the ObjectEase library makes it a snap");
	write3d(305,"for you to include graphic pulldown menus! See for yourself...");
	write3d(320,"Activate the menu with the mouse, or by pressing ALT along with");
	write3d(335,"the underlined letter in the menu title. Navigate the menu with");
	write3d(350,"the mouse or via the keyboard.");

	Button _3dbutton;
	_3dbutton.init(0,0,"Make Menu 3D!!!",TEXT);
	_3dbutton.move((getmaxx()/2)-(_3dbutton.Getw()/2),getmaxy()-80);
	_3dbutton.show();

	menubar mb;
	pulldown pd1,pd2,pd3,pd4;

	pd1.init(0,15,14,1,0,0);
	pd1.set_option(0,"&Open",1);
	pd1.set_option(1,"&Save",2);
	pd1.set_option(2,"Save &As",3);
	pd1.set_option(3,"-",0);
	pd1.set_option(4,"E&xit",4);
	pd1.options[4].self_color(0,15,14,4);

	pd2.init(0,15,14,1,0,0);
	pd2.set_option(0,"Cu&t",11);
	pd2.set_option(1,"&Copy",12);
	pd2.set_option(2,"&Paste",13);

	pd3.init(0,15,14,1,0,0);
	pd3.set_option(0,"&Red",31);
	pd3.set_option(1,"&Yellow",32);
	pd3.set_option(2,"&Blue",33);
	pd3.set_option(3,"&Green",34);
	pd3.set_option(4,"&Purple",35);
	pd3.options[0].self_color(12,15,12,0);
	pd3.options[1].self_color(14,15,14,0);
	pd3.options[2].self_color(9,15,9,0);
	pd3.options[3].self_color(10,15,10,0);
	pd3.options[4].self_color(13,15,13,0);


	pd4.init(0,15,14,1,0,0);
	pd4.set_option(0,"&Index",21);
	pd4.set_option(1,"-",0);
	pd4.set_option(2,"&About",22);

	mb.init(0,15,14,1);
	mb.set_title(0,"&File",&pd1);
	mb.set_title(1,"&Edit",&pd2);
	mb.set_title(2,"&Colors",&pd3);
	mb.set_title(3,"&Help",&pd4);

	mb.display();

	int selected=0;
	while(!selected) {
		if(kbhit()) {
			if((ch=getch())==27)
				early_exit();
			flushkeys();
			selected=1;
			continue;
			}
		if(the_mouse.RBP()) {
			selected=1;
			continue;
			}
		if(the_mouse.LBP()) {
			if(_3dbutton.hit()) {
				_3dbutton.press();
				while(the_mouse.LBP() && _3dbutton.hit());
				_3dbutton.show();
				mb.make_3d();
				mb.display();
				}
			}
		if(mb.triggered())
			mb.trackbar();
		}
}

//**************************************************************************

void inputdemo()
{
	the_mouse.unarm();
	setfillstyle(SOLID_FILL,BKG);
	bar(0,0,getmaxx(),getmaxy()-40);

	Bevel mainpanel;
	mainpanel.init(30,50,getmaxx()-60,150,THICK);
	mainpanel.show();

	write3d(75,"Getting text input from a graphic based application used to be");
	write3d(90,"a real hassle... NO MORE! The ObjectEase includes functions for");
	write3d(105,"laying out text input fields, simulating the text cursor, and");
	write3d(120,"handling the text strings input by the user. Now you can");
	write3d(135,"capture graphic text input as easily as in text mode.");
	write3d(150,"Try out the sample dialog below.");

	Panel dialogpanel;
	dialogpanel.init(150,250,getmaxx()-300,85,IN,THICK);
	dialogpanel.show();

	setcolor(15);
	settextjustify(LEFT_TEXT,TOP_TEXT);
	gprintxy(170,275,"First Name: ");
	gprintxy(170,305,"Last Name:  ");

	Gstring fname;
	Gstring lname;
	fname.init(270,279,20,0);
	lname.init(270,309,20,0);
	fname.show();
	lname.show();

	the_mouse.arm();
	fname.get_input();
	lname.get_input();

	write3d(400,"Press <ENTER> to continue...");

	flushkeys();
	while(!the_mouse.RBP() && !kbhit());
	if(kbhit()) {
		if((ch=getch())==27)
			early_exit();
		flushkeys();
		}
}

//**************************************************************************

void check_radio_demo()
{
	int done=0;

	the_mouse.hide();
	setfillstyle(SOLID_FILL,BKG);
	bar(0,0,getmaxx(),getmaxy()-40);
	Bevel title;
	Panel mainpanel;

	title.init(10,10,getmaxx()-20,40,THICK);
	title.show();
	write3d(27,"Try out the Gcheckboxes and Gradios in the panel below...");

	mainpanel.init(50,80,getmaxx()-100,270,IN,THIN);
	mainpanel.show();
	the_mouse.show();
	the_mouse.changeto(ARROW);

	Gcheckbox cb[5];
	Gradio    gr[5];

	for(int i=0;i<5;i++) {
		cb[i].init(150,100+(50*i),"Checkbox");
		cb[i].show();
		}

	for(i=0;i<5;i++) {
		gr[i].init(400,100+(50*i),"Radio");
		gr[i].show();
		}

	flushkeys();
	while(!the_mouse.RBP() && !done) {
		if(kbhit()) {
			char ch;
			if((ch=getch())==13) {
				done=1;
				continue;
				}
			else
				flushkeys();
			}

		if(the_mouse.LBP()) {
			for(i=0;i<5;i++) {
				if(cb[i].hit()) {
					if(cb[i].is_checked())
						cb[i].uncheck();
					else
						cb[i].check();
					while(the_mouse.LBP());
					}
				}//for
			for(i=0;i<5;i++) {
				if(gr[i].hit()) {
					if(!gr[i].is_checked()) {
						for(int j=0;j<5;j++) {
							if(gr[j].is_checked()) {
								gr[j].uncheck();
								break;
								}
							}
						gr[i].check();
						while(the_mouse.LBP());
						}
					}
				}//for
			}//if LBP
		}//WHILE
	while(the_mouse.RBP());
}

//**************************************************************************

void bitmapdemo()
{
	int lastx,lasty,x,y;
	lastx=lasty=x,y=0;
	int done=0;

	the_mouse.unarm();
	setfillstyle(SOLID_FILL,BKG);
	bar(0,0,getmaxx(),getmaxy()-40);

	Bevel title;
	title.init(10,10,getmaxx()-20,40,THICK);
	title.show();
	write3d(27,"Click the left mouse button on the ball and drag it around...");

	Panel mainpanel;
	mainpanel.init(100,80,getmaxx()-200,200,IN,THIN);
	mainpanel.show();
	setfillstyle(SOLID_FILL,0);
	bar(101,81,538,279);

	Bitmap ball;

	ball.init(200,150);
	ball.load("c2.cut");

	ball.show_COPY();
	the_mouse.arm();
	the_mouse.changeto(HAND);

	flushkeys();
	while(!the_mouse.RBP() && !done) {
		if(kbhit()) {
			char ch;
			if((ch=getch())==13) {
				done=1;
				continue;
				}
			}

		if(the_mouse.LBP()) {
			the_mouse.set_hor_bounds(121,520);
			the_mouse.set_ver_bounds(101,260);
			if(ball.hit()) {
				while(the_mouse.LBP()) {
					x=the_mouse.mx();
					y=the_mouse.my();
					if(x!=lastx || y!=lasty) {
						ball.moveto(x-20,y-20);
						lastx=x;
						lasty=y;
						}
					}
				the_mouse.set_hor_bounds(0,getmaxx());
				the_mouse.set_ver_bounds(0,getmaxy());
				}
			}
		}
	while(the_mouse.RBP());
	ball.show_XOR();
	the_mouse.changeto(ARROW);
}

//**************************************************************************

void pcxdemo()
{
	the_mouse.unarm();
	screen.fill(3);

	write3d(55,"Include .PCX files in your applications with just a few");
	write3d(70,"lines of code. It's just as easy in 256 color mode as in");
	write3d(85,"16 color mode. You have total control over screen position.");

	PCX pcx;
	pcx.init("leaves.pcx",getmaxx()/2-50,getmaxy()/2-50);
	pcx.show(getmaxx()/2-100,getmaxy()/2-100);
	the_mouse.arm();

	flushkeys();
	int done=0;
	while(!the_mouse.RBP() && !done) {
		if(kbhit()) {
			char ch;
			if((ch=getch())==13) {
				done=1;
				continue;
				}
			if(ch==27)
				early_exit();
			}
		}
	the_mouse.hide();
	Palette pal;
	pal.fadeout();
	screen.fill(0);
}

//**************************************************************************

void scrollbardemo()
{
	the_mouse.unarm();
	screen.fill(3);

	Bevel bevel;
	bevel.init(20,50,getmaxx()-40,100,THICK);
	bevel.show();

	write3d(70,"Scroll bars provide an efficient means to regulate values");
	write3d(85,"while providing clear visual feedback to the user. You have");
	write3d(100,"complete control over the length, range, and position of the");
	write3d(115,"scroll bar object. The one on this screen will change the");
	write3d(130,"color value in the square from color 0 through color 15.");

	scrollbar sb;
	sb.init(50,400,getmaxx()-100,HORIZONTAL,0,15,20);
	sb.show();

	setfillstyle(SOLID_FILL,0);
	bar((getmaxx()/2)-40,(getmaxy()/2)-40,(getmaxx()/2)+40,(getmaxy()/2)+40);
	the_mouse.arm();

	while(!kbhit() && !the_mouse.RBP()) {
		if(the_mouse.LBP()) {
			if(sb.hit()) {
				sb.track_scrollbar();
				if(sb.value_changed()) {
					setfillstyle(SOLID_FILL,sb.get_value());
					bar((getmaxx()/2)-40,(getmaxy()/2)-40,(getmaxx()/2)+40,(getmaxy()/2)+40);
					}
				}
			}
		}
}

//**************************************************************************

void windowdemo()
{
	flushkeys();
	while(the_mouse.RBP());

	the_mouse.unarm();
	screen.fill(3);

	Bevel bevel;
	bevel.init(20,10,getmaxx()-40,100,THICK);
	bevel.show();

	write3d(35,"Graphic window functionality is now provided in the Gwindow");
	write3d(50,"class. You can move this window around by dragging from the");
	write3d(65,"title bar, or resize it by dragging from the");
	write3d(80,"lower right corner of the window.");

	Gwindow gw;
	gw.init((getmaxx()/2)-55,getmaxy()/2,110,100,0,15,14,1,"ObjectEase");
	gw.show();
	the_mouse.arm();

	while(!kbhit() && !the_mouse.RBP()) {
		if(the_mouse.LBP()) {
			if(gw.sizecornerhit())
				gw.resize();
			if(gw.titlebarhit())
				gw.move();
			if(gw.closeboxhit()) {
				beep();
				Messagebox("This would normally close the window.",MB_OK);
				}
			}
		}
}

//**************************************************************************

void dirboxdemo()
{
	the_mouse.unarm();
	screen.fill(3);

	Bevel bevel;
	bevel.init(20,10,getmaxx()-40,80,THICK);
	bevel.show();

	write3d(35,"Directory box objects make it easy for the users of your");
	write3d(50,"programs to interact with disk files. And what's more,");
	write3d(65,"These objects can be added with less than 10 lines of code!");

	the_mouse.arm();
	{
		dirbox db;
		db.trackdir();
	}
}

//**************************************************************************

void write3d(int y,char *text)
{
	settextjustify(CENTER_TEXT,TOP_TEXT);
	setcolor(0);
	outtextxy(getmaxx()/2,y,text);
	setcolor(15);
	outtextxy((getmaxx()/2)-1,y-1,text);
}

//**************************************************************************

void do_siren()
{
	int i;

	for(i=500;i<1000;i+=7) {
		sound(i);
		delay(12);
		}
	for(i=1000;i>500;i-=7) {
		sound(i);
		delay(12);
		}
	nosound();
}

//**************************************************************************

void do_tele()
{
	int i;

	for(i=0;i<14;i++) {
		sound(440);
		delay(30);
		sound(880);
		delay(30);
		}
	nosound();
}

//**************************************************************************

void early_exit()
{
	closegraph();
	puts("You have not seen the entire demonstration.");
	exit(0);
}
