/****************************************************************************
 * Generated by OEGen.
 * Comments.......  This file contains the Database Mgmt. code specific to
 *                  the descendents of a persistant class.  This code is
 *                  generated automatically.
 *
 ***************************************************************************/

#include "C:\FITDEV\DATABASE\TEST.HPP"

#ifdef _Windows
ObjEng objeng("OEApp");
#else
ObjEng objeng;
#endif


//------------------------------------------------------------
// The Client Class Constructor
//------------------------------------------------------------
Client::Client(int indexID) : PersistClass("client", indexID)
{
	strcpy(localtypes, "LAASDM^L");

	if (!objeng.IsRegistered(oehandle))
	{
		char *FieldNames[] = {"ID", "FNAME", "LNAME", "WEIGHT", "BIRTHDATE", "BLOBTEST", "TESTS", "ObjectID"};
		char *FieldTypes[] = {"N", "A12", "A18", "S", "D", "M128", "N", "N"};
		if ((status = objeng.EnsureExist("client", 8, FieldNames, FieldTypes)) > PXSUCCESS) return;
		//If tables have been NEWLY CREATED then create indices also.
		if (status == PXSUCCESS)
		{
			FIELDHANDLE IdxFlds[] = { 1 };
			objeng.RegisterKey("client", 1, IdxFlds, PRIMARY);
			FIELDHANDLE SIdxFlds0[] = { 5 };
			objeng.RegisterKey("client", 1, SIdxFlds0, INCSECONDARY);
			FIELDHANDLE SIdxFlds1[] = { 3 };
			objeng.RegisterCompKey("client", 1, SIdxFlds1, "CIlname", INCSECONDARY, CASEINSENSITIVE);
			FIELDHANDLE SCIdxFlds1[] = { 2, 3 };
			objeng.RegisterCompKey("client", 2, SCIdxFlds1, "Namekey", INCSECONDARY, CASESENSITIVE);
		}
		// Now register the table with the system (open it).
		if ((status = objeng.Register(oehandle)) != PXSUCCESS) return;
	}

	// Initialize variables
  	id = 0;
  	strcpy(fname, "");
  	strcpy(lname, "");
  	weight = 0;
  	birthdate.tm_mday = 0;
	birthdate.tm_mon = 0;
	birthdate.tm_year = 0;
  	blobtest = new Blob(oehandle, 6);
  	tests = new OEList;
	// ANY ADDITIONAL CONSTRUCTOR CODE CAN BE PLACED HERE...
}



//------------------------------------------------------------
// The Client Class Constructor
//------------------------------------------------------------
Client::~Client()
{
		delete blobtest;
		if ((tests != NULL) && (tests->DeleteOK() == TRUE)) delete tests;
}


//------------------------------------------------------------
// Copy contents from one client to another - DO NOT link them.
// (objectID is not copied so the copy doesn't refer to DB record).
//------------------------------------------------------------
Client &Client::operator=(const Client &val)
{
  	id = val.id;
  	strcpy(fname, val.fname);
  	strcpy(lname, val.lname);
  	weight = val.weight;
  	birthdate.tm_mday = val.birthdate.tm_mday;
	birthdate.tm_mon = val.birthdate.tm_mon;
	birthdate.tm_year = val.birthdate.tm_year;
  	*blobtest = *val.blobtest;
  	if ((tests != NULL) && (tests->DeleteOK() == TRUE)) delete tests;
	tests = val.tests;
	if (tests != NULL)
		tests->AddReference();   //Increment refcount to avoid unwanted deletion
	strcpy(localtypes, "LAASDM^L");

	// Base class copies...
	Copy((PersistClass &)val);
	return *this;
}


//------------------------------------------------------------
// Link to the record matching on the given number of index fields.
//------------------------------------------------------------
int Client::LinkToKey(int nIdxFields, int mode)
{
	//Copy all of the Primary index fields to the recbuf 
	PXPutLong(oehandle.rHdl, 1, id);
	// Do the SrchKey on just those that are asked for (nIdxFields).
	if ((status = PXSrchKey(oehandle.tHdl, oehandle.rHdl, nIdxFields, mode)) == PXSUCCESS) 
		return Retrieve();
	else
		return status;
}


//------------------------------------------------------------
// Link to the record matching on the given number of index fields.
//------------------------------------------------------------
int Client::LinkToSKey(char *fldName, int mode)
{
	FIELDHANDLE fieldHandle;

	if ((status = PXFldHandle(oehandle.tHdl, fldName, &fieldHandle)) != PXSUCCESS) return status;

	//Copy ALL of the fields to the recbuf since we don't know 
	//which are keys (you may want to delete those you know aren't used). 
	PXPutLong(oehandle.rHdl, 1, id);
	PXPutAlpha(oehandle.rHdl, 2, fname);
	PXPutAlpha(oehandle.rHdl, 3, lname);
	PXPutShort(oehandle.rHdl, 4, weight);
	OEPutDate(5, birthdate);
	long listid0 = tests->GetListID();
	PXPutLong(oehandle.rHdl, 7, listid0);

	if ((status = PXSrchFld(oehandle.tHdl, oehandle.rHdl, fieldHandle, mode)) == PXSUCCESS) 
		return Retrieve();
	else
		return status;
}


//------------------------------------------------------------
// Store a filled/changed object - create an indexID if virgin,
// otherwise, store under the objectID.
//------------------------------------------------------------
int Client::Store()
{
	PXPutLong(oehandle.rHdl, 1, id);
	PXPutAlpha(oehandle.rHdl, 2, fname);
	PXPutAlpha(oehandle.rHdl, 3, lname);
	PXPutShort(oehandle.rHdl, 4, weight);
	OEPutDate(5, birthdate);
	long listid1 = tests->GetListID();
	PXPutLong(oehandle.rHdl, 7, listid1);
	if (objectID == 0) // Not yet added, give Index, then add
	{
		if ((status = objeng.GetIndex(objectID, 0)) != PXSUCCESS) return status;
		PXPutLong(oehandle.rHdl, 8, objectID);
		status = PXRecInsert(oehandle.tHdl, oehandle.rHdl);
	}
	else  // 'Tis an update.
	{
		PXPutLong(oehandle.rHdl, 8, objectID);
		status = PXSrchFld(oehandle.tHdl, oehandle.rHdl, 8, SEARCHFIRST);
		
		if (status == PXSUCCESS)
			status = PXRecUpdate(oehandle.tHdl, oehandle.rHdl);
		else
		{
			// If you want a missing object to be an error, then
			// uncomment THIS line....
			// status = PXERR_RECNOTFOUND;
			// and comment out THIS line....
			status = PXRecInsert(oehandle.tHdl, oehandle.rHdl);
		}
	}
	return status;
}

//------------------------------------------------------------
// An Object Retrieve Function - Private! Should only be called by 
// one of the linking functions (Link..., First, Last, ++, --)
//------------------------------------------------------------
int Client::Retrieve()
{
	// Free up memory currently allocated to OEList if OEList
	// reference count is 0.
	if ((tests != NULL) && (tests->DeleteOK() == TRUE)) delete tests;
	if ((status = PXRecGet(oehandle.tHdl, oehandle.rHdl)) == PXSUCCESS)
	{
		PXGetLong(oehandle.rHdl, 1, &id);
		PXGetAlpha(oehandle.rHdl, 2, 13, fname);
		PXGetAlpha(oehandle.rHdl, 3, 19, lname);
		PXGetShort(oehandle.rHdl, 4, &weight);
		OEGetDate(5, birthdate);
		long listid0;
		PXGetLong(oehandle.rHdl, 7, &listid0);
		tests = new OEList(listid0);
		PXGetLong(oehandle.rHdl, 8, &objectID);
	}
	return status;
}


//------------------------------------------------------------
// The Test Class Constructor
//------------------------------------------------------------
Test::Test(int indexID) : PersistClass("test", indexID)
{
	strcpy(localtypes, "LDN$AML");

	if (!objeng.IsRegistered(oehandle))
	{
		char *FieldNames[] = {"ID", "TESTDATE", "WEIGHT", "HEIGHT", "TRAINER", "BLOBTEST", "ObjectID"};
		char *FieldTypes[] = {"N", "D", "N", "$", "A24", "M128", "N"};
		if ((status = objeng.EnsureExist("test", 7, FieldNames, FieldTypes)) > PXSUCCESS) return;
		//If tables have been NEWLY CREATED then create indices also.
		if (status == PXSUCCESS)
		{
			FIELDHANDLE IdxFlds[] = { 1 };
			objeng.RegisterKey("test", 1, IdxFlds, PRIMARY);
			FIELDHANDLE SIdxFlds0[] = { 5 };
			objeng.RegisterCompKey("test", 1, SIdxFlds0, "CItrainer", INCSECONDARY, CASEINSENSITIVE);
		}
		// Now register the table with the system (open it).
		if ((status = objeng.Register(oehandle)) != PXSUCCESS) return;
	}

	// Initialize variables
  	id = 0;
  	testdate.tm_mday = 0;
	testdate.tm_mon = 0;
	testdate.tm_year = 0;
  	weight = 0.0;
  	height = 0.0;
  	strcpy(trainer, "");
  	blobtest = new Blob(oehandle, 6);
	// ANY ADDITIONAL CONSTRUCTOR CODE CAN BE PLACED HERE...
}



//------------------------------------------------------------
// The Test Class Constructor
//------------------------------------------------------------
Test::~Test()
{
		delete blobtest;
}


//------------------------------------------------------------
// Copy contents from one client to another - DO NOT link them.
// (objectID is not copied so the copy doesn't refer to DB record).
//------------------------------------------------------------
Test &Test::operator=(const Test &val)
{
  	id = val.id;
  	testdate.tm_mday = val.testdate.tm_mday;
	testdate.tm_mon = val.testdate.tm_mon;
	testdate.tm_year = val.testdate.tm_year;
  	weight = val.weight;
  	height = val.height;
  	strcpy(trainer, val.trainer);
  	*blobtest = *val.blobtest;
	strcpy(localtypes, "LDN$AML");

	// Base class copies...
	Copy((PersistClass &)val);
	return *this;
}


//------------------------------------------------------------
// Link to the record matching on the given number of index fields.
//------------------------------------------------------------
int Test::LinkToKey(int nIdxFields, int mode)
{
	//Copy all of the Primary index fields to the recbuf 
	PXPutLong(oehandle.rHdl, 1, id);
	// Do the SrchKey on just those that are asked for (nIdxFields).
	if ((status = PXSrchKey(oehandle.tHdl, oehandle.rHdl, nIdxFields, mode)) == PXSUCCESS) 
		return Retrieve();
	else
		return status;
}


//------------------------------------------------------------
// Link to the record matching on the given number of index fields.
//------------------------------------------------------------
int Test::LinkToSKey(char *fldName, int mode)
{
	FIELDHANDLE fieldHandle;

	if ((status = PXFldHandle(oehandle.tHdl, fldName, &fieldHandle)) != PXSUCCESS) return status;

	//Copy ALL of the fields to the recbuf since we don't know 
	//which are keys (you may want to delete those you know aren't used). 
	PXPutLong(oehandle.rHdl, 1, id);
	OEPutDate(2, testdate);
	PXPutDoub(oehandle.rHdl, 3, weight);
	PXPutDoub(oehandle.rHdl, 4, height);
	PXPutAlpha(oehandle.rHdl, 5, trainer);

	if ((status = PXSrchFld(oehandle.tHdl, oehandle.rHdl, fieldHandle, mode)) == PXSUCCESS) 
		return Retrieve();
	else
		return status;
}


//------------------------------------------------------------
// Store a filled/changed object - create an indexID if virgin,
// otherwise, store under the objectID.
//------------------------------------------------------------
int Test::Store()
{
	PXPutLong(oehandle.rHdl, 1, id);
	OEPutDate(2, testdate);
	PXPutDoub(oehandle.rHdl, 3, weight);
	PXPutDoub(oehandle.rHdl, 4, height);
	PXPutAlpha(oehandle.rHdl, 5, trainer);
	if (objectID == 0) // Not yet added, give Index, then add
	{
		if ((status = objeng.GetIndex(objectID, 0)) != PXSUCCESS) return status;
		PXPutLong(oehandle.rHdl, 7, objectID);
		status = PXRecInsert(oehandle.tHdl, oehandle.rHdl);
	}
	else  // 'Tis an update.
	{
		PXPutLong(oehandle.rHdl, 7, objectID);
		status = PXSrchFld(oehandle.tHdl, oehandle.rHdl, 7, SEARCHFIRST);
		
		if (status == PXSUCCESS)
			status = PXRecUpdate(oehandle.tHdl, oehandle.rHdl);
		else
		{
			// If you want a missing object to be an error, then
			// uncomment THIS line....
			// status = PXERR_RECNOTFOUND;
			// and comment out THIS line....
			status = PXRecInsert(oehandle.tHdl, oehandle.rHdl);
		}
	}
	return status;
}

//------------------------------------------------------------
// An Object Retrieve Function - Private! Should only be called by 
// one of the linking functions (Link..., First, Last, ++, --)
//------------------------------------------------------------
int Test::Retrieve()
{
	// Free up memory currently allocated to OEList if OEList
	// reference count is 0.
	if ((status = PXRecGet(oehandle.tHdl, oehandle.rHdl)) == PXSUCCESS)
	{
		PXGetLong(oehandle.rHdl, 1, &id);
		OEGetDate(2, testdate);
		PXGetDoub(oehandle.rHdl, 3, &weight);
		double temp1;
		PXGetDoub(oehandle.rHdl, 4, (double *)&temp1);
		height = temp1;
		PXGetAlpha(oehandle.rHdl, 5, 25, trainer);
		PXGetLong(oehandle.rHdl, 7, &objectID);
	}
	return status;
}


//--------------------------------------------------------------------
// This "global" function provides the mapping from table names
// to table objects for the automatic "has-a" link storage/retrieval.
// It is always generated last since it needs to summarize all of the
// classes defined above.
//--------------------------------------------------------------------
PersistClass *GetPersistClass(char *tbl, const long &inID)
{
	PersistClass* tmp;

	if (strcmp(tbl, "client") == 0)
	{
		Client *client = new Client();
		tmp = (PersistClass *)client;
	}
	else
	if (strcmp(tbl, "test") == 0)
	{
		Test *test = new Test();
		tmp = (PersistClass *)test;
	}
	else
		return NULL;

	// Common calls for all Persistant Classes.
	if ((tmp->GetStatus() != PXSUCCESS) || (tmp->LinkToID(inID) != PXSUCCESS))
	{
		delete tmp;
		return NULL;
	}
	return(tmp);
}
