// *************************************************************** //
// Filename:    MPD.h                                              //
//                                                                 //
// Date:        November 26, 1993                                  //
//                                                                 //
// Description:                                                    //
//  Implements a multi-page dialog with an owner-drawn listbox     //
// *************************************************************** //

#ifndef MPD_H
#define MPD_H

#include <owl\owlcore.h>
#include <owl\listbox.h>
#include <owl\layoutwi.h>
#include <owl\button.h>
#include <windowsx.h>
#pragma hdrstop
#include "MPD.rh"

// --------------------------------------------------------------- //
// MPDApplication                                                  //
// --------------------------------------------------------------- //
class TMPDApp : public TApplication 
{
  public:
    TMPDApp();
   ~TMPDApp();
    void InitMainWindow();
};

// --------------------------------------------------------------- //
// additional data for each item in the listbox                    //
// --------------------------------------------------------------- //
struct ItemData
{
  TResId Icon;
  TResId Dialog;
};

// --------------------------------------------------------------- //
// Owner drawn listbox to handle icons and strings                 //
// --------------------------------------------------------------- //
class TIconListBox : public TListBox
{
  public:
    TIconListBox(TWindow *parent, int resId, TModule *module = 0);
    TIconListBox(TWindow *parent, int id,
      int x, int y, int w, int h,
      TModule *module = 0);
    
    void AddItem(const char *text, TResId icon, TResId dialog);
    void CleanupWindow();
    void ODADrawEntire(DRAWITEMSTRUCT &drawInfo);
    void ODAFocus(DRAWITEMSTRUCT &drawInfo);
    void ODASelect(DRAWITEMSTRUCT &drawInfo);

    DECLARE_RESPONSE_TABLE(TIconListBox);
  protected:
    void DrawEntry(DRAWITEMSTRUCT &drawInfo);
    void EvKeyDown(UINT key, UINT repeatCount, UINT flags);
    UINT EvGetDlgCode(MSG *);
};

// --------------------------------------------------------------- //
// MPDWindow                                                       //
// --------------------------------------------------------------- //
class TMPDWindow : public TLayoutWindow
{
  public:
    TMPDWindow();
   ~TMPDWindow();
    void SetupWindow();
    void CleanupWindow();

    DECLARE_RESPONSE_TABLE(TMPDWindow);
  protected:
    TIconListBox *lb;
    TDialog *dlg;
    void EvMeasureItem(UINT ctrlId, MEASUREITEMSTRUCT &measureInfo);
    void EvSelChange();
};

// --------------------------------------------------------------- //
// helper functions to hook a control into a dialog                //
// --------------------------------------------------------------- //
void SetFocusToDlgFirstCtrl();
void SetFocusToDlgLastCtrl();
void SetAdditionalTabCtrl(HWND);
void SubclassFirstCtrl(HWND);
void SubclassLastCtrl(HWND);
BOOL IsShiftKeyDown();
void EatWaitingMessages(HWND);

#endif

