// *************************************************************** //
// Filename:    MPD.cpp                                            //
//                                                                 //
// Date:        November 26, 1993                                  //
//                                                                 //
// Description:                                                    //
// *************************************************************** //
#include "MPD.h"

// --------------------------------------------------------------- //
// MPDWindow constructor                                           //
// --------------------------------------------------------------- //
TMPDWindow::TMPDWindow() :
  TLayoutWindow(0, 0, 0), dlg(NULL)
{
  lb = new TIconListBox(this, IDC_LISTBOX, 10, 10, 80, 100);
  TLayoutMetrics layoutMetrics;

  layoutMetrics.X.SameAs(lmParent, lmLeft);
  layoutMetrics.Y.SameAs(lmParent, lmTop);
  layoutMetrics.Width.PercentOf(lmParent, 35, lmWidth);
  layoutMetrics.Height.SameAs(lmParent, lmHeight);
  SetChildLayoutMetrics(*lb, layoutMetrics);
}

// --------------------------------------------------------------- //
// MPDWindow destructor                                            //
// --------------------------------------------------------------- //
TMPDWindow::~TMPDWindow()
{
}

// --------------------------------------------------------------- //
// SetupWindow                                                     //
// --------------------------------------------------------------- //
void TMPDWindow::SetupWindow()
{
  TLayoutWindow::SetupWindow();
  // new stuff here
  lb->AddItem("Black", "BLACK_ICON", "BLACK_DIALOG");
  lb->AddItem("Red",   "Red_ICON",   "RED_DIALOG");
  lb->AddItem("Green", "Green_ICON", "GREEN_DIALOG");
  lb->AddItem("Blue",  "Blue_ICON",  "BLUE_DIALOG");
}

// --------------------------------------------------------------- //
// CleanupWindow                                                   //
// --------------------------------------------------------------- //
void TMPDWindow::CleanupWindow()
{
  if (dlg)
  {
    dlg->ShutDownWindow();
  }
  // new stuff here
  TLayoutWindow::CleanupWindow();
}

// --------------------------------------------------------------- //
// Response table for MPDWindow                                //
// --------------------------------------------------------------- //
DEFINE_RESPONSE_TABLE1(TMPDWindow, TLayoutWindow)
  EV_WM_SIZE,
  EV_WM_MEASUREITEM,
  EV_WM_GETDLGCODE,
  EV_LBN_SELCHANGE(IDC_LISTBOX, EvSelChange),
END_RESPONSE_TABLE;


// --------------------------------------------------------------- //
// WM_MEASUREITEM                                                  //
// --------------------------------------------------------------- //
void TMPDWindow::EvMeasureItem(UINT ctrlId, MEASUREITEMSTRUCT &measureInfo)
{
  if (ctrlId == IDC_LISTBOX)
  {
    measureInfo.itemHeight = GetSystemMetrics(SM_CYICON) + 2;
  }
}

// --------------------------------------------------------------- //
// SelChange                                                       //
// --------------------------------------------------------------- //
void TMPDWindow::EvSelChange()
{
  char buffer[80];

  if (dlg)        // close existing dialog
    dlg->ShutDownWindow();

  lb->GetSelString(buffer, 80);
  int index = lb->GetSelIndex();
  ItemData *data = (ItemData *)lb->GetItemData(index);

  // create dialog with layout metrics
  dlg = new TDialog(this, data->Dialog);
  TLayoutMetrics dialogLayout;
  dialogLayout.Y.SameAs(lmParent, lmTop);
  dialogLayout.X.RightOf(lb, 1);
  dialogLayout.Width.SameAs(lmParent, lmRight);
  dialogLayout.Height.SameAs(lmParent, lmBottom);
  SetChildLayoutMetrics(*dlg, dialogLayout);
  dlg->Create();

  // Add the listbox into the tabbing sequence
  SetAdditionalTabCtrl(*lb);
  SubclassFirstCtrl(*dlg);
  SubclassLastCtrl(*dlg);

  Layout();
  dlg->Show(SW_NORMAL);
  lb->SetFocus();
}

