//----------------------------------------------------------------------------
// Add-on for ObjectWindows 2 - (C) Dieter Menne, Biomed Tuebingen
//   Defines class TRadioGroupBox.
//   Group box with automatic transfer of Auto Radiobuttons
//----------------------------------------------------------------------------
#if !defined(__OWL_RADIOGROUP_H)
#define __OWL_RADIOGROUP_H

#if !defined(__OWL_GROUPBOX_H)
  #include <owl\groupbox.h>
#endif

#if !defined(__OWL_RADIOBUT_H)
  #include <owl\radiobut.h>
#endif

//
//  class TRadioGroupBox
//  ----- --------------
//
class _OWLCLASS TRadioGroupBox: public TGroupBox
{
  public:
    // If you need the long constructor, add it on your own
    TRadioGroupBox(TWindow *parent,
                   int resID,         // Groupbox ID
                   int firstRadioID,  // First ID in Group
                   int lastRadioID,   // last included(!) ID in Group
                   TModule * Module=0);
    ~TRadioGroupBox() { delete [] RadioButton;}
    UINT Transfer(void* buffer, TTransferDirection direction);
    TRadioButton *GetRadioButton(int id)
      { return (id < FromID|| id > ToID)?0:RadioButton[id];}
  private:
    //
    // hidden to prevent accidental copying or assignment
    //
    TRadioGroupBox(const TRadioGroupBox&);
    TRadioGroupBox& operator=(const TRadioGroupBox&);

    int
      FromID,  // First in a sequence of radio buttons
      ToID;    // Last in a sequence of radio buttons
      TRadioButton ** RadioButton; // List of radio buttons ptrs

  // Streaming not implemented !
  //DECLARE_STREAMABLE(_OWLCLASS, TRadioGroupBox, 1);
};

#endif  // __OWL_GROUPBOX_H

