/*
	nmakecfg.c -- 	get configuration information
						for the nmaker program
*/

/*	Last revised : Monday, July 30, 1990 at 3:59:12 pm */
/* Loran W. Richardson */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	"nmaker.h"

char defaults [LIBS + 1][SLEN] ;
char nmaker_defs [LIBS + 1][FNAMELEN] ;

int nmaker_cfg (char *pname)
{
	char line [SLEN] ;
	char temp [SLEN] ;
	char path [_MAX_PATH] ;
	char *s ;
	FILE *fp ;
	FLAGS i ;

/* set up header strings */
	strcpy (nmaker_defs [TARGET], "TARGET") ;
	strcpy (nmaker_defs [CC], "CC") ;
	strcpy (nmaker_defs [CFLAGS], "CFLAGS") ;
	strcpy (nmaker_defs [CDEFS] ,"CDEFS") ;
	strcpy (nmaker_defs [MC], "MC") ;
	strcpy (nmaker_defs [MFLAGS], "MFLAGS") ;
	strcpy (nmaker_defs [MDEFS], "MDEFS") ;
	strcpy (nmaker_defs [LINK], "LINK") ;
	strcpy (nmaker_defs [LFLAGS], "LFLAGS") ;
	strcpy (nmaker_defs [LMAP], "LMAP") ;
	strcpy (nmaker_defs [LIBS], "LIBS") ;

/* set up the defaults */

	strcpy (defaults [CC],	"cl") ;
	strcpy (defaults [CFLAGS], "/qc /W3 /Zi /Od /c") ;
	strcpy (defaults [CDEFS],	"") ;
	strcpy (defaults [MC],	"masm") ;
	strcpy (defaults [MFLAGS], "/Zi") ;
	strcpy (defaults [MDEFS],	"") ;
	strcpy (defaults [LINK], "link") ;
	strcpy (defaults [LFLAGS], "/CO") ;
	strcpy (defaults [LMAP], "NUL") ;
	strcpy (defaults [LIBS], "") ;




/* get the environment settings */
	if ((s = getenv ("CL")) != NULL)
		strcpy (defaults [CFLAGS], s) ;

	if ((s = getenv ("MASM")) != NULL)
		strcpy (defaults [MFLAGS], s) ;

	if ((s = getenv ("LINK")) != NULL)
		strcpy (defaults [LFLAGS], s) ;

/* get the configuration file values */
	_searchenv ("nmaker.cfg", "CONFIG", path) ;			/* find the configuration file */
	if (path [0] != '\0')
		if ((fp = fopen (path, "r")) != NULL)
			while ((s = fgets (line, SLEN, fp)) != NULL) /* read in a line */
				{
				strcpy (temp, strtok (line, " \t\n=")) ;	/* get the first word */
				for (i = CC; i <= LIBS; ++i)					/* loop through the options */
					if (strcmp (temp, nmaker_defs [i]) == 0) /* word matches option ? */
						{
						strcpy(defaults [i], strtok (NULL, "\n")) ; /* copy the rest of the line */
						if (defaults [i][0] == '=')					  /* into the defaults */
							strcpy (defaults [i], (defaults [i]) + 1) ;
						break;
						}
				}
	return (0) ;
}
