/*
	nmakerhp.c -- display a help page for the nmaker program
*/

/*	Last revised : Monday, July 30, 1990 at 3:59:16 pm */
/* Loran W. Richardson */

#include <stdio.h>				/* standard stuff		*/

void nmaker_help (char *pname)
{

	static char *help_string [] =
		{
		"Where [options] is one or more of the following:",
		"-d\tdepends - show dependencies in 'make' style format",
		"-h,-H\thelp - give some help on the starting flags",
		"-s\tshow times of all files checked",
		"-v\tverbose - show all includes in verbose format",
		"",
		"and fname is the name of the target file generated by make."
		} ;

	int i, n = sizeof (help_string) / sizeof (char *) ;

	fprintf (stderr, "Usage: %s [options] fname\n\n", pname) ;
	for (i = 0; i < n; ++i)
		fprintf (stderr, "%s\n", help_string [i]) ;

	return ;
}
