#
# FileName
# --------
# MKVC3210.MAK
#
# Description
# -----------
# Include makefile for VC++ v1.0, 32-bit (WinNT)
#
# The libraries are placed in the current directory.  The compiler and
#	it's configuration are chosen with the following *required* macros:
#
#	BUILDTYPE			-	S or D		(NewTrack as Stand-Alone or DLL)
#	CALLERTYPE			-	E or D		(NewTrack called from a .DLL or .EXE)
#	MODEL				-	L or F		(Memory Model)
#	SHAREWARE			-	Y or N		(Shareware or full (sold) version)
#	MULTITHREADED		-	Y or N
#	STATICRTL			-	Y or N
#	CONSOLE				-	Y or N
#	RSP_FILE			-	Name of response file to create
#	MONIKER				-	Name of library being built
#	CFXINCDIR			-	Include directory for CFX
#	RELINCDIR			-	Include directory for released include files
#	UNRELINCDIR			-	Include directory for unreleased include files
#	OUTPUTDIR			-	Output directory for library .OBJ files
#
# Generated macros
#	COMPILER			-	Compiler (BOR or MSVC)
#	COMPILERVER			-	Version (31 or 40 for Borland, 15 or 10 for MSVC)
#	PLATFORM			-	WIN16 or WIN32
#	COMPILER_OBJS		-	Compiler-specific OBJs
#	LINK_COMPILER_OBJS	-	Compiler-specific OBJS, parsed for the linker
#
# Optional macros:
#	DEBUG				-	Y or N (default)	(Debug build)
#	MAKETEST			-	Y or N (default)	(Make test program/dll)
#
#
#
# For linking, use:
#	$(LINK) $(LINKDLL_FLAGS) @&&|
#		$(LDDLL_STARTUP)
#		$(LDDLL_ALL_OBJS)
#		$(LD_SETOUT) $(DLL_NAME)
#		$(LD_SETMAP) $(DLL_MAPNAME)
#		$(LDDLL_LIB_EXTRA)
#	!
#
# For creating libraries, use:
#	$(LIBMGR) $(LIB_FLAGS) $(LIB_SETOUT)$(LIBNAME) @&&|
#		$(LIB_ALL_DLL_OBJS)
#	|
#
#
# Need LDDLL_ALL_OBJS
#


!ifndef BUILDTYPE
!error BUILDTYPE not defined
!endif
!ifndef CALLERTYPE
!error CALLERTYPE not defined
!endif
!ifndef MODEL
!error MODEL not defined
!endif
!ifndef SHAREWARE
!error SHAREWARE not defined
!endif
!ifndef MULTITHREADED
!error MULTITHREADED not defined
!endif
!ifndef STATICRTL
!error STATICRTL not defined
!endif
!ifndef CONSOLE
!error CONSOLE not defined
!endif
!ifndef RSP_FILE
!error RSP_FILE not defined
!endif
!ifndef MONIKER
!error MONIKER not defined
!endif
!ifndef DEBUG
DEBUG=N
!endif


COMPILER=MSVC
COMPILERVER=10
MODEL=F
PLATFORM=WIN32

# Tools
IMPLIB				= rem
CC					= cl
LINK				= link
LIBMGR					= link -lib
BRC					= rc
LD_LIBDIR			= g:\usr\msvcnt\lib
CC_INCDIR			= g:\usr\msvcnt\include

# Tool arguments
CCDLL_FLAGS			= /nologo @$(RSP_FILE)
CCEXE_FLAGS			= /nologo @$(RSP_FILE)
CC_SETOUT			= /Fo
CC_COMPILEONLY		= /c
CC_DEFINE			= /D
CC_INCDIR			= g:\usr\msvcnt\include

LDDLL_FLAGS_C		= /NOLOGO /VERSION:3,0 /SUBSYSTEM:console /DLL
LDDLL_STARTUP		=
LDDLL_LIB_EXTRA		= user32.lib netapi32.lib kernel32.lib advapi32.lib
LDEXE_STARTUP		=
LDEXE_FLAGS_C		= /NOLOGO /VERSION:3,0 /SUBSYSTEM:console
LDEXE_LIB_EXTRA		= user32.lib netapi32.lib kernel32.lib advapi32.lib
LD_SETOUT			= /OUT:
LD_SETMAP			= /MAP:
LD_OBJSEP			=
LD_LIBSEP			=
LD_SETBASE			= /BASE:

LIB_FLAGS_C			= /NOLOGO
LIB_SETOUT			= /OUT:
AR_OBJSEP			=
LIB_EOL				=^^^&\n


LDDLL_FLAGS_D		= /DEBUG /DEBUGTYPE:cv
LDEXE_FLAGS_D		= /DEBUG /DEBUGTYPE:cv
LIB_FLAGS_D			=



# Configure Debug/Non-Debug build
!if "$(DEBUG)"=="Y" || "$(DEBUG)"=="y"

LDDLL_FLAGS		= $(LDDLL_FLAGS_C) $(LDDLL_FLAGS_D)
LDEXE_FLAGS		= $(LDEXE_FLAGS_C) $(LDEXE_FLAGS_D)
LIB_FLAGS		= $(LIB_FLAGS_C) $(LIB_FLAGS_D)

!else

LDDLL_FLAGS		= $(LDDLL_FLAGS_C) $(LDDLL_FLAGS_R)
LDEXE_FLAGS		= $(LDEXE_FLAGS_C) $(LDEXE_FLAGS_R)
LIB_FLAGS		= $(LIB_FLAGS_C) $(LIB_FLAGS_R)

!endif

!if "$(CALLERTYPE)"=="D" || "$(MAKEDLL)"=="Y"
CC_FLAGS			= $(CCDLL_FLAGS)
!else
CC_FLAGS			= $(CCEXE_FLAGS)
!endif



#
# Object Files
#

# MSVC40_NE_OBJS contains a list of .OBJs that are VC++ Codeview v4.0 Win16 specific
MSVC40_NE_OBJS		= $(OUTPUTDIR)\READNE.OBJ $(OUTPUTDIR)\READCV.OBJ
LD_MSVC40_NE_OBJS	= $(OUTPUTDIR)\READNE.OBJ $(LD_OBJSEP) $(OUTPUTDIR)\READCV.OBJ
AR_MSVC40_NE_OBJS	= $(OUTPUTDIR)\READNE.OBJ $(AR_OBJSEP) $(OUTPUTDIR)\READCV.OBJ

# MSVC40_PE_OBJS contains a list of .OBJs that are VC++ Codeview v4.0 Win16 specific
MSVC40_PE_OBJS		= $(OUTPUTDIR)\READPE.OBJ $(OUTPUTDIR)\READCV.OBJ
LD_MSVC40_PE_OBJS	= $(OUTPUTDIR)\READPE.OBJ $(LD_OBJSEP) $(OUTPUTDIR)\READCV.OBJ
AR_MSVC40_PE_OBJS	= $(OUTPUTDIR)\READPE.OBJ $(AR_OBJSEP) $(OUTPUTDIR)\READCV.OBJ


!if "$(PLATFORM)"=="WIN32"
MSVC40_OBJS			= $(MSVC40_PE_OBJS)
LD_MSVC40_OBJS		= $(LD_MSVC40_PE_OBJS)
AR_MSVC40_OBJS		= $(AR_MSVC40_PE_OBJS)
!else
MSVC40_OBJS			= $(MSVC40_NE_OBJS)
LD_MSVC40_OBJS		= $(LD_MSVC40_NE_OBJS)
AR_MSVC40_OBJS		= $(AR_MSVC40_NE_OBJS)
!endif

COMPILER_OBJS		= $(MSVC40_OBJS)
LD_COMPILER_OBJS	= $(LD_MSVC40_OBJS)
AR_COMPILER_OBJS	= $(AR_MSVC40_OBJS)

!if "$(STATICRTL)"=="N"
RESP_TARGET			= /MD
!else
!if "$(MULTITHREADED)"=="Y"
RESP_TARGET			= /MT
!else
RESP_TARGET			= /ML
!endif
!endif

!if "$(DEBUG)"=="Y"
RESP_DEBUG			=/D "_DEBUG" /Zi /Fd"$(MONIKER).PDB"
!else
RESP_DEBUG			=/D "NDEBUG" /O2
!endif

!if "$(CONSOLE)"=="Y"
RESP_CONSOLE		=/D "_CONSOLE"
!endif

!if "$(PLATFORM)"=="WIN16"
RESP_MODEL			=-m$(MODEL)
!endif

!if "$(SHAREWARE)"=="Y"
RESP_SHAREWARE		=/D "NT_SHAREWARE"="1"
!endif
!if "$(BUILDTYPE)"=="S"
RESP_STANDALONE		=/D "NT_STANDALONE"="1"
!endif


$(RSP_FILE):	$(THISMAKEFILE)
	-if not exist $(OUTPUTDIR)\*.* md $(OUTPUTDIR) > NUL:
	copy <<tmpfile.rsp $(RSP_FILE)
/W3
/YX
/D "_X86_"
/D "REXE_CODEVIEW40_PE"="1"
/D "REXE_DECODE_LINENO_ONLY"="1"
/Fp"NEWTRACK.PCH"
/I "$(CC_INCDIR)"
/I "$(RELINCDIR)"
/I "$(UNRELINCDIR)"
/I "$(CFXINCDIR)"
$(RESP_STANDALONE)
$(RESP_SHAREWARE)
$(RESP_DEBUG)
$(RESP_TARGET)
$(RESP_CONSOLE)
<<




