#
# FileName
# --------
# MKVC1615.MAK
#
# Description
# -----------
# Include makefile for VC++ v1.5, 16-bit
#
# The libraries are placed in the current directory.  The compiler and
#	it's configuration are chosen with the following *required* macros:
#
#	BUILDTYPE			-	S or D		(NewTrack as Stand-Alone or DLL)
#	CALLERTYPE			-	E or D		(NewTrack called from a .DLL or .EXE)
#	MODEL				-	L or F		(Memory Model)
#	SHAREWARE			-	Y or N		(Shareware or full (sold) version)
#	MULTITHREADED		-	Y or N
#	STATICRTL			-	Y or N
#	CONSOLE				-	Y or N
#	RSP_FILE			-	Name of response file to create
#	MONIKER				-	Name of library being built
#	CFXINCDIR			-	Include directory for CFX
#	RELINCDIR			-	Include directory for released include files
#	UNRELINCDIR			-	Include directory for unreleased include files
#	OUTPUTDIR			-	Output directory for library .OBJ files
#
# Generated macros
#	COMPILER			-	Compiler (BOR or MSVC)
#	COMPILERVER			-	Version (31 or 40 for Borland, 15 or 10 for MSVC)
#	PLATFORM			-	WIN16 or WIN32
#	COMPILER_OBJS		-	Compiler-specific OBJs
#	LINK_COMPILER_OBJS	-	Compiler-specific OBJS, parsed for the linker
#
# Optional macros:
#	DEBUG				-	Y or N (default)	(Debug build)
#	MAKETEST			-	Y or N (default)	(Make test program/dll)
#
#
#
# For linking, use:
#	$(LINK) $(LINKDLL_FLAGS) @&&|
#		$(LDDLL_STARTUP)
#		$(LDDLL_ALL_OBJS)
#		$(LD_SETOUT) $(DLL_NAME)
#		$(LD_SETMAP) $(DLL_MAPNAME)
#		$(LDDLL_LIB_EXTRA)
#	!
#
# For creating libraries, use:
#	$(LIBMGR) $(LIB_FLAGS) $(LIB_SETOUT)$(LIBNAME) @&&|
#		$(LIB_ALL_DLL_OBJS)
#	|
#
#
# Need LDDLL_ALL_OBJS
#

MULTITHREADED=N
CONSOLE=N

!ifndef BUILDTYPE
!error BUILDTYPE not defined
!endif
!ifndef CALLERTYPE
!error CALLERTYPE not defined
!endif
!ifndef MODEL
!error MODEL not defined
!endif
!ifndef SHAREWARE
!error SHAREWARE not defined
!endif
!ifndef STATICRTL
!error STATICRTL not defined
!endif
!ifndef RSP_FILE
!error RSP_FILE not defined
!endif
!ifndef MONIKER
!error MONIKER not defined
!endif
!ifndef DEBUG
DEBUG=N
!endif

!if "$(MODEL)"=="s"
MODEL=S
!endif
!if "$(MODEL)"=="m"
MODEL=M
!endif
!if "$(MODEL)"=="c"
MODEL=C
!endif
!if "$(MODEL)"=="l"
MODEL=L
!endif


COMPILER=MSVC
COMPILERVER=15
PLATFORM=WIN16
USECHEAP=Y
USEDEFFILE=Y


# Tools
IMPLIB				= g:\usr\vcpp15\bin\implib
CC					= cl
ASM					= g:\usr\bc3\bin\tasm
LINK				= link
LIBMGR				= lib
BRC					= rc
LD_LIBDIR			= g:\usr\vcpp15\lib
CC_INCDIR			= g:\usr\vcpp15\include

# Tool arguments
CCDLL_FLAGS			= /nologo /GD /A$(MODEL)w @$(RSP_FILE)
CCEXE_FLAGS			= /nologo /GA /A$(MODEL) @$(RSP_FILE)
CC_SETOUT			= /Fo
CC_COMPILEONLY		= /c
CC_DEFINE			= /D
ASM_FLAGS			= /m3 /mx /I$(UNRELSRCDIR) /Ig:\usr\vcpp15\source\startup

LDDLL_FLAGS_C		= /NOLOGO /NOD /NOE /PACKC:61440 /ALIGN:16 /ONERROR:NOEXE
LDDLL_STARTUP		=
LDDLL_LIB_EXTRA		= $(LD_LIBDIR)\ oldnames libw ldllcew commdlg.lib olecli.lib olesvr.lib shell.lib
LDEXE_STARTUP		=
LDEXE_FLAGS_C		= /NOLOGO /NOD /NOE /PACKC:61440 /ALIGN:16 /ONERROR:NOEXE /STACK:10000
LDEXE_LIB_EXTRA		= $(LD_LIBDIR)\ oldnames libw llibcew commdlg.lib olecli.lib olesvr.lib shell.lib
LD_SETOUT			=
LD_SETMAP			=
LD_OBJSEP			= +
LD_LIBSEP			= +
LD_SETBASE			=
LD_SETDEF			=
LD_TERMINATE_RSP	= ;

LIB_FLAGS_C			= /NOLOGO /NOIGNORECASE
LIB_SETOUT			=
AR_OBJSEP			= -+
LIB_EOL				= &\n
LIB_TERMINATE_RSP	= ;


LDDLL_FLAGS_D		= /CO
LDEXE_FLAGS_D		= /CO
LIB_FLAGS_D			=



# Configure Debug/Non-Debug build
!if "$(DEBUG)"=="Y" || "$(DEBUG)"=="y"

LDDLL_FLAGS		= $(LDDLL_FLAGS_C) $(LDDLL_FLAGS_D)
LDEXE_FLAGS		= $(LDEXE_FLAGS_C) $(LDEXE_FLAGS_D)
LIB_FLAGS		= $(LIB_FLAGS_C) $(LIB_FLAGS_D)

!else

LDDLL_FLAGS		= $(LDDLL_FLAGS_C) $(LDDLL_FLAGS_R)
LDEXE_FLAGS		= $(LDEXE_FLAGS_C) $(LDEXE_FLAGS_R)
LIB_FLAGS		= $(LIB_FLAGS_C) $(LIB_FLAGS_R)

!endif

!if "$(CALLERTYPE)"=="D" || "$(MAKEDLL)"=="Y"
CC_FLAGS			= $(CCDLL_FLAGS)
!else
CC_FLAGS			= $(CCEXE_FLAGS)
!endif



#
# Object Files
#

# MSVC40_NE_OBJS contains a list of .OBJs that are VC++ Codeview v4.0 Win16 specific
MSVC40_NE_OBJS		= $(OUTPUTDIR)\READNE.OBJ $(OUTPUTDIR)\READCV.OBJ
LD_MSVC40_NE_OBJS	= $(OUTPUTDIR)\READNE.OBJ $(LD_OBJSEP) $(OUTPUTDIR)\READCV.OBJ
AR_MSVC40_NE_OBJS	= $(OUTPUTDIR)\READNE.OBJ $(AR_OBJSEP) $(OUTPUTDIR)\READCV.OBJ

LIB_OBJS			= $(OUTPUTDIR)\..\NT_VC15.OBJ
LD_LIB_OBJS			= $(OUTPUTDIR)\..\NT_VC15.OBJ
AR_LIB_OBJS			= $(OUTPUTDIR)\..\NT_VC15.OBJ

# MSVC40_PE_OBJS contains a list of .OBJs that are VC++ Codeview v4.0 Win32 specific
MSVC40_PE_OBJS		= $(OUTPUTDIR)\READPE.OBJ $(OUTPUTDIR)\READCV.OBJ
LD_MSVC40_PE_OBJS	= $(OUTPUTDIR)\READPE.OBJ $(LD_OBJSEP) $(OUTPUTDIR)\READCV.OBJ
AR_MSVC40_PE_OBJS	= $(OUTPUTDIR)\READPE.OBJ $(AR_OBJSEP) $(OUTPUTDIR)\READCV.OBJ


!if "$(PLATFORM)"=="WIN32"
MSVC40_OBJS			= $(MSVC40_PE_OBJS)
LD_MSVC40_OBJS		= $(LD_MSVC40_PE_OBJS)
AR_MSVC40_OBJS		= $(AR_MSVC40_PE_OBJS)
!else
MSVC40_OBJS			= $(MSVC40_NE_OBJS)
LD_MSVC40_OBJS		= $(LD_MSVC40_NE_OBJS)
AR_MSVC40_OBJS		= $(AR_MSVC40_NE_OBJS)
!endif

COMPILER_OBJS		= $(MSVC40_OBJS)
LD_COMPILER_OBJS	= $(LD_MSVC40_OBJS)
AR_COMPILER_OBJS	= $(AR_MSVC40_OBJS)

!if "$(DEBUG)"=="Y"
RESP_DEBUG			=/D "_DEBUG" /Zi /Od /G2 /Fd"$(MONIKER).PDB"
!else
RESP_DEBUG			=/D "NDEBUG" /O2 /G3
!endif

!if "$(CONSOLE)"=="Y"
RESP_CONSOLE		=/D "_CONSOLE"
!endif

!if "$(SHAREWARE)"=="Y"
RESP_SHAREWARE		=/D "NT_SHAREWARE"="1"
!endif
!if "$(BUILDTYPE)"=="S"
RESP_STANDALONE		=/D "NT_STANDALONE"="1"
!endif


$(RSP_FILE):	$(THISMAKEFILE)
	-if not exist $(OUTPUTDIR)\*.* md $(OUTPUTDIR)
	rem <<tmpfile.rsp
/W3
/YX
/D "REXE_CODEVIEW40_NE"="1"
/D "REXE_DECODE_LINENO_ONLY"="1"
/Fp"NEWTRACK.PCH"
/I "$(CC_INCDIR)"
/I "$(RELINCDIR)"
/I "$(UNRELINCDIR)"
/I "$(CHEAPINCDIR)"
/I "$(CFXINCDIR)"
$(RESP_STANDALONE)
$(RESP_SHAREWARE)
$(RESP_DEBUG)
$(RESP_TARGET)
$(RESP_CONSOLE)
$(RESP_MODEL)
<<NOKEEP
	copy tmpfile.rsp $(RSP_FILE)



