#
# FileName
# --------
# MKBC3240.MAK
#
# Description
# -----------
# Include makefile for BC++ v4.0, 32-bit (WinNT)
#
# The libraries are placed in the current directory.  The compiler and
#	it's configuration are chosen with the following *required* macros:
#
#	BUILDTYPE			-	S or D		(NewTrack as Stand-Alone or DLL)
#	CALLERTYPE			-	E or D		(NewTrack called from a .DLL or .EXE)
#	MODEL				-	L or F		(Memory Model)
#	SHAREWARE			-	Y or N		(Shareware or full (sold) version)
#	MULTITHREADED		-	Y or N
#	STATICRTL			-	Y or N
#	CONSOLE				-	Y or N
#	RSP_FILE			-	Name of response file to create
#	MONIKER				-	Name of library being built
#	CFXINCDIR			-	Include directory for CFX
#	RELINCDIR			-	Include directory for released include files
#	UNRELINCDIR			-	Include directory for unreleased include files
#	OUTPUTDIR			-	Output directory for library .OBJ files
#
# Generated macros
#	COMPILER			-	Compiler (BOR or MSVC)
#	COMPILERVER			-	Version (31 or 40 for Borland, 15 or 10 for MSVC)
#	PLATFORM			-	WIN16 or WIN32
#	COMPILER_OBJS		-	Compiler-specific OBJs
#	LINK_COMPILER_OBJS	-	Compiler-specific OBJS, parsed for the linker
#
# Optional macros:
#	DEBUG				-	Y or N (default)	(Debug build)
#	MAKETEST			-	Y or N (default)	(Make test program/dll)
#
#
#
# For linking, use:
#	$(LINK) $(LINKDLL_FLAGS) @&&|
#		$(LDDLL_STARTUP)
#		$(LDDLL_ALL_OBJS)
#		$(LD_SETOUT) $(DLL_NAME)
#		$(LD_SETMAP) $(DLL_MAPNAME)
#		$(LDDLL_LIB_EXTRA)
#	!
#
# For creating libraries, use:
#	$(LIBMGR) $(LIB_FLAGS) $(LIB_SETOUT)$(LIBNAME) @&&|
#		$(LIB_ALL_DLL_OBJS)
#	|
#
#
# Need LDDLL_ALL_OBJS
#


!ifndef BUILDTYPE
!error BUILDTYPE not defined
!endif
!ifndef CALLERTYPE
!error CALLERTYPE not defined
!endif
!ifndef MODEL
!error MODEL not defined
!endif
!ifndef SHAREWARE
!error SHAREWARE not defined
!endif
!ifndef MULTITHREADED
!error MULTITHREADED not defined
!endif
!ifndef STATICRTL
!error STATICRTL not defined
!endif
!ifndef CONSOLE
!error CONSOLE not defined
!endif
!ifndef RSP_FILE
!error RSP_FILE not defined
!endif
!ifndef MONIKER
!error MONIKER not defined
!endif
!ifndef DEBUG
DEBUG=N
!endif

!if "$(BUILDTYPE)"=="D"
STATICRTL=N
!endif


COMPILER=BOR
COMPILERVER=40
MODEL=F
PLATFORM=WIN32


# Tools
IMPLIB				= implib
CC					= bcc32
LINK				= tlink32
LIBMGR					= tlib
BRC					= brc32
LD_LIBDIR			= p:\lib
CC_INCDIR			= p:\include


# Tool arguments
CCDLL_FLAGS			= +$(RSP_FILE) -tWDE
CCEXE_FLAGS			= +$(RSP_FILE) -tWE
CC_SETOUT			= -o
CC_COMPILEONLY		= -c
CC_DEFINE			= -D

LDDLL_FLAGS_C		= -L$(LINK_LIBDIR) -wdpl -Tpd -ap -c
LDDLL_STARTUP		= $(LD_LIBDIR)\c0d32.obj+
LDDLL_LIB_EXTRA		= $(LD_LIBDIR)\import32.lib
!if "$(STATICRTL)"=="N"
LDDLL_LIB_EXTRA		= $(LDDLL_LIB_EXTRA)+$(LD_LIBDIR)\cw32i.lib
!else
LDDLL_LIB_EXTRA		= $(LDDLL_LIB_EXTRA)+$(LD_LIBDIR)\cw32.lib
!endif
LDEXE_STARTUP		= $(LD_LIBDIR)\c0x32.obj+
LDEXE_FLAGS_C		= -L$(LD_LIBDIR) -wdpl -Tpe -ap -c
LDEXE_LIB_EXTRA		= $(LDDLL_LIB_EXTRA)
LD_SETOUT			=
LD_SETMAP			=
LD_OBJSEP			= +
LD_LIBSEP			= +
LD_SETBASE			= -B:

LIB_FLAGS_C			= /C
LIB_SETOUT			=
AR_OBJSEP			= -+
LIB_EOL				=^^^&\n


LDDLL_FLAGS_D		= /v
LDEXE_FLAGS_D		= /v
LIB_FLAGS_D			=

LDDLL_FLAGS_R		= -x
LDEXE_FLAGS_R		= -x
LIB_FLAGS_R			= /0



# Configure Debug/Non-Debug build
!if "$(DEBUG)"=="Y" || "$(DEBUG)"=="y"

LDDLL_FLAGS		= $(LDDLL_FLAGS_C) $(LDDLL_FLAGS_D)
LDEXE_FLAGS		= $(LDEXE_FLAGS_C) $(LDEXE_FLAGS_D)
LIB_FLAGS		= $(LIB_FLAGS_C) $(LIB_FLAGS_D)

!else

LDDLL_FLAGS		= $(LDDLL_FLAGS_C) $(LDDLL_FLAGS_R)
LDEXE_FLAGS		= $(LDEXE_FLAGS_C) $(LDEXE_FLAGS_R)
LIB_FLAGS		= $(LIB_FLAGS_C) $(LIB_FLAGS_R)

!endif

!if "$(CALLERTYPE)"=="D" || "$(MAKEDLL)"=="Y"
CC_FLAGS			= $(CCDLL_FLAGS)
!else
CC_FLAGS			= $(CCEXE_FLAGS)
!endif



#
# Object Files
#

# BOR31_NE_OBJS contains a list of .OBJs that are BC++ v3.1 Win16 specific
BOR31_NE_OBJS		= $(OUTPUTDIR)\READNE.OBJ $(OUTPUTDIR)\READBNE.OBJ
LD_BOR31_NE_OBJS	= $(OUTPUTDIR)\READNE.OBJ+$(OUTPUTDIR)\READBNE.OBJ
AR_BOR31_NE_OBJS	= $(OUTPUTDIR)\READNE.OBJ $(AR_OBJSEP)$(OUTPUTDIR)\READBNE.OBJ

# BOR40_NE_OBJS contains a list of .OBJs that are BC++ v4.0 Win16 specific
BOR40_NE_OBJS		= $(OUTPUTDIR)\READNE.OBJ $(OUTPUTDIR)\READBNE.OBJ
LD_BOR40_NE_OBJS	= $(OUTPUTDIR)\READNE.OBJ+$(OUTPUTDIR)\READBNE.OBJ
AR_BOR40_NE_OBJS	= $(OUTPUTDIR)\READNE.OBJ $(AR_OBJSEP)$(OUTPUTDIR)\READBNE.OBJ

# BOR40_PE_OBJS contains a list of .OBJs that are BC++ v4.0 Win32 specific
BOR40_PE_OBJS		= $(OUTPUTDIR)\READPE.OBJ $(OUTPUTDIR)\READCV.OBJ $(OUTPUTDIR)\READBPE.OBJ
LD_BOR40_PE_OBJS	= $(OUTPUTDIR)\READPE.OBJ+$(OUTPUTDIR)\READCV.OBJ+$(OUTPUTDIR)\READBPE.OBJ
AR_BOR40_PE_OBJS	= $(OUTPUTDIR)\READPE.OBJ $(AR_OBJSEP)$(OUTPUTDIR)\READCV.OBJ $(AR_OBJSEP)$(OUTPUTDIR)\READBPE.OBJ

!if "$(PLATFORM)"=="WIN32"
BOR40_OBJS			= $(BOR40_PE_OBJS)
LD_BOR40_OBJS		= $(LD_BOR40_PE_OBJS)
AR_BOR40_OBJS		= $(AR_BOR40_PE_OBJS)
!else
BOR40_OBJS			= $(BOR40_NE_OBJS)
LD_BOR40_OBJS		= $(LD_BOR40_NE_OBJS)
AR_BOR40_OBJS		= $(AR_BOR40_NE_OBJS)
!endif

!if "$(STATICRTL)"=="N"
LIB_OBJS			= $(LIB_OBJS) $(OUTPUTDIR)\RTLEXTRA.OBJ
LD_LIB_OBJS			= $(LD_LIB_OBJS)+$(OUTPUTDIR)\RTLEXTRA.OBJ
AR_LIB_OBJS			= $(AR_LIB_OBJS) $(AR_OBJSEP)$(OUTPUTDIR)\RTLEXTRA.OBJ
!endif

COMPILER_OBJS		= $(BOR40_OBJS)
LD_COMPILER_OBJS	= $(LD_BOR40_OBJS)
AR_COMPILER_OBJS	= $(AR_BOR40_OBJS)


!if "$(STATICRTL)"=="N"
RESP_TARGET			= -D_RTLDLL
!else
RESP_TARGET			=
!endif

!if "$(MULTITHREADED)"=="Y"
RESP_MT				= -WM #-D_MT=1
!endif

!if "$(DEBUG)"=="Y"
RESP_DEBUG			=-D_DEBUG -v -y
!else
RESP_DEBUG			=-DNDEBUG
!endif

!if "$(COMPILERVER)"=="40"
RESP_VER			=-D_BORLAND_VER=0x400
!else
RESP_VER			=-D_BORLAND_VER=0x310
!endif

!if "$(PLATFORM)"=="WIN16"
RESP_MODEL			=-m$(MODEL)
!endif

!if "$(SHAREWARE)"=="Y"
RESP_SHAREWARE		=-DNT_SHAREWARE=1
!endif

!if "$(BUILDTYPE)"=="S"
RESP_STANDALONE		=-DNT_STANDALONE=1
!endif

!if "$(CONSOLE)"=="Y"
RESP_CONSOLE		=-D_CONSOLE
!endif



$(RSP_FILE):	$(THISMAKEFILE)
	-if not exist $(OUTPUTDIR)\*.* md $(OUTPUTDIR) > NUL:
	copy &&|
-vi
-X-
-H
-H=newtrack.csm
-R-
-k
-Od
-I$(CC_INCDIR);$(RELINCDIR);$(UNRELINCDIR)
-I$(CFXINCDIR)
-DREXE_BORLAND40_PE=1
-DREXE_CODEVIEW40_PE=1
-DREXE_DECODE_LINENO_ONLY=1
$(RESP_STANDALONE)
$(RESP_SHAREWARE)
$(RESP_DEBUG)
$(RESP_VER)
$(RESP_TARGET)
$(RESP_CONSOLE)
$(RESP_MT)
| $@




