//
// $Id: newtrack.hpp,v 1.4 1994/08/01 13:39:11 john Exp john $
//
// File name
// -------------
// NEWTRACK.HPP
//
//
// Written by John Spackman
// (c) Cavendish Software Limited, 1992-1994
//
//
// Document References
// -------------------
// This is a general purpose module, and as such has no document references
//
// File Description
// ----------------
// Newtrack v2.0/Windows.  This version of NewTrack supports windows and DLLs.
//
//
// Change Log
// ----------
// $Log: newtrack.hpp,v $
// Revision 1.4  1994/08/01  13:39:11  john
// *** empty log message ***
//
// Revision 1.3  1994/06/10  13:29:47  john
// *** empty log message ***
//
// Revision 1.2  1994/06/10  12:15:23  john
// mods to make NewTrack continually active.  Currently only support for
// VC++ v1.1 under NT, with MFC.  Other flavours to follow....
//
// Revision 1.2  1994/06/10  12:15:23  john
// mods to make NewTrack continually active.  Currently only support for
// VC++ v1.1 under NT, with MFC.  Other flavours to follow....
//
// Revision 1.1  1994/06/10  11:38:02  john
// Initial revision
//
//
//

#ifndef NEWTRACK_HPP
#define NEWTRACK_HPP

#if defined(__BORLANDC__) && !defined(_BORLAND_VER)
# define _BORLAND_VER 0x400
#endif


// HEADER FILES
#ifndef __WINDOWS_H
#include <windows.h>
#endif

#ifdef __USE_UGBUILD_CONFIG		// Define this to bring in global switches
#include <ugbuild.hpp>
#endif


// PREPROCESSOR SYMBOL DEFINITIONS -- Compiler/Environment configuration switches
#if defined(_WIN32) || defined(__FLAT__)
# define NT_WIN32			1
#else
# define NT_WIN32			0
#endif

#if defined(_MT)
# define NT_MULTITHREADED	1
#else
# define NT_MULTITHREADED	0
#endif

// PREPROCESSOR SYMBOL DEFINITIONS -- Build Switches
#ifndef NT_TRAPALLALLOCS
#define NT_TRAPALLALLOCS	1	// 1==Trap malloc(), calloc(), etc as well as new/delete
#endif


// PREPROCESSOR SYMBOL DEFINITIONS -- DLL/Exports
#if NT_WIN32

# if defined(__BORLANDC__)
#  if defined(NT_BUILDINGDLL)
#   define NT_EXPORT 	__export
#  elif !defined(NT_STANDALONE)
#   define NT_EXPORT 	__import
#  else
#   define NT_EXPORT
#  endif

# elif defined(_MSC_VER)
#  if defined(NT_BUILDINGDLL)
#   define NT_EXPORT 	_declspec(dllexport)
#  elif !defined(NT_STANDALONE)
#   define NT_EXPORT 	_declspec(dllimport)
#  else
#   define NT_EXPORT
#  endif
# endif

# define NT_HUGE
# define NT_APICALL 	_stdcall

#else
# if defined(__DLL__) || defined(_WINDLL)
#  define NT_EXPORT 	_export
# else
#  define NT_EXPORT
# endif
# define NT_HUGE		huge
# define NT_APICALL		FAR PASCAL
#endif // NT_WIN32

#if defined(_BORLAND_VER) || (defined(_MSC_VER) && !defined(_WIN32))
#define NT_FARPTR_EXPORT	FAR * NT_EXPORT
#else
#define NT_FARPTR_EXPORT	NT_EXPORT FAR *
#endif


// PREPROCESSOR SYMBOL DEFINITIONS -- Over/Under run checking
#define NT_PRE_TEXT			"PrePrePrePre"
#define NT_PRE_SIZE			strlen(NT_PRE_TEXT)
#define NT_POST_TEXT		"PostPostPost"
#define NT_POST_SIZE		strlen(NT_POST_TEXT)


// PREPROCESSOR SYMBOL DEFINITIONS -- Fill Characters
#define NT_NEWFILL			'#'
#define NT_DELFILL			(0xff)


// PREPROCESSOR SYMBOL DEFINITIONS -- Sizes
#define NTK_CALLERSTK		10		// How far to trace the caller's stack


// CONSTANT DEFINITIONS -- NewTrack Operational Flags
typedef unsigned NTF_FLAGS;
const NTF_FLAGS	NTF_NO_FLAGS	= 0x0000;	// No Flags
const NTF_FLAGS	NTF_NO_BOUNDS	= 0x0001;	// No Bounds Checking (Pre/Post space)
const NTF_FLAGS	NTF_DISABLED	= 0x0002;	// Fully Disabled
const NTF_FLAGS NTF_SHARED		= 0x0004;	// Record memory in shared table
const NTF_FLAGS	NTF_RECOLDEST	= 0x0008;	// Record oldest memory call stack
const NTF_FLAGS NTF_IGNORE		= 0x2000;	// Used outside NT_Initialise()/NT_Terminate()
const NTF_FLAGS NTF_NOTASK		= 0x4000;	// Returned if no task
const NTF_FLAGS	NTF_NO_CHANGE	= 0x8000;	// Don't change flags (NT_SetFlags() only)


// TYPE DEFINITIONS
typedef unsigned char NT_HUGE	*NT_PTR;
typedef unsigned long			NT_SIZE;
typedef UINT					TRK_CALLER;


// STRUCTURE DEFINITIONS
typedef struct tagNT_CALLBACKDATA
{
	NT_PTR				ptr;		// Pointer to the allocated memory
	NT_SIZE				size;		// Size (bytes) of the allocated memory
	void FAR			**caller;	// Call stack
} NT_CALLBACKDATA, FAR *LPNT_CALLBACKDATA;

typedef void 					(CALLBACK *NT_CALLBACKFUNC)(
									LPNT_CALLBACKDATA pData,
									LPNT_CALLBACKDATA pSharedData);


// PREPROCESSOR SYMBOL DEFINITIONS -- Complete Exclusion of NewTrack
#if (!defined(USE_NEWTRACK)) || (USE_NEWTRACK)


// PREPROCESSOR SYMBOL DEFINITIONS -- Macros to turn NewTrack on & off
#define NEWTRACK_ON()		NT_SetFlags(NTF_NO_FLAGS);
#define NEWTRACK_OFF()		NT_SetFlags(NTF_NO_BOUNDS);
#define NEWTRACK_DISABLE()	NT_SetFlags(NTF_DISABLED);
#define NEWTRACK_ENABLE()	NT_SetFlags(NTF_NO_FLAGS);
#define NEWTRACK_PUSH()		NTF_FLAGS __save__newtrack = NT_SetFlags(NTF_NO_CHANGE);
#define NEWTRACK_POP()		NT_SetFlags(__save__newtrack);

#if NT_WIN32
# define NEWTRACK_REGISTER_MODULE(m)	{ __newtrack_module_hInstance = m; __newtrack_registered_module = FALSE; }
#else
# define NEWTRACK_REGISTER_MODULE(m)	(0)
#endif

#define NT_Initialize		NT_Initialise


// EXTERNAL VARIABLES -- Turns NewTrack on & off in NEWTRACK.CPP
extern int FAR __newtrack;
#if NT_WIN32
extern HINSTANCE	__newtrack_module_hInstance;
extern BOOL			__newtrack_registered_module;
#endif


// FUNCTION PROTOTYPES
#ifndef __cplusplus
#define NT_DEFAULT_ARG(val)
#else
#define NT_DEFAULT_ARG(val)	= val
extern "C"
{
#endif

// Initialises and starts NewTrack
void					  NT_APICALL NT_Initialise(
										NTF_FLAGS _ntfflags NT_DEFAULT_ARG(NTF_NO_FLAGS),
										NT_CALLBACKFUNC _ntcallback NT_DEFAULT_ARG(NULL));

// Terminates NewTrack, reports lost memory, generates log file, and calls callback
unsigned long			  NT_APICALL NT_Terminate(void);

// Returns the number of outstanding unfreed allocations
unsigned long	NT_EXPORT NT_APICALL NT_NAllocs(void);

// Registers allocated memory with NewTrack; memory is filled with known
//	garbage
NT_PTR			NT_EXPORT NT_APICALL NT_New(void FAR *_p, NT_SIZE size, TRK_CALLER caller);

// Removes (de-registers) memory from NewTrack's log, returning NULL on
//	error; memory is filled with known garbage
void			NT_FARPTR_EXPORT NT_APICALL NT_Delete(NT_PTR p);

// Registers memory with NewTrack; memory is NOT filled
NT_PTR			NT_EXPORT NT_APICALL NT_Add(void FAR *_p, NT_SIZE size, TRK_CALLER caller);

// Removes (de-registers) memory from NewTrack's log, returning NULL on
//		error; memory is NOT filled
void			NT_FARPTR_EXPORT NT_APICALL NT_Remove(NT_PTR p);

// Calculates how much memory should *really* be allocated for a given
//		size
NT_SIZE			NT_EXPORT NT_APICALL NT_NewSize(unsigned long size);

// Sets and/or returns the flags for the current task
NTF_FLAGS		NT_EXPORT NT_APICALL NT_SetFlags(NTF_FLAGS _ntfflags);

// Sets the output log file
const char		NT_FARPTR_EXPORT NT_APICALL NT_SetLogFile(const char *_logfile NT_DEFAULT_ARG(NULL));

// Validates a pointer
int				NT_EXPORT NT_APICALL NT_AssertPointer(void FAR *base, void FAR *chk, NT_SIZE size);

// Validates a pointer with an offset
int				NT_EXPORT NT_APICALL NT_AssertOffset(void FAR *base, NT_SIZE offset, NT_SIZE size);

// Returns the "real" pointer (ie the one returned by the allocator, not the
//	one generated by NewTrack
void			NT_FARPTR_EXPORT NT_APICALL NT_DemanglePointer(NT_PTR p);

// Makes NewTrack ignore the given pointer (ie allows it to be unfreed).  The pointer
//	must be NewTrack-valid.
void			NT_EXPORT NT_APICALL NT_SetIgnorePointer(NT_PTR p, BOOL bIgnore);

// Allocates memory and logs it with NewTrack; defined in NEWTRACK.CPP
void FAR *				  NT_APICALL NT_AllocMem(unsigned long size, void FAR *caller);

// GlobalAlloc() replacement; logs the allocation with NewTrack
HGLOBAL               	  NT_APICALL NT_GlobalAlloc(UINT flags, DWORD size);


// GlobalFree() replacement to match NT_GlobalAlloc(); validates
//		allocation with NewTrack
HGLOBAL				  	  NT_APICALL NT_GlobalFree(HGLOBAL hglb);

BOOL			NT_EXPORT NT_APICALL NT_ValidateWinHeap(void);

// Returns a heap object, obtaining it from HeapCreate() if not already
//	created.  Serialised for multple thread access if built for multithreading.
#if NT_WIN32 || !defined(_BORLAND_VER)
HANDLE			NT_EXPORT NT_APICALL NT_GetHeapObject(void);
#endif

#if NT_WIN32
// Registers a DLL for line-number decoding.  If either parameter is NULL,
//	it will be obtained from the system - BUT at least one must be provided.
//	Only required for Win32.
BOOL			NT_EXPORT NT_APICALL NT_RegisterModule(HMODULE hModule,
							const char FAR *pModuleName);
#endif

#ifdef __cplusplus
};
#endif

#if !NT_WIN32
#define NT_RegisterModule(m, n)		(TRUE)
#endif

#else // !def(USE_NEWTRACK) || USE_NEWTRACK


// PREPROCESSOR SYMBOL DEFINITIONS -- Fake NewTrack to the compiler
#define NEWTRACK_ON()				(0)
#define NEWTRACK_OFF()				(0)
#define NEWTRACK_DISABLE()			(0)
#define NEWTRACK_ENABLE()			(0)
#define NEWTRACK_PUSH()				(0)
#define NEWTRACK_POP()				(0)
#define NEWTRACK_REGISTER_MODULE(m)	(0)

#define NT_Initialise(f)			(0)
#define NT_Initialise()				(0)
#define NT_Initialize(f)			(0)
#define NT_Initialize()				(0)
#define NT_Terminate()				(0)
#define NT_NAllocs()				(0)
#define NT_New(p, s, c)				(p)
#define NT_Delete(p)				(p)

#define NT_Add(p, s, c)				(p)
#define NT_Remove(p)				(p)
#define NT_NewSize(s)				(s)
#define NT_SetFlags(f)				(NTF_NO_FLAGS)
#define NT_SetLogFile(f)			(f)
#define NT_AssertPointer(b, c, s)	1
#define NT_AssertOffset(b, o, s)	1
#define NT_DemangePointer(p)		(p)

#define NT_AllocMem(s, c)			(farmalloc(s))
#define NT_GlobalAlloc(f, s)		GlobalAlloc((f), (s))
#define NT_GlobalFree(h)			GlobalFree(h)

#if NT_WIN32
#define NT_RegisterModule(m, n)		(TRUE)
#endif


#endif // !def(USE_NEWTRACK) || USE_NEWTRACK

#endif // !def(NEWTRACK_HPP)


