//
// $Id$
//
// FileName
// --------
// RTLEXTRA.CPP
//
// Description
// -----------
// This module resolves problems with the Borland C/C++ Run-Time Library DLL,
//	where it expects to either allocate or free memory on behalf of the
//	application.
//
// ***************************************************************************
// ***                                                                     ***
// *** Include this file in your build with NewTrack if you are using the  ***
// ***   DLL version of the Borland Run-Time Library.                      ***
// ***                                                                     ***
// ***************************************************************************
//
//
// Written by John Spackman
// (c) Cavendish Software Limited, 1994
//
//
// Change Log
// ----------
/* $Log$
 */
//


#if !defined(__BORLANDC__)
#error This module only works with Borland C/C++ Compilers (v3.1 and 4.x)
#endif

#if !defined(_BORLAND_VER)
#error You must set the _BORLAND_VER macro to 0x310 or 0x400 to indicate compiler version number
#endif



// HEADER FILES
#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include <direct.h>
#include <dos.h>
#include <errno.h>
#include <stdlib.h>
#include <dir.h>
#include <ctype.h>
#include <windows.h>
#include <newtrack.hpp>


#define CALL_FUNC(func, params)							\
	{													\
		return func params;								\
	}

#define CALL_AND_COPY_RESULT(func, params)				\
	{													\
		char	*p = func params;						\
		char	*pNew;                                  \
														\
		if (p != NULL)                                  \
		{                                               \
			pNew = strdup(p);                           \
			NEWTRACK_PUSH();                            \
			NEWTRACK_DISABLE();                         \
			free(p);                                    \
			NEWTRACK_POP();                             \
			return pNew;                                \
		}                                               \
														\
		return NULL;									\
	}




///////////////////////////////////////////////////////////////////////////////
//
// Re-written functions in STRDUP.C
//

char * _FARFUNC strdup(const char *pOriginal)
{
	char	*pCopy = new char [ strlen(pOriginal) + 1 ];

	if (pCopy != NULL)
		strcpy(pCopy, pOriginal);

	return pCopy;
}

////////////////////////////////////////////////////////////////////////////////
//
// Re-written functions in FULLPATH.C
//

extern "C" char *_NT__fullpath(char *, const char *, size_t);

char * _CType _FARFUNC _fullpath(char *pBuffer, const char *pPath,
	size_t nMaxLen)
{
	return _NT__fullpath(pBuffer, pPath, nMaxLen);
}


////////////////////////////////////////////////////////////////////////////////
//
// Re-written functions in GETDCWD.CAS
//

extern "C" char *_NT__getdcwd(int, char _FAR *, int);

char * _FARFUNC _getdcwd(int nDrive, char _FAR *pBuffer, int nMaxLen)
{
	return _NT__getdcwd(nDrive, pBuffer, nMaxLen);
}


////////////////////////////////////////////////////////////////////////////////
//
// Re-written functions in GETCWD.C
//

extern "C" char *_NT_getcwd(char _FAR *, int);

char * _FARFUNC getcwd(char _FAR *pBuffer, int nMaxLen)
{
	return _NT_getcwd(pBuffer, nMaxLen);
}


////////////////////////////////////////////////////////////////////////////////
//
// Re-written functions in TMPNAM.C
//

extern "C" char *_NT_tempnam(char *, char *);

char * _FARFUNC tempnam(char *dir, char *prefix)
{
	return _NT_tempnam(dir, prefix);
}


