//
// $Id: NEWTRACK.CPP,v 1.6 1994/08/01 13:38:28 john Exp john $
//
// File name
// -------------
// NEWTRACK.CPP
//
//
// Written by John Spackman
// (c) Cavendish Software Limited, 1992-1994
//
//
// Document References
// -------------------
// This is a general purpose module, and as such has no document references
//
// File Description
// ----------------
// Newtrack v2.0/Windows.  This part of NewTrack must be included in
//	each .EXE or .DLL.
//
// Change Log
// ----------
// $Log: NEWTRACK.CPP,v $
// Revision 1.6  1994/08/01  13:38:28  john
// *** empty log message ***
//
// Revision 1.5  1994/06/10  13:29:28  john
// *** empty log message ***
//
// Revision 1.2  1994/06/10  11:28:18  john
// patched up the header
//
//
//


// HEADER FILES

// Uncomment this for VC++ precompiled headers
//#include "stdafx.h"

#if defined(NT_USING_MFC) && !defined(__AFXWIN_H__)
#include <afxwin.h>
#endif

#include "newtrack.hpp"

#if (!defined(USE_NEWTRACK)) || (USE_NEWTRACK)

#if !NT_WIN32 && !defined(_BORLAND_VER)
#include "cheap.hpp"
#endif

#include <malloc.h>
#include <dos.h>
#include <string.h>
#include <windows.h>
#include <stdlib.h>


#if defined(NT_USING_MFC)
#define NT_TRAPOPERATORS		0		// 0 == Don't trap operator new, etc
#endif


// Check that we can tell the compiler version number when under Borland
//	(BC++ has the same version number for 3.x and 4.x!!!).  Define the version
//	number in hex as follows:
//		v3.1		_BORLAND_VER=0x310
//		v4.0		_BORLAND_VER=0x400
//
#if defined(__BORLANDC__) && (!defined(_BORLAND_VER))
#error _BORLAND_VER must be defined to show the Borland C++ version number
#endif


// PREPROCESSOR SYMBOL DEFINITIONS -- Compiler-dependant allocation routines
#if NT_WIN32 || !defined(_BORLAND_VER)

  static LPVOID _NT_FarMalloc(DWORD luSize);
  static BOOL   _NT_FarFree(LPVOID lpvMem);
  static LPVOID _NT_FarRealloc(LPVOID lpvMem, DWORD luSize);
  static DWORD	_NT_FarMSize(LPVOID lpvMem);
# define _FAR_MALLOC(s, f)			_NT_FarMalloc(s)
# define _FAR_FREE(p, f)			_NT_FarFree(p)
# define _FAR_REALLOC(p, s, f)		_NT_FarRealloc(p, s)
# define _FAR_MSIZE(p)				_NT_FarMSize(p)

#else // !NT_WIN32 && _BORLAND_VER

#  define _FAR_MALLOC(s, f)			_farmallocf(s, f)
#  define _FAR_FREE(p, f)			_farfreef(p, f)
#  define _FAR_REALLOC(p, s, f)		_farreallocf(p, s, f)

#endif // !NT_WIN32


// PREPROCESSOR SYMBOL DEFINITIONS - Macros
#define _UNCALLABLE_FUNCTION(s)	MessageBox(HWND_DESKTOP, \
	s " cannot be used with NewTrack", \
	"NewTrack Fatal Error", MB_SYSTEMMODAL | MB_OK)

#if NT_WIN32
#define TEST_REGISTERED_MODULE										\
		if (!__newtrack_registered_module)							\
		{															\
			NT_RegisterModule(__newtrack_module_hInstance, NULL);	\
			__newtrack_registered_module = TRUE;					\
		}
#else
#define TEST_REGISTERED_MODULE
#endif

#if NT_USING_MFC
#define CHECK_MFC_SETTING(p)											\
		if ( !AfxMemoryTrackingIsEnabled() )	\
			NT_SetIgnorePointer((NT_PTR) p, TRUE);
			
inline BOOL AfxMemoryTrackingIsEnabled(void)
	{
		BOOL bTracking = AfxEnableMemoryTracking(TRUE);
		AfxEnableMemoryTracking(bTracking);
		return bTracking; 
	}
	
#else
#define CHECK_MFC_SETTING(p)	(0)
#endif


// FUNCTION PROTOTYPES
#if defined(_BORLAND_VER) && !NT_WIN32
extern "C"
{
    extern unsigned _WinAllocFlag;

    void FAR * _farmallocf (unsigned long size, unsigned flags);
    void FAR * _farcallocf (unsigned long nitems,
                       unsigned long size, unsigned flags);
    void _farfreef (void FAR *block, unsigned flags);
    void FAR * _farreallocf (void FAR *block, unsigned long size,
					unsigned flags);

	void FAR *farmalloc(unsigned long size);
	void FAR *farcalloc(unsigned long nitems, unsigned long size);
	void farfree(void FAR *block);
	void FAR *farrealloc(void FAR *block, unsigned long size);
	void *malloc(size_t size);
	void *realloc(void *block, size_t size);
	void *calloc(size_t nitems, size_t size);
	void free(void *block);
};
#endif // d(_BORLAND_VER) && !NT_WIN32

#if defined(_BORLAND_VER)
# if NT_WIN32
#  define NT_GetBP() _EBP

# else // !NT_WIN32
#  define NT_GetBP() _BP
# endif // !NT_WIN32

#else // !d(_BORLAND_VER)
static unsigned int NT_GetBP(void);

#endif

#if !defined(_BORLAND_VER) || NT_WIN32
#define _WinAllocFlag		0
#endif // !d(_BORLAND_VER) || NT_WIN32


// GLOBAL VARIABLES
int FAR __newtrack = 1;
#if NT_WIN32
HINSTANCE	__newtrack_module_hInstance = NULL;
BOOL		__newtrack_registered_module = TRUE;
#else
extern "C" char **__argv;
#endif


// FUNCTIONS

void FAR *NT_farmallocf(unsigned long size, TRK_CALLER caller)
{
	if (__newtrack)
    {
		TEST_REGISTERED_MODULE;

		NT_SIZE ntsize = NT_NewSize(size);

		void FAR *p = NT_New(_FAR_MALLOC(ntsize, _WinAllocFlag), ntsize, caller);
		CHECK_MFC_SETTING(p);
		
		return p;
	}
	return _FAR_MALLOC(size, _WinAllocFlag);
}

void FAR *NT_farcallocf(unsigned long nitems, unsigned long size, TRK_CALLER caller)
{
	void FAR *p;

	if (__newtrack)
    {
		TEST_REGISTERED_MODULE;

		NT_SIZE ntsize = NT_NewSize(nitems * size);

		p = NT_New(_FAR_MALLOC(ntsize, _WinAllocFlag), ntsize, caller);
		CHECK_MFC_SETTING(p);
	}
	else
		p = _FAR_MALLOC(size, _WinAllocFlag);

	if (p != NULL)
	{
		char NT_HUGE *q = (char NT_HUGE *)p;
		char NT_HUGE *r = q + (nitems * size);
		while (q < r)
			*q++ = 0;
	}

	return p;
}

void NT_farfreef(void FAR *block)
{
	if (__newtrack)
    {
		TEST_REGISTERED_MODULE;

		void FAR *p;

		p = NT_Delete((NT_PTR) block);
		if (p != NULL)
			_FAR_FREE(p, _WinAllocFlag);
	}
    else
		_FAR_FREE(block, _WinAllocFlag);
}

void FAR *NT_farreallocf(void FAR *block, unsigned long size, TRK_CALLER caller)
{
	void FAR *p = NULL;

	if (__newtrack)
    {
		TEST_REGISTERED_MODULE;
		
		if (block != NULL)
    	{
			p = NT_Remove((NT_PTR) block);

			if (p != NULL)
			{
				NT_SIZE ntsize = NT_NewSize(size);

				p = NT_Add(_FAR_REALLOC(p, ntsize, _WinAllocFlag), ntsize, caller);
				CHECK_MFC_SETTING(p);
			}
		}
		else
		{
			p = NT_farmallocf(size, caller);
		}
	}
	else
    	p = _FAR_REALLOC(block, size, _WinAllocFlag);

	return p;
}

#if defined(_MSC_VER)
unsigned int NT_farmsizef(void FAR *block)
{
	if (__newtrack)
	{
		TEST_REGISTERED_MODULE;
		
		if (NT_SetFlags(NTF_NO_CHANGE) & NTF_DISABLED ||
			NT_AssertPointer(block, NULL, 0))
			return (int) _FAR_MSIZE(block);
		else
			return 0;
	}
		
	return (int) _FAR_MSIZE(block);
}
#endif





//
//
// Functions which over-ride the default for tracking
//
//

#if defined(_MSC_VER)
#define OP_DECL		_far _cdecl
#else
#define OP_DECL
#endif

#if (!defined(NT_TRAPOPERATORS)) || (NT_TRAPOPERATORS)

// Allocates a pointer, tracking the pointer if active
void * OP_DECL operator new(unsigned size)
{
	return NT_farmallocf(size, NT_GetBP());
}

// Allocates a pointer, tracking the pointer if active
#if defined(_BORLAND_VER) && (!(defined(_WIN32) || defined(__FLAT__)))
void FAR *operator new(unsigned long size)
{
	return NT_farmallocf(size, _BP);
}
#endif // defined(_BORLAND_VER) && (!(defined(_WIN32) || defined(__FLAT__)))

// Allocates a pointer, tracking the pointer if active
#if defined(_MSC_VER) && !defined(_WIN32)
void __huge *operator new(unsigned long nelems, unsigned int size)
{
	return NT_farmallocf(size * nelems, NT_GetBP());
}
#endif // defined(_MSC_VER) && !defined(_WIN32)

#if defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__)
// Deletes the pointer, with validation if active
void OP_DECL operator delete(void FAR *p)
{
	if (p != NULL)
		NT_farfreef((void FAR *)p);
}
#endif // def(__TINY__) || def(__SMALL__) || def(__MEDIUM__)

// Deletes the pointer, with validation if active
void OP_DECL operator delete(void *p)
{
	if (p != NULL)
		NT_farfreef(p);
}

#if defined(_MSC_VER) && !defined(_WIN32)
// Deletes the pointer, with validation if active
void OP_DECL operator delete(void __huge *p)
{
	if (p != NULL)
		NT_farfreef((void FAR *)p);
}
#endif // defined(_MSC_VER) && !defined(_WIN32)

#if defined(_BORLAND_VER) && (_BORLAND_VER >= 0x400)
// Allocates an array, tracking the pointer if NewTrack is active
void *operator new[](unsigned size)
{
	return NT_farmallocf(size, NT_GetBP());
}

// Allocates an array, tracking the pointer if NewTrack is active
#if !(defined(_WIN32) || defined(__FLAT__))
void FAR *operator new[](unsigned long size)
{
	return NT_farmallocf(size, NT_GetBP());
}
#endif // !(defined(_WIN32) || defined(__FLAT__))

// Deletes an array, with pointer validation if NewTrack is active
void operator delete[](void *ptr)
{
	if (ptr != NULL)
		NT_farfreef(ptr);
}

#if defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__)
// Deletes an array, with pointer validation if NewTrack is active
void operator delete[](void FAR *p)
{
	if (ptr != NULL)
		NT_farfreef((void FAR *)p);
}
#endif // def(__TINY__) || def(__SMALL__) || def(__MEDIUM__)
#endif // def(_BORLAND_VER) && _BORLAND_VER >= 0x400

#endif // !def(NT_TRAPOPERATORS) || NT_TRAPOPERATORS


#if NT_TRAPALLALLOCS
#if !(defined(__LARGE__) || defined(__COMPACT__) || defined(__FLAT__))
void FAR *farmalloc(unsigned long size)
{
	return NT_farmallocf(size, NT_GetBP());
}

void FAR *farcalloc(unsigned long nitems, unsigned long size)
{
	return NT_farcallocf(nitems, size, NT_GetBP());
}

void farfree(void FAR *block)
{
	NT_farfreef(block);
}

void FAR *farrealloc(void FAR *block, unsigned long size)
{
	return NT_farreallocf(block, size, NT_GetBP());
}
#endif // !(defined(__LARGE__) || defined(__COMPACT__) || defined(__FLAT__))

void *malloc(size_t size)
{
	return NT_farmallocf(size, NT_GetBP());
}


void *realloc(void *block, size_t size)
{
	return NT_farreallocf(block, size, NT_GetBP());
}

void *calloc(size_t nitems, size_t size)
{
	return NT_farcallocf(nitems, size, NT_GetBP());
}

void free(void *block)
{
	NT_farfreef(block);
}

#if defined(_MSC_VER)
size_t __cdecl _msize(void *block)
{
	return NT_farmsizef(block);
}

void *__cdecl _expand(void *, size_t)
{
	_UNCALLABLE_FUNCTION("_expand");
	return NULL;
}

int __cdecl _heapadd(void *, size_t)
{
	_UNCALLABLE_FUNCTION("_heapadd");
	return -1;
}

int __cdecl _heapchk(void)
{
	_UNCALLABLE_FUNCTION("_heapchk");
	return _HEAPEMPTY;
}

int __cdecl _heapmin(void)
{
	_UNCALLABLE_FUNCTION("_heapmin");
	return -1;
}

int __cdecl _heapset(unsigned int)
{
	_UNCALLABLE_FUNCTION("_heapset");
	return _HEAPEMPTY;
}

int __cdecl _heapwalk(_HEAPINFO *)
{
	_UNCALLABLE_FUNCTION("_heapwalk");
	return _HEAPEMPTY;
}
#endif // d(_MSC_VER)
#endif // NT_TRAPALLALLOCS


HGLOBAL NT_APICALL NT_GlobalAlloc(UINT flags, DWORD size)
{
	TEST_REGISTERED_MODULE;
		
	NT_SIZE			ntsize = NT_NewSize(size);
	HGLOBAL			hglb = GlobalAlloc(flags, ntsize);
    LPVOID			lpVoid = hglb != NULL ? GlobalLock(hglb) : NULL;

	// Save the NewTrack flags, and switch on sharing if necessary
	NTF_FLAGS oldflags = NT_SetFlags(NTF_NO_CHANGE);
	NTF_FLAGS newflags = oldflags | NTF_NO_BOUNDS;
	if (flags & (GMEM_SHARE | GMEM_DDESHARE))
		newflags |= NTF_SHARED;
	NT_SetFlags(newflags);

    // Record the allocation
	lpVoid = NT_New(lpVoid, ntsize, NT_GetBP());

    // Restore the NewTrack flags
	NT_SetFlags(oldflags);

	// Free it up if it didn't work
	if (hglb != NULL)
	{
		GlobalUnlock(hglb);
		if (lpVoid == NULL)
		{
			GlobalFree(hglb);
            hglb = NULL;
        }
	}

    return hglb;
}

HGLOBAL NT_APICALL NT_GlobalFree(HGLOBAL hglb)
{
	TEST_REGISTERED_MODULE;
		
	LPVOID		lpVoid = hglb != NULL ? GlobalLock(hglb) : NULL;

	// Save the NewTrack flags, and switch off bounds checking
	NTF_FLAGS oldflags = NT_SetFlags(NTF_NO_CHANGE);
	NT_SetFlags(oldflags | NTF_NO_BOUNDS);

	if (NT_Delete((NT_PTR) lpVoid) != NULL)
	{
		if (GlobalUnlock(hglb) == 0)
			GlobalFree(hglb);
		hglb = NULL;
	}

    // Restore NewTrack flags
	NT_SetFlags(oldflags);

	return hglb;
}





//
//
//
// Static Helper Functions
//
//

#if !defined(_BORLAND_VER)
static unsigned int NT_GetBP(void)
{
	unsigned int retval;

#if NT_WIN32
	_asm {
		mov		eax, [ebp]
		mov		[retval], eax
	}
#else
	_asm {
		mov		ax, [bp]
		mov		[retval], ax
	}
#endif

	return retval;
}
#endif // !defined(_BORLAND_VER)

#if NT_WIN32 || !defined(_BORLAND_VER)
static LPVOID _NT_FarMalloc(DWORD luSize)
{
	HANDLE	hHeapObj = NT_GetHeapObject();

	if (hHeapObj == NULL)
		return NULL;

	return HeapAlloc(hHeapObj, 0, luSize);
}

static BOOL _NT_FarFree(LPVOID lpvMem)
{
	HANDLE	hHeapObj = NT_GetHeapObject();

	if (hHeapObj == NULL)
		return FALSE;

	return HeapFree(hHeapObj, 0, lpvMem);
}

static LPVOID _NT_FarRealloc(LPVOID lpvMem, DWORD luSize)
{
	HANDLE	hHeapObj = NT_GetHeapObject();

	if (hHeapObj == NULL)
		return NULL;

	return HeapReAlloc(hHeapObj, 0, lpvMem, luSize);
}

static DWORD _NT_FarMSize(LPVOID lpvMem)
{
	HANDLE	hHeapObj = NT_GetHeapObject();

	if (hHeapObj == NULL)
		return 0;

	return HeapSize(hHeapObj, 0L, lpvMem);
}

#endif

// Initialises and starts NewTrack
extern "C" void NT_APICALL _NT_Initialise(NTF_FLAGS _ntfflags NT_DEFAULT_ARG(NTF_NO_FLAGS),
									NT_CALLBACKFUNC _ntcallback NT_DEFAULT_ARG(NULL));

// Terminates NewTrack, reports lost memory, generates log file, and calls callback
extern "C" unsigned long NT_APICALL _NT_Terminate(void);

#if defined(_MSC_VER)

typedef void (*PCLEANUP)(void);

#if defined(_WIN32)
extern "C" PCLEANUP		__xt_a;
inline PCLEANUP *_GetPreTerminatorBegin(void) { return &__xt_a; }
#else
extern "C" PCLEANUP *_GetPreTerminatorBegin(void);
#endif

static PCLEANUP _g_pOldCleanup = 0;

void NT_CleanupFunction(void)
{
	if (_g_pOldCleanup != NULL)
		(*_g_pOldCleanup)();
	NT_Terminate();
}
#endif // d(_MSC_VER)

#if defined(__BORLANDC__)
void NT_CleanupFunction(void)
{
	NT_Terminate();
}
#pragma exit NT_CleanupFunction 0
#endif

// Initialises and starts NewTrack
void NT_APICALL NT_Initialise(NTF_FLAGS _ntfflags, NT_CALLBACKFUNC _ntcallback)
{
	_NT_Initialise(_ntfflags, _ntcallback);

#if defined(_MSC_VER)
	// Save the previous Cleaup function, and install our own
	_g_pOldCleanup = *_GetPreTerminatorBegin();
	*(_GetPreTerminatorBegin()) = NT_CleanupFunction;
#endif
}

// Terminates NewTrack, reports lost memory, generates log file, and calls callback
unsigned long NT_APICALL NT_Terminate(void)
{
#if defined(_MSC_VER) && !defined(NT_WIN32)
	// Ignore things in startup that are never freed
	char **ppEnv = _environ;
	if (ppEnv != NULL)
	{
		NT_SetIgnorePointer((NT_PTR) ppEnv, TRUE);
		if (*ppEnv != NULL)
			NT_SetIgnorePointer((NT_PTR) *ppEnv, TRUE);
	}
	if (__argv[0] != NULL)
		NT_SetIgnorePointer((NT_PTR) __argv[0], TRUE);
#endif

	// Call NewTrack
	return _NT_Terminate();
}


#endif // !def(USE_NEWTRACK) || (USE_NEWTRACK != 0)


