
//#define WANT_STREAM
#define WANT_MATH

#include "include.h"

#include "newmatap.h"

void Print(const Matrix& X);
void Print(const UpperTriangularMatrix& X);
void Print(const DiagonalMatrix& X);
void Print(const SymmetricMatrix& X);
void Print(const LowerTriangularMatrix& X);

void Clean(Matrix&, Real);




static void test(int n)
{
   Tracer et("Test FFT");

   ColumnVector A(n), B(n), X, Y;
   for (int i=0; i<n; i++)
   {
      Real f = 6.2831853071795864769*i/n;
      A.element(i) = fabs(sin(7.0*f) + 0.5 * cos(19.0 * f));
      B.element(i) = fabs(0.25 * cos(31.0 * f));
   }
   FFT(A, B, X, Y);
   X=X/n; Y=-Y/n;
   FFT(X, Y, X, Y);
   Y = -Y;
   X = X - A; Y = Y - B;
   Clean(X,0.000000001); Clean(Y,0.000000001); Print(X); Print(Y);
}

void trymatf()
{
   Tracer et("Fifteenth test of Matrix package");
   Exception::PrintTrace(TRUE);
//   cout << "\nFifteenth test of Matrix package\n";
//   cout << "\n";

   ColumnVector A(12), B(12);
   for (int i = 1; i <=12; i++)
   {
      Real i1 = i - 1;
      A(i) = .7
           + .2 * cos(6.2831853071795864769 * 4.0 * i1 / 12)
           + .3 * sin(6.2831853071795864769 * 3.0 * i1 / 12);
      B(i) = .9
           + .5 * sin(6.2831853071795864769 * 2.0 * i1 / 12)
           + .4 * cos(6.2831853071795864769 * 1.0 * i1 / 12);
   }
   FFT(A, B, A, B);
   A(1) -= 8.4; A(3) -= 3.0; A(5) -= 1.2; A(9) -= 1.2; A(11) += 3.0;
   B(1) -= 10.8; B(2) -= 2.4; B(4) += 1.8; B(10) -= 1.8; B(12) -= 2.4;
   Clean(A,0.000000001); Clean(B,0.000000001); Print(A); Print(B);

   test(2048);
   test(2000);
   test(27*81);
   test(2310);
   test(49*49);
   test(13*13*13);
   test(43*47);

//   cout << "\nEnd of Fifteenth test\n";
}
