																			  /*
	NewHeap -- Copyright 1994 by Philippe Goutier, all rights reserved.

	FILE		:	newdebug.h
	DATE		:	24/4/94
	CONTENTS
	~~~~~~~~
	Macro used for debugging.

----------------------------------------------------------------------------- */

#ifndef NEWDEBUG_H
#define NEWDEBUG_H

#ifndef NEWHEAP_H
#include <newheap.h>
#endif

/* -------------------------------------------------------------------------- */

#ifdef NH_DEBUG
///////////////

// new macros
#define	new_debug				new(__LINE__,NH_FILE)
#define	new_debug1(heap)	  	new(heap, __LINE__, NH_FILE)
#define	new_debug2(heap, mode)	new(heap, mode, __LINE__, NH_FILE)

#ifdef _MSC_VER	// for MFC
	#undef	DEBUG_NEW
	#define	DEBUG_NEW	new_debug
#endif

// delete macro
#define	delete_debug	NHLocation(NH_FILE,__LINE__), delete
#undef delete
#define	delete			delete_debug

#else	// ! NH_DEBUG
//////////////////////

#define	new_debug				new
#define	new_debug1	  			new
#define	new_debug2				new
#define	delete_debug			delete

#endif	// ! NH_DEBUG
////////////////////

#undef	new

#if defined(NH_OVERLOAD_NEW_1)
	#define	new(heap)		new_debug1(heap)
#elif defined(NH_OVERLOAD_NEW_2)
	#define	new(heap,mode)	new_debug2(heap,mode)
#else
	#define	new	new_debug
#endif

/* -------------------------------------------------------------------------- */

#ifdef NH_DEBUG
///////////////

// to prevent having too much string data because of the multiple use of __FILE__
// one can place the macro REG_FILE_NAME at the beginning of each file.
#undef	NH_FILE
#ifdef	THIS_FILE	// for MFC compatibility
	#define	NH_FILE	THIS_FILE
#else
	#define	NH_FILE	__FILE__
#endif
#define	REG_FILE_NAME	static const char* NH_FILE = __FILE__

#else	// ! NH_DEBUG
/////////////////////

#define	REG_FILE_NAME

#endif	// ! NH_DEBUG
/////////////////////

/* -------------------------------------------------------------------------- */

// NHeap public function replacements
#ifdef NH_DEBUG
#undef	MainAlloc
#undef	MainAllocArray
#undef	MainStoreData
#undef	MainStoreString

#define	NH_Alloc			SetOrigin(NH_FILE,__LINE__)->Alloc
#define	NH_AllocArray		SetOrigin(NH_FILE,__LINE__)->AllocArray
#define	NH_StoreData		SetOrigin(NH_FILE,__LINE__)->StoreData
#define	NH_StoreString		SetOrigin(NH_FILE,__LINE__)->StoreString
#define	NH_Clear			SetOrigin(NH_FILE,__LINE__)->Clear
#ifdef __BORLANDC__	// because of a bug
#define	NH_Resize			_SetOrigin(NH_FILE,__LINE__) ? 0 : NHeap::Resize
#define	NH_Expand			_SetOrigin(NH_FILE,__LINE__) ? 0 : NHeap::Expand
#define	NH_Reduce			_SetOrigin(NH_FILE,__LINE__) ? 0 : NHeap::Reduce
#define	NH_Insert			_SetOrigin(NH_FILE,__LINE__) ? 0 : NHeap::Insert
#define	NH_Append			_SetOrigin(NH_FILE,__LINE__) ? 0 : NHeap::Append
#define	NH_Prepend			_SetOrigin(NH_FILE,__LINE__) ? 0 : NHeap::Prepend
#define	NH_Duplicate		_SetOrigin(NH_FILE,__LINE__) ? 0 : NHeap::Duplicate
#define	NH_GetSize			_SetOrigin(NH_FILE,__LINE__) ? 0 : NHeap::GetSize
#define	NH_GetHeap			_SetOrigin(NH_FILE,__LINE__) ? 0 : NHeap::GetHeap
#else
#define	NH_Resize			_SetOrigin(NH_FILE,__LINE__)->NHeap::Resize
#define	NH_Expand			_SetOrigin(NH_FILE,__LINE__)->NHeap::Expand
#define	NH_Reduce			_SetOrigin(NH_FILE,__LINE__)->NHeap::Reduce
#define	NH_Insert			_SetOrigin(NH_FILE,__LINE__)->NHeap::Insert
#define	NH_Append			_SetOrigin(NH_FILE,__LINE__)->NHeap::Append
#define	NH_Prepend			_SetOrigin(NH_FILE,__LINE__)->NHeap::Prepend
#define	NH_Duplicate		_SetOrigin(NH_FILE,__LINE__)->NHeap::Duplicate
#define	NH_GetSize			_SetOrigin(NH_FILE,__LINE__)->NHeap::GetSize
#define	NH_GetHeap			_SetOrigin(NH_FILE,__LINE__)->NHeap::GetHeap
#endif
#define	NH_Free				_SetOrigin(NH_FILE,__LINE__), NHeap::Free
#define	NH_FreePtr			_SetOrigin(NH_FILE,__LINE__), NHeap::FreePtr
#define	NH_UnfreezeFree		_SetOrigin(NH_FILE,__LINE__), NHeap::UnfreezeFree


#ifdef NH_MACROS
////////////////
#define	MainAlloc		NHeap::Main()->Alloc
#define	MainAllocArray	NHeap::Main()->AllocArray
#define	MainStoreData	NHeap::Main()->StoreData
#define	MainStoreString	NHeap::Main()->StoreString
#define	Alloc			NH_Alloc
#define	AllocArray		NH_AllocArray
#define	StoreData		NH_StoreData
#define	StoreString		NH_StoreString
#define	Clear			NH_Clear
#define	Resize			NH_Resize
#define	Expand			NH_Expand
#define	Reduce			NH_Reduce
#define	Insert			NH_Insert
#define	Append			NH_Append
#define	Prepend			NH_Prepend
#define	Duplicate		NH_Duplicate
#define	GetSize			NH_GetSize
#define	GetHeap			NH_GetHeap
#define	Free			NH_Free
#define	FreePtr			NH_FreePtr
#define	UnfreezeFree	NH_UnfreezeFree
#else	// ! NH_MACROS
////////////////////
#define	MainAlloc		NHeap::Main()->NHAlloc
#define	MainAllocArray	NHeap::Main()->NHAllocArray
#define	MainStoreData	NHeap::Main()->NHStoreData
#define	MainStoreString	NHeap::Main()->NHStoreString
#define	NHAlloc			NH_Alloc
#define	NHAllocArray	NH_AllocArray
#define	NHStoreData		NH_StoreData
#define	NHStoreString	NH_StoreString
#define	NHClear			NH_Clear
#define	NHResize		NH_Resize
#define	NHExpand		NH_Expand
#define	NHReduce		NH_Reduce
#define	NHInsert		NH_Insert
#define	NHAppend		NH_Append
#define	NHPrepend		NH_Prepend
#define	NHDuplicate		NH_Duplicate
#define	NHGetSize		NH_GetSize
#define	NHGetHeap		NH_GetHeap
#define	NHFree			NH_Free
#define	NHFreePtr		NH_FreePtr
#define	NHUnfreezeFree	NH_UnfreezeFree
#endif	// ! NH_MACROS

#else	// ! NH_DEBUG
#define	NHAlloc			Alloc
#define	NHAllocArray	AllocArray
#define	NHStoreData		StoreData
#define	NHStoreString	StoreString
#define	NHResize		Resize
#define	NHExpand		Expand
#define	NHReduce		Reduce
#define	NHInsert		Insert
#define	NHAppend		Append
#define	NHPrepend		Prepend
#define	NHDuplicate		Duplicate
#define	NHGetSize		GetSize
#define	NHGetHeap		GetHeap
#define	NHFree			Free
#define	NHFreePtr		FreePtr
#define	NHClear			Clear
#define	NHUnfreezeFree	UnfreezeFree
#endif	// ! NH_DEBUG

/* -------------------------------------------------------------------------- */

#ifdef NH_DEBUG
///////////////

// Utility macros for debugging
#define	__line_(x)	__line##x
#define	_line_(x) 	__line_(x)
#define	UniqueIdent	_line_(__LINE__)

#define	SET_CONTEXT(s)	\
		static unsigned long UniqueIdent; UniqueIdent++; NHContext __context(s, UniqueIdent);

#define	RENAME_CONTEXT(s)			\
		static unsigned long UniqueIdent; UniqueIdent++; __context.Rename(s, UniqueIdent);

#define	WATCH_LEAKS(heap,context)	\
		SET_CONTEXT(context);	\
		NHLeak __leak(heap,1,NH_FILE,__LINE__)

#define	WATCH_MY_LEAKS(heap,context)	\
		SET_CONTEXT(context);	\
		NHLeak __leak(heap,0,NH_FILE,__LINE__)

#define	ACCEPT_LEAKS(heap)	\
		NHAcceptLeak __accept_leak(heap)

#define	REPORT_LEAKS()			__leak.Check(0,0,NH_FILE,__LINE__);

#define	REPORT_OVERWRITES(heap)			\
			{							\
			NHOverwrite overwrite(heap);	\
			overwrite.Check(NH_FILE,__LINE__);			\
			}

#define	CHECK_BLOCK(p)	NHeap::CheckBlock(p,NH_FILE,__LINE__)

// When you think a heap usage is not subject to any bug any more, you can
// specify the flag NH_NO_DEBUG in the heap constructor. In that way, the
// heap access will be more efficient both in terms of speed and memory usage.
// If, however, you want to debug all heaps later, instead of removing the flag
// in each constructor, you can define globally the symbol NH_DEBUG_ALL_HEAPS.
#ifdef NH_DEBUG_ALL_HEAPS
#define	NH_NO_DEBUG	0
#else
#define	NH_NO_DEBUG	NHeap::noDebug
#endif

/* -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  -  */

#else	// ! NH_DEBUG
////////////////////

#define	SET_CONTEXT(s)
#define	RENAME_CONTEXT(s)
#define	WATCH_LEAKS(heap,context)
#define	WATCH_MY_LEAKS(heap,context)
#define	ACCEPT_LEAKS(heap)
#define	REPORT_LEAKS()
#define	REPORT_OVERWRITES(heap)
#define	CHECK_BLOCK(p)
#define	NH_NO_DEBUG	0

#endif	// ! NH_DEBUG
//////////////////////

/* -------------------------------------------------------------------------- */

#endif	// NEWDEBUG_H

