/*  VCSPUT.C
 *
 *  NEW -- by Scott R. Houck
 */

#include <string.h>
#include <conio.h>
#include <io.h>
#include <process.h>
#include "new.h"

static void MakeLogfile(char *, char *);

int VCSput(NODEPTR lnode, char *dispname, FILE *vf)
{
   NODEPTR n;
   char *putflags = "-U -N";
   char logfile[13], logpath[128], logspec[128];
   int foundlog = NO;
   int answer;

   // check for the existence of a logfile
   MakeLogfile(lnode->finfo.name, logfile);
   for (n = dirList; n; n = n->next)
      {
      sprintf(logpath, "%s\\%s", n->path, logfile);
      if (access(logpath, 0) == 0)
         {
         foundlog = YES;
         break;
         }
      }
   if (!foundlog)
      return ABORT;

   /* Since I've already searched through the directories
    * specified by VCSDIR, there's no reason to wait for
    * PVCS to do the same thing, so specify the directory
    * in the PUT command.
    */
   sprintf(logspec, "%s(%s)", logpath, dispname);
   strlwr(logspec);
   if (vfile)
      fprintf(vf, "PUT %s %s\n", putflags, logspec);
   else
      {
      // print the command if /K1 or /K2
      sprintf(expstr, "PUT %s %s", putflags, logspec);
      if (quiet && (koption == 1 || koption == 2))
         printf("\n%s\n\n", expstr);
      if (kbhit() && getch() == ESC)
         {
         fprintf(stderr, "\n<Escape>\n");
         return ABORT;
         }
      if (quiet || (answer = Confirm(expstr)) == YES)
         lnode->vcsCode = (char) spawnlp(P_WAIT, "put.exe", "PUT",
            putflags, logspec, NULL);
      if (answer == ABORT)
         return ABORT;
      }

   return SUCCESS;
}


static void MakeLogfile(char *filename, char *logfile)
{
   char *p;

   strcpy(logfile, filename);
   if ((p = strchr(logfile, '.')) == NULL)
      strcat(logfile, ".__v");
   else
      {
      if (!*++p)
         strcat(logfile, "__v");
      else
         {
         if (!*++p)
            strcat(logfile, "_v");
         else
            {
            *++p = 'v';
            *++p = EOS;
            }
         }
      }
}

