/*  VALTOPT.C
 *
 *  NEW -- by Scott R. Houck
 */

#include "new.h"

void ValidateToption()
{
   char *msg;
   static char mlen[12] =
      { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

   if (t_month < 1 || t_month > 12)
      Fatal("Invalid month specified in /T option");

   msg = "Invalid day specified in /T option";

   if (t_day < 1)
      Fatal(msg);

   if (t_day > mlen[ t_month - 1 ])
      {
      if (t_month == 2 && t_year % 4 == 0 && t_day == 29)
         ;  // valid leap year
      else
         Fatal(msg);
      }

   if (t_year < 80)
      Fatal("Year in /T option cannot be less than 80");

   msg = "Invalid hour specified in /T option";

   if (got_am || got_pm)   // i.e., user specified am or pm
      {
      if (t_hour < 1 || t_hour > 12)
         Fatal(msg);
      if (got_am)
         {
         if (t_hour == 12)
            t_hour = 0;
         }
      else  // got_pm
         {
         if (t_hour != 12)
            t_hour += 12;
         }
      }
   else
      {
      if (t_hour > 23)
         Fatal(msg);
      }

   if (t_minute > 59)
      Fatal("Minutes in /T option cannot be greater than 59");

   if (t_second > 59)
      Fatal("Seconds in /T option cannot be greater than 59");
}

