/*  TRIM.C
 *
 *  NEW -- by Scott R. Houck
 *
 *  rtrim deletes trailing whitespace
 *  ltrim deletes leading whitespace
 */

#include <ctype.h>
#include <string.h>
#include "new.h"

char *rtrim(char *str)
{
   char *p;

   for (p = str + strlen(str) - 1; p >= str && isspace(*p); p--)
      ;
   *++p = EOS;
   return str;
}


char *ltrim(char *str)
{
   char *p;

   for (p = str; isspace(*p); p++)
      ;
   memmove(str, p, strlen(p) + 1);
   return str;
}

