/*  SOUND.C
 *
 *  NEW -- by Scott R. Houck
 */

#include "new.h"

static void soundoff(void);
static void soundon(int);

void sound(int freq, long dur)
{
   soundon(freq);
   delay(dur);
   soundoff();
}


static void soundon(int frequency)
{
   _asm
      {
      mov  cx,frequency      ; get frequency
      mov  dx,12             ; upper part of numerator
      mov  ax,34DEh          ; lower part of numerator
      div  cx                ; Divide specified frequency into
                             ; 1,193,182 hz clock freq used by
                             ; timer
      mov  cx,ax             ; result in AX
      mov  al,cl             ; lower byte out to timer
      out  42h,al
      mov  al,ch             ; high byte out to timer
      out  42h,al
      in   al,61h            ; get contents of system port B
      or   al,3              ; turn speaker and timer on
      out  61h,al            ; send out new values to port B
      }
}


static void soundoff()
{
   _asm
      {
      in   al,61h            ; get contents of system port B
      and  al,11111100b      ; turn speaker and timer off
      out  61h,al            ; send out new values to port B
      }
}

