/*  SORT.C
 *
 *  NEW -- by Scott R. Houck
 */

#include <string.h>
#include "new.h"

// Sort by name -- /ON
int _cdecl compare_n(NODEPTR *arg1, NODEPTR *arg2)
{
   int result = strcmp((*arg1)->finfo.name, (*arg2)->finfo.name);

   if (result)
      return result * order;

   return strcmp((*arg1)->path, (*arg2)->path) * order;
}


// Sort by extension -- /OE
int _cdecl compare_e(NODEPTR *arg1, NODEPTR *arg2)
{
   int result;
   char *p, ext1[4], ext2[4];

   if ((p = strchr((*arg1)->finfo.name, '.')) == NULL)
      *ext1 = EOS;
   else
      strcpy(ext1, p+1);

   if ((p = strchr((*arg2)->finfo.name, '.')) == NULL)
      *ext2 = EOS;
   else
      strcpy(ext2, p+1);

   result = strcmp(ext1, ext2);

   if (result)
      return result * order;

   // If same extension, transfer to compare_n
   return compare_n(arg1, arg2);
}


// Default sort by date and time -- /OD
int _cdecl compare_d(NODEPTR *arg1, NODEPTR *arg2)
{
   unsigned date1, date2, time1, time2;

   date1 = (*arg1)->finfo.wr_date;
   date2 = (*arg2)->finfo.wr_date;

   if (date1 > date2)
      return order;
   else if (date1 < date2)
      return -order;

   // If same date, check the time
   time1 = (*arg1)->finfo.wr_time;
   time2 = (*arg2)->finfo.wr_time;

   if (time1 > time2)
      return order;
   else if (time1 < time2)
      return -order;

   // If same date and time, transfer to compare_n
   return compare_n(arg1, arg2);
}


// Sort by size -- /OS
int _cdecl compare_s(NODEPTR *arg1, NODEPTR *arg2)
{
   long size1 = (*arg1)->finfo.size;
   long size2 = (*arg2)->finfo.size;

   if (size1 > size2)
      return order;
   else if (size1 < size2)
      return -order;

   // If same size, transfer to compare_n
   return compare_n(arg1, arg2);
}

