/*  PARSTTME.C
 *
 *  NEW -- by Scott R. Houck
 */

#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include "new.h"

#pragma loop_opt(off)

void ParseTtime(char *p)
{
   char *q;
   char *tdelims = ":aApP";
   char t_value[3];

   //   hh:mm[:ss][{a|p}[m]] | hh{a|p}[m]

   if (!*p)
      Fatal(t_error);

   // First character must be a digit
   if (!isdigit(*p))
      Fatal(t_error);

   q = p;   // save place

   // Next character must be a digit or one of tdelims
   if (!*++p)
      Fatal(t_error);
   if (!isdigit(*p) && !strchr(tdelims, *p))
      Fatal(t_error);

   t_value[0] = *q;
   if (isdigit(*p))
      {
      t_value[1] = *p;
      t_value[2] = EOS;
      ++p;
      }
   else
      t_value[1] = EOS;
   t_hour = atoi(t_value);

   // p should be pointing to one of the tdelims now
   if (!strchr(tdelims, *p))
      Fatal(t_error);

   if (*p != ':')    // hh{a|p}[m]
      {
      // must be 'a', 'A', 'p', or 'P'
      if (toupper(*p) == 'A')
         got_am = YES;
      else
         got_pm = YES;
      if (toupper(*(p+1)) == 'M') ++p;
      if (!*++p) return;   // e.g. 9pm
      if (*p != ',')
         Fatal(t_error);
      else
         {
         ParseTdate(p+1);
         return;
         }
      }

   // Must be hh:mm[:ss][{a|p}[m]]; next 2 characters must be minutes
   if (!*++p)
      Fatal(t_error);
   if (!isdigit(*p) || !isdigit(*(p+1)))
      Fatal("Minutes in /T option must be 2 digits");

   strncpy(t_value, p, 2);
   t_value[2] = EOS;
   t_minute = atoi(t_value);

   p += 2;
   if (!*p) return;  // e.g. 9:15

   if (*p == ',')
      {
      ParseTdate(p+1);
      return;
      }

   // Next character must be one of tdelims
   if (!strchr(tdelims, *p))
      Fatal(t_error);

   if (*p != ':')
      {
      // must be 'a', 'A', 'p', or 'P'
      if (toupper(*p) == 'A')
         got_am = YES;
      else
         got_pm = YES;
      if (toupper(*(p+1)) == 'M') ++p;
      if (!*++p) return;   // e.g. 9:15pm
      if (*p != ',')
         Fatal(t_error);
      else
         {
         ParseTdate(p+1);
         return;
         }
      }

   // Must be hh:mm:ss[{a|p}[m]]; next 2 characters must be seconds
   if (!*++p)
      Fatal(t_error);
   if (!isdigit(*p) || !isdigit(*(p+1)))
      Fatal("Seconds in /T option must be 2 digits");

   strncpy(t_value, p, 2);
   t_value[2] = EOS;
   t_second = atoi(t_value);

   p += 2;
   if (!*p) return;  // e.g. 9:15:30

   if (strchr("aApP", *p))
      {
      if (toupper(*p) == 'A')
         got_am = YES;
      else
         got_pm = YES;
      if (toupper(*(p+1)) == 'M') ++p;
      if (!*++p) return;   // e.g. 9:15:30pm
      }

   if (*p == ',')
      ParseTdate(p+1);
   else
      Fatal(t_error);
}

#pragma loop_opt(on)

