/*  PARSTOPT.C
 *
 *  NEW -- by Scott R. Houck
 */

#include <ctype.h>
#include <string.h>
#include "new.h"

void ParseToption(char *p)
{
   char *q = p + 1;  // point past the 'T'
   char *delims = "-:aApP";

   // Error if EOS
   if (!*q)
      Fatal(t_error);

   // First character must be a digit
   if (!isdigit(*q))
      Fatal(t_error);

   // Next character must be either a digit or one of delims
   if (!*++q)
      Fatal(t_error);
   if (!isdigit(*q) && !strchr(delims, *q))
      Fatal(t_error);

   if (isdigit(*q))  // Next char must be one of delims
      {
      if (!*++q)
         Fatal(t_error);
      if (!strchr(delims, *q))
         Fatal(t_error);
      }

   if (*q == '-')
      ParseTdate(p+1);
   else
      ParseTtime(p+1);
}

