/*  PARSTDTE.C
 *
 *  NEW -- by Scott R. Houck
 */

#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "new.h"

void ParseTdate(char *p)
{
   int len;
   char t_value[3];
   char *q;
   char *msg;

   if (!*p)
      Fatal(t_error);

   // convert month
   len = (*(p+1) == '-') ? 1 : 2;
   strncpy(t_value, p, len);
   t_value[len] = EOS;
   t_month = atoi(t_value);

   p += len + 1;  // skip past first '-'
   
   // Next character must be a digit -- the start of the day
   if (!*p)
      Fatal(t_error);

   msg = "Invalid day specified in /T option";
   if (!isdigit(*p))
      Fatal(msg);

   q = p;   // save place
   
   // Next character must be EOS, a digit, '-', or ','
   ++p;
   if (*p && !isdigit(*p) && *p != '-' && *p != ',')
      Fatal(msg);

   t_value[0] = *q;

   if (!isdigit(*p)) // EOS, '-', or ','
      {
      t_value[1] = EOS;
      t_day = atoi(t_value);
      if (!*p) return;     // user gave mm-d only
      }
   else
      {
      t_value[1] = *p;
      t_value[2] = EOS;
      t_day = atoi(t_value);
      if (!*++p) return;   // user gave mm-dd only
      }

   if (*p == ',')
      {
      if (!*++p)
         Fatal(t_error);
      else
         {
         ParseTtime(p);
         return;
         }
      }

   // Must be a '-' now -- expecting year
   if (*p != '-')
      Fatal(t_error);

   if (!*++p)
      Fatal(t_error);

   // Must be pointing to start of 2-digit year
   if (!isdigit(*p) || !isdigit(*(p+1)))
      Fatal(t_error);

   if (*(p+2) && *(p+2) != ',')
      Fatal("Year in /T option must be 2 digits");

   strncpy(t_value, p, 2);
   t_value[2] = EOS;
   t_year = atoi(t_value);

   p += 2;
   if (!*p) return;

   if (*p == ',')
      ParseTtime(p+1);
   else
      Fatal(t_error);
}

