/*  PARSENV.C
 *
 *  NEW -- by Scott R. Houck
 */

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "new.h"

void ParseEnvironment()
{
   char *p, *q;
   char env[128];
   char envarg[128];
   int option;
   char *ptr;

   // Check the environment for NEW options/filespecs
   if ((p = getenv("NEW")) != NULL)
      {
      strcpy(env, p);
      strcpy(origEnv, p);  // save a copy since env will be modified
      p = env;
      while (*p)
         {
         // strip off whitespace
         while (isspace(*p))
            p++;
         // scan for whitespace
         for (q = p; *q && !isspace(*q); q++)
            ;
         if (*q)
            {
            strncpy(envarg, p, q-p);
            *q = EOS;
            p = q + 1;
            }
         else
            {
            strcpy(envarg, p);
            p = q;
            }
         option = (*envarg == '/');
         ptr = strtok(envarg, "/");

         // If /C was not found on command line
         if (!command)
            {
            Parse(ptr, option, ENVIRON);
            while (!command && (ptr = strtok(NULL, "/")) != NULL)
               Parse(ptr, 1, ENVIRON);
            if (command)
               break;
            }
         else
            {
            Parse(ptr, option, ENVIRON);
            while ((ptr = strtok(NULL, "/")) != NULL)
               Parse(ptr, 1, ENVIRON);
            }
         }
      }
}

