/*  PARSAGO.C
 *
 *  NEW -- by Scott R. Houck
 */

#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include "new.h"

void ParseAgo(char *p)  //   /[n1D][n2H][n3M][n4S]
{
   int  days    = 0;
   int  hours   = 0;
   int  minutes = 0;
   int  seconds = 0;
   int  *var;
   char *q = p;

   while (*q)
      {
      while (isdigit(*q))
         ++q;
      if (!strchr("dDhHmMsS", *q))
         Fatal("Invalid character in /[n1D][n2H][n3M][n4S] option");
      switch (toupper(*q))
         {
         case 'D': var = &days;     break;
         case 'H': var = &hours;    break;
         case 'M': var = &minutes;  break;
         case 'S': var = &seconds;  break;
         }
      *q = EOS;
      *var = atoi(p);
      p = ++q;
      }

   if (seconds > 59)
      {
      minutes += seconds / 60;
      seconds %= 60;
      }
   if (minutes > 59)
      {
      hours += minutes / 60;
      minutes %= 60;
      }
   if (hours > 23)
      {
      days += hours / 24;
      hours %= 24;
      }

   t_second = curtime.second - seconds;
   t_minute = curtime.minute - minutes;
   t_hour   = curtime.hour   - hours;

   if (t_second < 0)
      {
      t_second += 60;
      --t_minute;
      }
   if (t_minute < 0)
      {
      t_minute += 60;
      --t_hour;
      }
   if (t_hour < 0)
      {
      t_hour += 24;
      ++days;
      }

   jtog(tjul-days, &t_month, &t_day, &t_year);
   t_year %= 100;

   ValidateToption();
}

