/*  MAIN.C
 *
 *  NEW -- by Scott R. Houck
 *
 *  This program prints a directory listing of files since or before a
 *  certain number of days ago.  It will also work as a "sweep" like
 *  utility if both options /A and /C are chosen.
 *
 *  Compiled with MSC version 6.0.
 */

#define MAIN

#include "new.h"

void main(int argc, char **argv)
{
   NODEPTR p;
   FIND_T dummy;

   Initialize();

   ParseCommandLine(argc, argv);

   if (!ignore)
      ParseEnvironment();

   if (!xopening)
      PrintOpening();

   if (help)
      PrintHelp();

   if (!specList)
      AddList(dummy, "*.*", &specList, &specTail);

   CalculateJul();

   if (vcsput)
      CheckVCS();

   for (p = specList; p; p = p->next)
      DoSearch(p);

   if (fileList)
      Display();

   PrintFoundMsg();

   if (vcsput)
      PrintVCSmsg();
}

