/*  LCOMMA.C
 *
 *  NEW -- by Scott R. Houck
 *
 *  This function formats a signed long integer with commas.
 *
 *  Note: str should point to a 15-byte buffer for the maximum
 *        width a signed long could have.  E.g.:  "-1,234,567,890"
 *        takes up 15 bytes counting the final NULL.
 */

#include <stdlib.h>
#include <string.h>
#include "new.h"

char *lcomma(long longval, char *str)
{
   char temp[12], *p, *q;
   int i, len, commas, start;

   p = temp;
   q = str;
   ltoa(longval, temp, 10);
   len = strlen(temp);
   if (*temp == '-')
      {
      *q++ = *p++;
      --len;
      }
   commas = (len - 1) / 3;
   start = (len + 2) % 3 + 1;
   while (start--)
      *q++ = *p++;
   while (commas--)
      {
      *q++ = ',';
      for (i = 0; i < 3; i++)
         *q++ = *p++;
      }
   *q = EOS;
   return str;
}

