/*  JULIAN.C
 *
 *  Adapted from James Seed's c_dates2 library.
 *
 *  NEW -- by Scott R. Houck
 */

#include "new.h"


/* Gregorian date to Julian date conversion
 *
 * Valid input ranges:
 *   month = 1 to 12
 *   day   = 1 to 31
 *   year  = 0 to 9999
 *
 * Note:  Julian date 1 = 1st day A.D.
 */

long gtoj(int m, int d, int y)
{
   y += (m += 9)/12 + 399;
   m %= 12;
   return (long)y*365 + y/4 - y/100 + y/400 + (153*m+2)/5 + d - 146037;
}


/* Julian date to Gregorian date conversion */

void jtog(long jul, int *m, int *d, int *y)
{
   int i;

   *y = (jul += 146037) * 400 / 146097;
   jul -= (long) *y*365 + *y/4 - *y/100 + *y/400;
   *y += jul / (i = 366 - !!((*y + 1) % 4));

   if (!(jul %= i)) jul = 365 + !(*y % 4), --*y;
   *y += (*m = (*d = (int)jul * 5 - 3) / 153 + 2) / 12 - 400;
   *m = *m % 12 + 1;
   *d = *d % 153 / 5 + 1;
}


/* Day-of-week calculation for Julian date input
 *
 * Returns 0-6 corresponding to Sunday through Saturday
 */

int dow(long jul)
{
   return (int) ((jul + 5) % 7);
}

