/*  DISPLAY.C
 *
 *  NEW -- by Scott R. Houck
 */

#include <malloc.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include "new.h"

char *fmt1   = "%2d-%02d-%02d  %2d:%02d:%02d %cm %8ld  %s\n";
char *fmt1d  = "%2d-%02d-%02d  %2d:%02d:%02d %cm <Dir>     %s\n";
char *fmt1j  = "%2d-%02d-%03d %2d:%02d:%02d %cm %8ld  %s\n";
char *fmt1dj = "%2d-%02d-%03d %2d:%02d:%02d %cm <Dir>     %s\n";

#pragma loop_opt(off)

void Display()
{
   NODEPTR *larray;  // array of ptrs to nodes in "hitfile" list
   NODEPTR lp;
   FIND_T *p;
   int i, month, day, year, hours, mins, secs, pos;
   char ampm, dispname[128], *fmt, *q;
   FILE *vf;

   /* Create an array of pointers to the nodes in the linked list,
    * sort the array using qsort, and display the directory listing.
    */
   larray = calloc(hits, sizeof(NODEPTR));
   if (!larray)
      Fatal(alloc_errmsg);
   for (i = 0, lp = fileList; i < hits; i++, lp = lp->next)
      larray[i] = lp;

   if (compare)
      {
      if (koption == 1 || koption == 3)
         fprintf(stderr, "Sorting...");
      qsort(larray, hits, sizeof(NODEPTR), compare);
      if (koption == 1 || koption == 3)
         for (i = 0; i < 10; i++)
            fprintf(stderr, "\b \b");
      }

   if (vfile)
      if ((vf = fopen(vfname, "w")) == NULL)
         Fatal("Cannot create file %s", vfname);

   for (i = 0; i < hits; i++)    // Go through the pointers in larray
      {
      ++lines;
      p = &larray[i]->finfo;
      month = PDATE(p->wr_date).mo;
      day   = PDATE(p->wr_date).da;
      year  = PDATE(p->wr_date).yr + 80;
      hours = PTIME(p->wr_time).hh;
      mins  = PTIME(p->wr_time).mm;
      secs  = PTIME(p->wr_time).ss * 2;
      ampm  = hours < 12 ? 'a' : 'p';
      hours = (hours + 11) % 12 + 1;
      if (year < 100)
         fmt = p->attrib & _A_SUBDIR ? fmt1d : fmt1;
      else
         fmt = p->attrib & _A_SUBDIR ? fmt1dj : fmt1j;

      if (format == 0)
         {
         if ((q = strchr(p->name, '.')) != NULL)
            {
            memset(dispname, ' ', 12);
            dispname[12] = EOS;
            strncpy(dispname, p->name, q - p->name);
            strncpy(&dispname[9], q+1, strlen(q+1));
            }
         else
            strcpy(dispname, p->name);
         }
      else
         {
         sprintf(dispname, "%s%s", strlwr(larray[i]->path), p->name);
         if (strlen(dispname) > 47)
            {
            pos = strchr(&dispname[3], '\\') - dispname + 1;
            strncpy(&dispname[pos], "...", 3);
            pos += 3;
            memmove(&dispname[pos], strchr(dispname, EOS)-(47-pos), 48-pos);
            }
         }

      if (p->attrib & _A_SUBDIR)
         {
         if ((!command && !vcsput) || koption == 1 || koption == 3)
            printf(fmt, month, day, year, hours, mins, secs, ampm,
               strlwr(dispname));
         }
      else
         {
         if ((!command && !vcsput) || koption == 1 || koption == 3)
            printf(fmt, month, day, year, hours, mins, secs, ampm,
               p->size, dispname);
         if (vcsput && VCSput(larray[i], dispname, vf) == ABORT)
            break;
         }

      if (command && Command(p, larray[i]->path) == ABORT)
         break;

      if (CheckPause(CHECK_ESC))
         break;
      }

   if (vfile)
      fclose(vf);
}

#pragma loop_opt(on)

