/*  DELAY.C
 *
 *  NEW -- by Scott R. Houck
 */

#include "new.h"

/*  This function holds the program in a wait state for the specified
 *  number of clock tics.  This is NOT tied to processor speed.  There
 *  are approximately 18.2 tics a second.
 */
void delay(long tics)
{
   long start; 		// hold the starting time
   long elapse;		// count of elapsed tics
   union REGS inregs, outregs;

   inregs.x.ax = 0;		// return timer count function
   int86(0x1A, &inregs, &outregs);
   start = (long) (outregs.x.cx << 16) | outregs.x.dx;
   elapse = 0L;
   while (tics > elapse)
      {
      inregs.x.ax = 0;  // return timer count function
      int86(0x1A, &inregs, &outregs);
      elapse = ((long) (outregs.x.cx << 16) | outregs.x.dx) - start;
      }
}

