/*  CONFIRM.C
 *
 *  NEW -- by Scott R. Houck
 */

#include <conio.h>
#include <ctype.h>
#include "new.h"

int Confirm(char *cmdline)
{
   int ch;
   int ok = NO;

   fprintf(stderr, "%s (Y/N/Esc)? ", cmdline);
   while (!ok)
      {
      ch = getch();
      if (ch == EOS && kbhit())
         getch();    /* eat extended key */
      ch = toupper(ch);
      ok = (ch == 'Y' || ch == 'N' || ch == ESC);
      if (!ok)
         sound(100, 2L);
      }
   if (ch == ESC)
      {
      fprintf(stderr, "<Escape>\n");
      return ABORT;
      }
   else
      {
      fprintf(stderr, "%c\n", ch);
      return (ch == 'Y') ? YES : NO;
      }
}

