/*  CHECKVCS.C
 *
 *  NEW -- by Scott R. Houck
 */

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "new.h"

#define MAXVCS 256   // maximum line in VCS configuration file

#pragma loop_opt(off)

void CheckVCS()
{
   char *p;
   FILE *config;
   char vcsline [MAXVCS];  // line in VCS configuration file
   char vcspath[128];
   int found = NO;
   int more = NO;
   int done = NO;
   int len;
   FIND_T dummy;

   if ((p = getenv("VCSCFG")) == NULL)
      Fatal("Environment variable VCSCFG not defined");

   /* Read the VCS configuration file and create a linked list of
    * the directories listed in the VCSDIR directive.
    */
   if ((config = fopen(p, "r")) == NULL)
      Fatal("Cannot open VCS config file %s", p);

   while (fgets(vcsline, MAXVCS, config))
      {
      if (!found && strncmp(vcsline, "VCSDIR", 6) == 0)
         found = YES;
      if (!found)
         continue;
      if (!more && (p = strchr(vcsline, '=')) == NULL)
         Fatal("Invalid line in VCS config file:\n%s", vcsline);
      if (more)
         p = vcsline;
      while (isspace(*++p))
         ;
      rtrim(strcpy(vcspath, p));
      len = strlen(vcspath);
      if (vcspath[len-1] == '\\')   // continuation character
         {
         more = YES;
         vcspath[len-1] = EOS;
         }
      else
         done = YES;
      p = strtok(vcspath, ";");
      while (p)
         {
         AddList(dummy, StrAlloc(p), &dirList, &dirTail);
         p = strtok(NULL, ";");
         }
      if (done)
         break;
      }

   fclose(config);

   if (!dirList)
      Fatal("VCS config file does not contain a valid VCSDIR entry");
}

#pragma loop_opt(on)

