/*  NEW.H
 *
 *  NEW -- by Scott R. Houck
 */

#include <stdio.h>
#include <dos.h>


#define VERSION "2.7"

struct packed_date {
   unsigned da : 5;
   unsigned mo : 4;
   unsigned yr : 7;
};

struct packed_time {
   unsigned ss : 5;
   unsigned mm : 6;
   unsigned hh : 5;
};

#define PDATE(d) (*(struct packed_date *)(&(d)))
#define PTIME(t) (*(struct packed_time *)(&(t)))

typedef struct find_t      FIND_T;
typedef struct dosdate_t   DOSDATE_T;
typedef struct dostime_t   DOSTIME_T;
typedef struct node        NODE, *NODEPTR;

struct node {
   FIND_T   finfo;
   char *   path;
   char     vcsCode;
   NODEPTR  next;
};

#define NO  0
#define YES 1

#define EOS    '\0'
#define CRET   '\r'
#define ESC    27

// "modes" for Parse() function
#define CMDLINE 0
#define ENVIRON 1

// options for CheckPause() function
#define DONT_CHECK_ESC  0
#define CHECK_ESC       1

// "Make Far Pointer" macro
#define MK_FP(seg, offset) \
   ((void _far *)(((unsigned long)(seg)<<16) | (unsigned)(offset)))

#define SUCCESS   0
#define ABORT     2

// Sort orders
#define ASCENDING    1
#define DESCENDING  -1

// public function prototypes

NODEPTR AddList(FIND_T, char *, NODEPTR *, NODEPTR *);   // addlist.c
void    CalculateJul(void);                              // calcjul.c
void    CheckVCS(void);                                  // checkvcs.c
int     CheckPause(int);                                 // chkpause.c
int     Command(FIND_T *, char *);                       // command.c
int     Confirm(char *);                                 // confirm.c
void    ResetCursor(void);                               // cursor.c
void    HideCursor(void);                                // cursor.c
void    delay(long);                                     // delay.c
void    Display(void);                                   // display.c
void    Fatal(char *, ...);                              // fatal.c
void    Initialize(void);                                // init.c
long    gtoj(int, int, int);                             // julian.c
void    jtog(long, int *, int *, int *);                 // julian.c
int     dow(long);                                       // julian.c
char *  lcomma(long, char *);                            // lcomma.c
void    ParseAgo(char *);                                // parsago.c
void    ParseCommandLine(int, char **);                  // parscmd.c
void    Parse(char *, int, int);                         // parse.c
void    ParseEnvironment(void);                          // parsenv.c
void    ParseTdate(char *);                              // parstdte.c
void    ParseToption(char *);                            // parstopt.c
void    ParseTtime(char *);                              // parsttme.c
void    PrintFoundMsg(void);                             // prtfound.c
void    PrintHelp(void);                                 // prthelp.c
void    PrintOpening(void);                              // prtopen.c
void    PrintVCSmsg(void);                               // prtvcs.c
char *  Replace(char *, char *, char *, int);            // replace.c
void    DoSearch(NODEPTR);                               // search.c
int     _cdecl compare_n(NODEPTR *, NODEPTR *);          // sort.c
int     _cdecl compare_e(NODEPTR *, NODEPTR *);          // sort.c
int     _cdecl compare_d(NODEPTR *, NODEPTR *);          // sort.c
int     _cdecl compare_s(NODEPTR *, NODEPTR *);          // sort.c
void    sound(int, long);                                // sound.c
char *  StrAlloc(char *);                                // stralloc.c
char *  rtrim(char *);                                   // trim.c
char *  ltrim(char *);                                   // trim.c
void    ValidateToption(void);                           // valtopt.c
int     VCSput(NODEPTR, char *, FILE *);                 // vcsput.c


// global variables

#ifdef MAIN

int       allfiles = NO;    // option /A
int       command  = NO;    // option /C
int       dirs     = NO;    // option /D
int       dirsonly = NO;    // option /DO
int       entire   = NO;    // option /E
int       guru     = NO;    // option /G
int       help     = NO;    // option /H
int       ignore   = NO;    // option /I
int       junk     = NO;    // option /J
int       pausing  = NO;    // option /P
int       quiet    = NO;    // option /Q
int       subdirs  = NO;    // option /S
int       tstamp   = NO;    // option /T
int       vcsput   = NO;    // option /V
int       xopening = NO;    // option /X
int       before   = NO;    // option /-n

DOSDATE_T curdate;          // current date
DOSTIME_T curtime;          // current time
int       numrows;          // number of text rows in current screen mode
size_t    hits     = 0;     // number of files NEW has found
int       lines    = 0;     // number of lines of output from NEW
long      since    = 0L;    // number of days ago to search for
long      jul;              // date to check for
long      tjul;             // today's date
int       format   = 1;     // default display format
int       koption  = 1;     // default option for /K
NODEPTR   fileList = NULL;  // list of "hitfile" information
NODEPTR   fileTail = NULL;  // end of "hitfile" list
NODEPTR   specList = NULL;  // list of filespecs
NODEPTR   specTail = NULL;  // end of filespec list
char      cmdstr   [127];   // string used in /C option
char      origTail [128];   // original unformatted command tail
char      origEnv  [128];   // original value of environment variable NEW
char      expstr   [512];   // expanded string passed to COMMAND.COM
long      totalbytes = 0L;  // total size of files found by NEW

char     *alloc_errmsg = "Insufficient memory for dynamic allocation";
int       printedOpening = NO;

// pointer to compare function
int       (_cdecl *compare)(const void *, const void *) = compare_d;

int       order = DESCENDING;    // default sort order

// variables for /T option
int       t_month;          // timestamp month
int       t_day;            // timestamp day
int       t_year;           // timestamp year
int       t_hour;           // timestamp hour
int       t_minute;         // timestamp minute
int       t_second;         // timestamp second
unsigned  t_date;           // timestamp date in packed date format
unsigned  t_time;           // timestamp time in packed time format
int       got_am = NO;      // whether user specified a[m]
int       got_pm = NO;      // whether user specified p[m]
char     *t_error = "Invalid timestamp in /T option";

// variables for /V option
int       vfile    = NO;    // whether a file was specified for /V
char      vfname [127];     // optional filename for /V
NODEPTR   dirList  = NULL;  // list of directories in VCS config file
NODEPTR   dirTail  = NULL;  // end of VCS directory list


#else

extern  int       allfiles;
extern  int       command;
extern  int       dirs;
extern  int       dirsonly;
extern  int       entire;
extern  int       guru;
extern  int       help;
extern  int       ignore;
extern  int       junk;
extern  int       pausing;
extern  int       quiet;
extern  int       subdirs;
extern  int       tstamp;
extern  int       vcsput;
extern  int       xopening;
extern  int       before;
extern  DOSDATE_T curdate;
extern  DOSTIME_T curtime;
extern  int       numrows;
extern  size_t    hits;
extern  int       lines;
extern  long      since;
extern  long      jul;
extern  long      tjul;
extern  int       format;
extern  int       koption;
extern  NODEPTR   fileList;
extern  NODEPTR   fileTail;
extern  NODEPTR   specList;
extern  NODEPTR   specTail;
extern  char      cmdstr   [127];
extern  char      origTail [128];
extern  char      origEnv  [128];
extern  char      expstr   [512];
extern  long      totalbytes;
extern  char     *alloc_errmsg;
extern  int       printedOpening;
extern  int       (_cdecl *compare)(const void *, const void *);
extern  int       order;
extern  int       t_month;
extern  int       t_day;
extern  int       t_year;
extern  int       t_hour;
extern  int       t_minute;
extern  int       t_second;
extern  unsigned  t_date;
extern  unsigned  t_time;
extern  int       got_am;
extern  int       got_pm;
extern  char     *t_error;
extern  int       vfile;
extern  char      vfname [127];
extern  NODEPTR   dirList;
extern  NODEPTR   dirTail;

#endif

