/*  COMMAND.C
 *
 *  NEW -- by Scott R. Houck
 */

#include <string.h>
#include <conio.h>
#include <stdlib.h>
#include "new.h"

int Command(FIND_T *p, char *path)
{
   int dirflag, answer;
   char dispname[128];

   if (p->attrib & _A_SUBDIR)
      strlwr(p->name);

   sprintf(dispname, "%s%s", strlwr(path), p->name);
   if (p->attrib & _A_SUBDIR)
      {
      strcat(dispname, "\\X.X");
      dirflag = 1;
      }
   else
      dirflag = 0;

   Replace(expstr, cmdstr, dispname, dirflag);
   ltrim(expstr);
   if (strlen(expstr) > 127)
      Fatal("Command '%s' is too long (max is 127)", expstr);
   else
      {
      /* print the command if /K1 or /K2 */
      if (quiet && (koption == 1 || koption == 2))
         printf("%s\n", expstr);
      /* execute the command */
      if (kbhit() && getch() == ESC)
         {
         fprintf(stderr, "\n<Escape>\n");
         return ABORT;
         }
      if (quiet || (answer = Confirm(expstr)) == YES)
         system(expstr);
      if (answer == ABORT)
         return ABORT;
      }

   return SUCCESS;
}

