/*  CALCJUL.C
 *
 *  NEW -- by Scott R. Houck
 */

#include <io.h>
#include "new.h"

void CalculateJul()
{
   char ampm;
   int month, day, year;
   static char *cdow[] = { "Sunday", "Monday", "Tuesday", "Wednesday",
      "Thursday", "Friday", "Saturday" };

   if (curtime.hour < 6)
      ++since;

   if (tstamp)
      {
      jul = gtoj(t_month, t_day, t_year + 1900);
      PDATE(t_date).mo = t_month;
      PDATE(t_date).da = t_day;
      PDATE(t_date).yr = t_year - 80;
      PTIME(t_time).hh = t_hour;
      PTIME(t_time).mm = t_minute;
      PTIME(t_time).ss = t_second / 2 + t_second % 2;
      }
   else
      jul = tjul - since;

   jtog(jul, &month, &day, &year);

   if (!xopening)
      {
      if (allfiles)
         printf("Directory of ALL matching files\n\n");
      else if (tstamp)
         printf("Directory %s %d:%02d:%02d %cm %s, %d-%02d-%02d\n\n",
            before ? "before" : "since", (t_hour + 11) % 12 + 1, t_minute,
            t_second, (t_hour < 12 ? 'a' : 'p'), cdow[dow(jul)], t_month,
            t_day, t_year);
      else
         printf("Directory %s 6 am %s, %d-%02d-%02d\n\n",
            before ? "before" : "since",
            cdow[dow(jul)], month, day, year % 100);
      lines += 2;
      }

   if (subdirs || entire)
      if (!isatty(fileno(stdout)))
         fprintf(stderr, "\n");
}

