/*  SEARCH.C
 *
 *  NEW -- by Scott R. Houck
 */

#include <string.h>
#include <stdlib.h>
#include "new.h"

static void Search(char *, char *);

void DoSearch(NODEPTR n)
{
   char fullpath[128];
   char basepath[128];
   char filespec[13];
   char *p;
   int len;

   if (n->path[0] == '.' && n->path[1] != '.')
   // e.g. "NEW .C" ==> "NEW *.C" but not "NEW .."
      sprintf(filespec, "*%s", n->path);
   else
      strcpy(filespec, n->path);
   strupr(filespec);
   _fullpath(fullpath, filespec, 128);

   if (strchr(fullpath, '*') == NULL && strchr(fullpath, '?') == NULL)
      {
      if (fullpath[strlen(fullpath)-1] == '\\')
         strcat(fullpath, "*.*");
      else
         strcat(fullpath, "\\*.*");
      }

   p = strrchr(fullpath, '\\');
   len = p - fullpath + 1;
   strncpy(basepath, fullpath, len);
   basepath[len] = EOS;
   strcpy(filespec, p+1);

   if (entire)
      {
      subdirs = YES;
      basepath[3] = EOS;
      fullpath[2] = EOS;
      strcat(fullpath, filespec);
      }

   if (subdirs)
      HideCursor();

   Search(basepath, filespec);

   if (subdirs)
      {
      fprintf(stderr, "%-79s\r", "");
      ResetCursor();
      }
}


#pragma loop_opt(off)

static void Search(char *basepath, char *filespec)
{
   char findspec [256];   // filespec for files to be searched
   unsigned mask = _A_SUBDIR | _A_HIDDEN | _A_SYSTEM;
   FIND_T file;
   int done, month, day, year, hours, isadir;
   long fjul;
   char nextpath [128];
   int first = YES;
   char *pa;

   // search the current basepath for the given filespec
   strcat(strcpy(findspec, basepath), filespec);

   done = _dos_findfirst(findspec, mask, &file);

   while (!done)
      {
      hours  = PTIME(file.wr_time).hh;
      month  = PDATE(file.wr_date).mo;
      day    = PDATE(file.wr_date).da;
      year   = PDATE(file.wr_date).yr + 1980;
      fjul   = gtoj(month, day, year);
      isadir = file.attrib & _A_SUBDIR;

   /*
    *                       ** WARNING **
    *
    *   The following if statement may be hazardous to your health!
    *
    */

      if (
            (
               allfiles ||

               (
                  (
                     (!before &&

                        (
                           (!tstamp &&
                              (fjul > jul || (fjul == jul && hours >= 6))
                           )
                               ||
                           (tstamp &&
                              (file.wr_date > t_date ||
                                 (file.wr_date == t_date &&
                                  file.wr_time >= t_time
                                 )
                              )
                           )
                        )
                     )     // !before

                    ||

                     ( before &&

                        (

                           (!tstamp &&
                              (fjul < jul || (fjul == jul && hours < 6))
                           )
                               ||
                           (tstamp &&
                              (file.wr_date < t_date ||
                                 (file.wr_date == t_date &&
                                  file.wr_time < t_time
                                 )
                              )
                           )
                        )
                     )     // before
                  )
                         &&
                  (
                     junk || fjul <= tjul
                  )
               )
            )

            &&

            (file.name[0] != '.')
               
            &&

            (
               dirs ||
               (dirsonly && isadir) ||
               (!dirs && !dirsonly && !isadir)
            )
         )

         {
         ++hits;
         if (first)
            {
            pa = StrAlloc(basepath);
            first = NO;
            }
         totalbytes += file.size;
         AddList(file, pa, &fileList, &fileTail);
         }

      done = _dos_findnext(&file);

      }

   if (subdirs)
      {
      fprintf(stderr, "%-79s\r", basepath);
      // search for more directories
      strcat(strcpy(findspec, basepath), "*.*");
      done = _dos_findfirst(findspec, mask, &file);
      while (!done)
         {
         if ((file.attrib & _A_SUBDIR) && file.name[0] != '.')
            {
            sprintf(nextpath, "%s%s\\", basepath, file.name);
            Search(nextpath, filespec);
            }
         done = _dos_findnext(&file);
         }
      }
}

#pragma loop_opt(on)

